/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.io.Serializable;
import java.util.stream.Stream;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CartesianOrbit
extends Orbit {
    private static final long serialVersionUID = 20170414L;
    private static final DSFactory FACTORY = new DSFactory(1, 1);
    private final transient boolean hasNonKeplerianAcceleration;
    private transient EquinoctialOrbit equinoctial;

    public CartesianOrbit(TimeStampedPVCoordinates pvaCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = CartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
    }

    public CartesianOrbit(PVCoordinates pvaCoordinates, Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        this(new TimeStampedPVCoordinates(date, pvaCoordinates), frame, mu);
    }

    public CartesianOrbit(Orbit op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof EquinoctialOrbit ? (EquinoctialOrbit)op : (op instanceof CartesianOrbit ? ((CartesianOrbit)op).equinoctial : null);
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = this.hasDerivatives() ? new EquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu()) : new EquinoctialOrbit(new PVCoordinates(this.getPVCoordinates().getPosition(), this.getPVCoordinates().getVelocity()), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    private FieldVector3D<DerivativeStructure> getPositionDS() {
        Vector3D p = this.getPVCoordinates().getPosition();
        Vector3D v = this.getPVCoordinates().getVelocity();
        return new FieldVector3D((RealFieldElement)FACTORY.build(new double[]{p.getX(), v.getX()}), (RealFieldElement)FACTORY.build(new double[]{p.getY(), v.getY()}), (RealFieldElement)FACTORY.build(new double[]{p.getZ(), v.getZ()}));
    }

    private FieldVector3D<DerivativeStructure> getVelocityDS() {
        Vector3D v = this.getPVCoordinates().getVelocity();
        Vector3D a = this.getPVCoordinates().getAcceleration();
        return new FieldVector3D((RealFieldElement)FACTORY.build(new double[]{v.getX(), a.getX()}), (RealFieldElement)FACTORY.build(new double[]{v.getY(), a.getY()}), (RealFieldElement)FACTORY.build(new double[]{v.getZ(), a.getZ()}));
    }

    @Override
    public double getA() {
        double r = this.getPVCoordinates().getPosition().getNorm();
        double V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return r / (2.0 - r * V2 / this.getMu());
    }

    @Override
    public double getADot() {
        if (this.hasDerivatives()) {
            DerivativeStructure r = (DerivativeStructure)this.getPositionDS().getNorm();
            DerivativeStructure V2 = (DerivativeStructure)this.getVelocityDS().getNormSq();
            DerivativeStructure a = r.divide(r.multiply(V2).divide(this.getMu()).subtract(2.0).negate());
            return a.getPartialDerivative(new int[]{1});
        }
        return Double.NaN;
    }

    @Override
    public double getE() {
        double muA = this.getMu() * this.getA();
        if (muA > 0.0) {
            Vector3D pvP = this.getPVCoordinates().getPosition();
            Vector3D pvV = this.getPVCoordinates().getVelocity();
            double rV2OnMu = pvP.getNorm() * pvV.getNormSq() / this.getMu();
            double eSE = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)muA);
            double eCE = rV2OnMu - 1.0;
            return FastMath.sqrt((double)(eCE * eCE + eSE * eSE));
        }
        Vector3D pvM = this.getPVCoordinates().getMomentum();
        return FastMath.sqrt((double)(1.0 - pvM.getNormSq() / muA));
    }

    @Override
    public double getEDot() {
        if (this.hasDerivatives()) {
            FieldVector3D<DerivativeStructure> pvP = this.getPositionDS();
            FieldVector3D<DerivativeStructure> pvV = this.getVelocityDS();
            DerivativeStructure r = (DerivativeStructure)this.getPositionDS().getNorm();
            DerivativeStructure V2 = (DerivativeStructure)this.getVelocityDS().getNormSq();
            DerivativeStructure rV2OnMu = r.multiply(V2).divide(this.getMu());
            DerivativeStructure a = r.divide(rV2OnMu.negate().add(2.0));
            DerivativeStructure eSE = ((DerivativeStructure)FieldVector3D.dotProduct(pvP, pvV)).divide(a.multiply(this.getMu()).sqrt());
            DerivativeStructure eCE = rV2OnMu.subtract(1.0);
            DerivativeStructure e = eCE.multiply(eCE).add(eSE.multiply(eSE)).sqrt();
            return e.getPartialDerivative(new int[]{1});
        }
        return Double.NaN;
    }

    @Override
    public double getI() {
        return Vector3D.angle((Vector3D)Vector3D.PLUS_K, (Vector3D)this.getPVCoordinates().getMomentum());
    }

    @Override
    public double getIDot() {
        if (this.hasDerivatives()) {
            FieldVector3D momentum = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS());
            DerivativeStructure i = (DerivativeStructure)FieldVector3D.angle((Vector3D)Vector3D.PLUS_K, (FieldVector3D)momentum);
            return i.getPartialDerivative(new int[]{1});
        }
        return Double.NaN;
    }

    @Override
    public double getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public double getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public double getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public double getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public double getHx() {
        Vector3D w = this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return -w.getY() / (1.0 + w.getZ());
    }

    @Override
    public double getHxDot() {
        if (this.hasDerivatives()) {
            FieldVector3D w = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS()).normalize();
            double x = ((DerivativeStructure)w.getX()).getValue();
            double y = ((DerivativeStructure)w.getY()).getValue();
            double z = ((DerivativeStructure)w.getZ()).getValue();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return Double.NaN;
            }
            DerivativeStructure hx = ((DerivativeStructure)w.getY()).negate().divide(((DerivativeStructure)w.getZ()).add(1.0));
            return hx.getPartialDerivative(new int[]{1});
        }
        return Double.NaN;
    }

    @Override
    public double getHy() {
        Vector3D w = this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return w.getX() / (1.0 + w.getZ());
    }

    @Override
    public double getHyDot() {
        if (this.hasDerivatives()) {
            FieldVector3D w = FieldVector3D.crossProduct(this.getPositionDS(), this.getVelocityDS()).normalize();
            double x = ((DerivativeStructure)w.getX()).getValue();
            double y = ((DerivativeStructure)w.getY()).getValue();
            double z = ((DerivativeStructure)w.getZ()).getValue();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return Double.NaN;
            }
            DerivativeStructure hy = ((DerivativeStructure)w.getX()).divide(((DerivativeStructure)w.getZ()).add(1.0));
            return hy.getPartialDerivative(new int[]{1});
        }
        return Double.NaN;
    }

    @Override
    public double getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public double getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public double getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public double getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public double getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public double getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected TimeStampedPVCoordinates initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public CartesianOrbit shiftedBy(double dt) {
        PVCoordinates shiftedPV = this.getA() < 0.0 ? this.shiftPVHyperbolic(dt) : this.shiftPVElliptic(dt);
        return new CartesianOrbit(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    @Override
    public CartesianOrbit interpolate(AbsoluteDate date, Stream<Orbit> sample) {
        TimeStampedPVCoordinates interpolated = TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_PVA, sample.map(orbit -> orbit.getPVCoordinates()));
        return new CartesianOrbit(interpolated, this.getFrame(), date, this.getMu());
    }

    private PVCoordinates shiftPVElliptic(double dt) {
        Vector3D pvP = this.getPVCoordinates().getPosition();
        Vector3D pvV = this.getPVCoordinates().getVelocity();
        double r2 = pvP.getNormSq();
        double r = FastMath.sqrt((double)r2);
        double rV2OnMu = r * pvV.getNormSq() / this.getMu();
        double a = this.getA();
        double eSE = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)(this.getMu() * a));
        double eCE = rV2OnMu - 1.0;
        double e2 = eCE * eCE + eSE * eSE;
        Vector3D u = pvP.normalize();
        Vector3D v = Vector3D.crossProduct((Vector3D)this.getPVCoordinates().getMomentum(), (Vector3D)u).normalize();
        double ex = (eCE - e2) * a / r;
        double ey = -FastMath.sqrt((double)(1.0 - e2)) * eSE * a / r;
        double beta = 1.0 / (1.0 + FastMath.sqrt((double)(1.0 - e2)));
        double thetaE0 = FastMath.atan2((double)(ey + eSE * beta * ex), (double)(r / a + ex - eSE * beta * ey));
        double thetaM0 = thetaE0 - ex * FastMath.sin((double)thetaE0) + ey * FastMath.cos((double)thetaE0);
        double thetaM1 = thetaM0 + this.getKeplerianMeanMotion() * dt;
        double thetaE1 = this.meanToEccentric(thetaM1, ex, ey);
        double cTE = FastMath.cos((double)thetaE1);
        double sTE = FastMath.sin((double)thetaE1);
        double exey = ex * ey;
        double exCeyS = ex * cTE + ey * sTE;
        double x = a * ((1.0 - beta * ey * ey) * cTE + beta * exey * sTE - ex);
        double y = a * ((1.0 - beta * ex * ex) * sTE + beta * exey * cTE - ey);
        double factor = FastMath.sqrt((double)(this.getMu() / a)) / (1.0 - exCeyS);
        double xDot = factor * (-sTE + beta * ey * exCeyS);
        double yDot = factor * (cTE - beta * ex * exCeyS);
        Vector3D shiftedP = new Vector3D(x, u, y, v);
        Vector3D shiftedV = new Vector3D(xDot, u, yDot, v);
        if (this.hasNonKeplerianAcceleration) {
            Vector3D nonKeplerianAcceleration = new Vector3D(1.0, this.getPVCoordinates().getAcceleration(), this.getMu() / (r2 * r), pvP);
            Vector3D fixedP = new Vector3D(1.0, shiftedP, 0.5 * dt * dt, nonKeplerianAcceleration);
            double fixedR2 = fixedP.getNormSq();
            double fixedR = FastMath.sqrt((double)fixedR2);
            Vector3D fixedV = new Vector3D(1.0, shiftedV, dt, nonKeplerianAcceleration);
            Vector3D fixedA = new Vector3D(-this.getMu() / (fixedR2 * fixedR), shiftedP, 1.0, nonKeplerianAcceleration);
            return new PVCoordinates(fixedP, fixedV, fixedA);
        }
        return new PVCoordinates(shiftedP, shiftedV);
    }

    private PVCoordinates shiftPVHyperbolic(double dt) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D pvP = pv.getPosition();
        Vector3D pvV = pv.getVelocity();
        Vector3D pvM = pv.getMomentum();
        double r2 = pvP.getNormSq();
        double r = FastMath.sqrt((double)r2);
        double rV2OnMu = r * pvV.getNormSq() / this.getMu();
        double a = this.getA();
        double muA = this.getMu() * a;
        double e = FastMath.sqrt((double)(1.0 - Vector3D.dotProduct((Vector3D)pvM, (Vector3D)pvM) / muA));
        double sqrt = FastMath.sqrt((double)((e + 1.0) / (e - 1.0)));
        double eSH = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)(-muA));
        double eCH = rV2OnMu - 1.0;
        double H0 = FastMath.log((double)((eCH + eSH) / (eCH - eSH))) / 2.0;
        double M0 = e * FastMath.sinh((double)H0) - H0;
        double v0 = 2.0 * FastMath.atan((double)(sqrt * FastMath.tanh((double)(H0 / 2.0))));
        Vector3D p = new Rotation(pvM, v0, RotationConvention.FRAME_TRANSFORM).applyTo(pvP).normalize();
        Vector3D q = Vector3D.crossProduct((Vector3D)pvM, (Vector3D)p).normalize();
        double M1 = M0 + this.getKeplerianMeanMotion() * dt;
        double H1 = this.meanToHyperbolicEccentric(M1, e);
        double cH = FastMath.cosh((double)H1);
        double sH = FastMath.sinh((double)H1);
        double sE2m1 = FastMath.sqrt((double)((e - 1.0) * (e + 1.0)));
        double x = a * (cH - e);
        double y = -a * sE2m1 * sH;
        double factor = FastMath.sqrt((double)(this.getMu() / -a)) / (e * cH - 1.0);
        double xDot = -factor * sH;
        double yDot = factor * sE2m1 * cH;
        Vector3D shiftedP = new Vector3D(x, p, y, q);
        Vector3D shiftedV = new Vector3D(xDot, p, yDot, q);
        if (this.hasNonKeplerianAcceleration) {
            Vector3D nonKeplerianAcceleration = new Vector3D(1.0, this.getPVCoordinates().getAcceleration(), this.getMu() / (r2 * r), pvP);
            Vector3D fixedP = new Vector3D(1.0, shiftedP, 0.5 * dt * dt, nonKeplerianAcceleration);
            double fixedR2 = fixedP.getNormSq();
            double fixedR = FastMath.sqrt((double)fixedR2);
            Vector3D fixedV = new Vector3D(1.0, shiftedV, dt, nonKeplerianAcceleration);
            Vector3D fixedA = new Vector3D(-this.getMu() / (fixedR2 * fixedR), shiftedP, 1.0, nonKeplerianAcceleration);
            return new PVCoordinates(fixedP, fixedV, fixedA);
        }
        return new PVCoordinates(shiftedP, shiftedV);
    }

    private double meanToEccentric(double thetaM, double ex, double ey) {
        double thetaE = thetaM;
        double thetaEMthetaM = 0.0;
        int iter = 0;
        do {
            double cosThetaE = FastMath.cos((double)thetaE);
            double sinThetaE = FastMath.sin((double)thetaE);
            double f2 = ex * sinThetaE - ey * cosThetaE;
            double f1 = 1.0 - ex * cosThetaE - ey * sinThetaE;
            double f0 = thetaEMthetaM - f2;
            double f12 = 2.0 * f1;
            double shift = f0 * f12 / (f1 * f12 - f0 * f2);
            thetaE = thetaM + (thetaEMthetaM -= shift);
            if (!(FastMath.abs((double)shift) <= 1.0E-12)) continue;
            return thetaE;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.CONVERGENCE_FAILED, new Object[0]);
    }

    private double meanToHyperbolicEccentric(double M, double ecc) {
        double H = ecc < 1.6 ? (-Math.PI < M && M < 0.0 || M > Math.PI ? M - ecc : M + ecc) : (ecc < 3.6 && FastMath.abs((double)M) > Math.PI ? M - FastMath.copySign((double)ecc, (double)M) : M / (ecc - 1.0));
        int iter = 0;
        do {
            double f3 = ecc * FastMath.cosh((double)H);
            double f2 = ecc * FastMath.sinh((double)H);
            double f1 = f3 - 1.0;
            double f0 = f2 - H - M;
            double f12 = 2.0 * f1;
            double d = f0 / f12;
            double fdf = f1 - d * f2;
            double ds = f0 / fdf;
            double shift = f0 / (fdf + ds * ds * f3 / 6.0);
            H -= shift;
            if (!(FastMath.abs((double)shift) <= 1.0E-12)) continue;
            return H;
        } while (++iter < 50);
        throw new MathIllegalStateException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    private double[][] create6x6Identity() {
        double[][] identity = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            identity[i][i] = 1.0;
        }
        return identity;
    }

    @Override
    protected double[][] computeJacobianMeanWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected double[][] computeJacobianEccentricWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected double[][] computeJacobianTrueWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    public void addKeplerContribution(PositionAngle type, double gm, double[] pDot) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D velocity = pv.getVelocity();
        pDot[0] = pDot[0] + velocity.getX();
        pDot[1] = pDot[1] + velocity.getY();
        pDot[2] = pDot[2] + velocity.getZ();
        Vector3D position = pv.getPosition();
        double r2 = position.getNormSq();
        double coeff = -gm / (r2 * FastMath.sqrt((double)r2));
        pDot[3] = pDot[3] + coeff * position.getX();
        pDot[4] = pDot[4] + coeff * position.getY();
        pDot[5] = pDot[5] + coeff * position.getZ();
    }

    public String toString() {
        return "Cartesian parameters: " + this.getPVCoordinates().toString();
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20170414L;
        private double[] d;
        private final Frame frame;

        private DTO(CartesianOrbit orbit) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            double epoch = FastMath.floor((double)pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH));
            double offset = pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH.shiftedBy(epoch));
            this.d = orbit.hasDerivatives() ? new double[]{epoch, offset, orbit.getMu(), pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()} : new double[]{epoch, offset, orbit.getMu(), pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ()};
            this.frame = orbit.getFrame();
        }

        private Object readResolve() {
            if (this.d.length >= 12) {
                return new CartesianOrbit(new TimeStampedPVCoordinates(AbsoluteDate.J2000_EPOCH.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8]), new Vector3D(this.d[9], this.d[10], this.d[11])), this.frame, this.d[2]);
            }
            return new CartesianOrbit(new TimeStampedPVCoordinates(AbsoluteDate.J2000_EPOCH.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8])), this.frame, this.d[2]);
        }
    }
}

