/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterObserver;

public class ParameterDriver {
    private String name;
    private final double referenceValue;
    private final double scale;
    private final double minValue;
    private final double maxValue;
    private AbsoluteDate referenceDate;
    private double value;
    private boolean selected;
    private final List<ParameterObserver> observers;

    public ParameterDriver(String name, double referenceValue, double scale, double minValue, double maxValue) throws OrekitException {
        if (FastMath.abs((double)scale) <= Precision.SAFE_MIN) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SMALL_SCALE_FOR_PARAMETER, name, scale);
        }
        this.name = name;
        this.referenceValue = referenceValue;
        this.scale = scale;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceDate = null;
        this.value = referenceValue;
        this.selected = false;
        this.observers = new ArrayList<ParameterObserver>();
    }

    public void addObserver(ParameterObserver observer) throws OrekitException {
        this.observers.add(observer);
        observer.valueChanged(this.getValue(), this);
    }

    public void removeObserver(ParameterObserver observer) {
        Iterator<ParameterObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != observer) continue;
            iterator.remove();
            return;
        }
    }

    public List<ParameterObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public void setName(String name) {
        String previousName = this.name;
        this.name = name;
        for (ParameterObserver observer : this.observers) {
            observer.nameChanged(previousName, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public double getReferenceValue() {
        return this.referenceValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getScale() {
        return this.scale;
    }

    public double getNormalizedValue() {
        return (this.value - this.referenceValue) / this.scale;
    }

    public void setNormalizedValue(double normalized) throws OrekitException {
        this.setValue(this.referenceValue + this.scale * normalized);
    }

    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(AbsoluteDate newReferenceDate) {
        AbsoluteDate previousReferenceDate = this.getReferenceDate();
        this.referenceDate = newReferenceDate;
        for (ParameterObserver observer : this.observers) {
            observer.referenceDateChanged(previousReferenceDate, this);
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) throws OrekitException {
        double previousValue = this.getValue();
        this.value = FastMath.max((double)this.minValue, (double)FastMath.min((double)this.maxValue, (double)newValue));
        for (ParameterObserver observer : this.observers) {
            observer.valueChanged(previousValue, this);
        }
    }

    public void setSelected(boolean selected) {
        boolean previousSelection = this.isSelected();
        this.selected = selected;
        for (ParameterObserver observer : this.observers) {
            observer.selectionChanged(previousSelection, this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return this.name + " = " + this.value;
    }
}

