/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.SubCircle;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.models.earth.tessellation.InsideFinder;
import org.orekit.models.earth.tessellation.Mesh;
import org.orekit.models.earth.tessellation.Tile;
import org.orekit.models.earth.tessellation.TileAiming;

public class EllipsoidTessellator {
    private final int quantization;
    private final TileAiming aiming;
    private final OneAxisEllipsoid ellipsoid;

    public EllipsoidTessellator(OneAxisEllipsoid ellipsoid, TileAiming aiming, int quantization) {
        this.ellipsoid = ellipsoid;
        this.aiming = aiming;
        this.quantization = quantization;
    }

    public List<List<Tile>> tessellate(SphericalPolygonsSet zone, double fullWidth, double fullLength, double widthOverlap, double lengthOverlap, boolean truncateLastWidth, boolean truncateLastLength) throws OrekitException {
        double splitWidth = (fullWidth - widthOverlap) / (double)this.quantization;
        double splitLength = (fullLength - lengthOverlap) / (double)this.quantization;
        IdentityHashMap<Mesh, List<Tile>> map = new IdentityHashMap<Mesh, List<Tile>>();
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet remaining = (SphericalPolygonsSet)zone.copySelf();
        S2Point inside = this.getInsidePoint(remaining);
        while (inside != null) {
            ArrayList<Mesh.Node> mergingSeeds = new ArrayList<Mesh.Node>();
            Mesh mesh = new Mesh(this.ellipsoid, zone, this.aiming, splitLength, splitWidth, inside);
            mergingSeeds.add(mesh.getNode(0, 0));
            List<Tile> tiles = null;
            block1: while (!mergingSeeds.isEmpty()) {
                this.neighborExpandMesh(mesh, mergingSeeds, zone);
                tiles = this.extractTiles(mesh, zone, lengthOverlap, widthOverlap, truncateLastWidth, truncateLastLength);
                mergingSeeds.clear();
                for (Map.Entry entry : map.entrySet()) {
                    if (factory.intersection((Region)mesh.getCoverage(), (Region)((Mesh)entry.getKey()).getCoverage()).isEmpty()) continue;
                    mesh = this.mergeMeshes(mesh, (Mesh)entry.getKey(), mergingSeeds);
                    map.remove(entry.getKey());
                    continue block1;
                }
            }
            remaining = (SphericalPolygonsSet)factory.difference((Region)remaining, (Region)mesh.getCoverage());
            inside = this.getInsidePoint(remaining);
            map.put(mesh, tiles);
        }
        ArrayList<List<Tile>> tilesLists = new ArrayList<List<Tile>>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            tilesLists.add((List<Tile>)entry.getValue());
        }
        return tilesLists;
    }

    public List<List<GeodeticPoint>> sample(SphericalPolygonsSet zone, double width, double length) throws OrekitException {
        double splitWidth = width / (double)this.quantization;
        double splitLength = length / (double)this.quantization;
        IdentityHashMap<Mesh, List<GeodeticPoint>> map = new IdentityHashMap<Mesh, List<GeodeticPoint>>();
        RegionFactory factory = new RegionFactory();
        SphericalPolygonsSet remaining = (SphericalPolygonsSet)zone.copySelf();
        S2Point inside = this.getInsidePoint(remaining);
        while (inside != null) {
            ArrayList<Mesh.Node> mergingSeeds = new ArrayList<Mesh.Node>();
            Mesh mesh = new Mesh(this.ellipsoid, zone, this.aiming, splitLength, splitWidth, inside);
            mergingSeeds.add(mesh.getNode(0, 0));
            List<GeodeticPoint> sample = null;
            block1: while (!mergingSeeds.isEmpty()) {
                this.neighborExpandMesh(mesh, mergingSeeds, zone);
                sample = this.extractSample(mesh, zone);
                mergingSeeds.clear();
                for (Map.Entry entry : map.entrySet()) {
                    if (factory.intersection((Region)mesh.getCoverage(), (Region)((Mesh)entry.getKey()).getCoverage()).isEmpty()) continue;
                    mesh = this.mergeMeshes(mesh, (Mesh)entry.getKey(), mergingSeeds);
                    map.remove(entry.getKey());
                    continue block1;
                }
            }
            remaining = (SphericalPolygonsSet)factory.difference((Region)remaining, (Region)mesh.getCoverage());
            inside = this.getInsidePoint(remaining);
            map.put(mesh, sample);
        }
        ArrayList<List<GeodeticPoint>> sampleLists = new ArrayList<List<GeodeticPoint>>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            sampleLists.add((List<GeodeticPoint>)entry.getValue());
        }
        return sampleLists;
    }

    private S2Point getInsidePoint(SphericalPolygonsSet zone) throws OrekitException {
        InsideFinder finder = new InsideFinder(zone);
        zone.getTree(false).visit((BSPTreeVisitor)finder);
        return finder.getInsidePoint();
    }

    private void neighborExpandMesh(Mesh mesh, Collection<Mesh.Node> seeds, SphericalPolygonsSet zone) throws OrekitException {
        boolean expanding = true;
        LinkedList<Mesh.Node> newNodes = new LinkedList<Mesh.Node>();
        newNodes.addAll(seeds);
        while (expanding) {
            while (!newNodes.isEmpty()) {
                Mesh.Node node = (Mesh.Node)newNodes.remove();
                if (!node.isInside()) continue;
                this.addAllNeighborsIfNeeded(node, mesh, newNodes);
            }
            expanding = false;
            List<Mesh.Node> boundary = mesh.getTaxicabBoundary(false);
            if (boundary.size() <= 1) continue;
            Mesh.Node previous = boundary.get(boundary.size() - 1);
            for (Mesh.Node node : boundary) {
                if (this.meetInside(previous.getS2P(), node.getS2P(), zone)) {
                    this.addAllNeighborsIfNeeded(previous, mesh, newNodes);
                    this.addAllNeighborsIfNeeded(node, mesh, newNodes);
                    expanding = true;
                }
                previous = node;
            }
        }
    }

    private List<Tile> extractTiles(Mesh mesh, SphericalPolygonsSet zone, double lengthOverlap, double widthOverlap, boolean truncateLastWidth, boolean truncateLastLength) throws OrekitException {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        ArrayList<RangePair> rangePairs = new ArrayList<RangePair>();
        int minAcross = mesh.getMinAcrossIndex();
        int maxAcross = mesh.getMaxAcrossIndex();
        for (Range acrossPair : this.nodesIndices(minAcross, maxAcross, truncateLastWidth)) {
            int minAlong = mesh.getMaxAlongIndex() + 1;
            int maxAlong = mesh.getMinAlongIndex() - 1;
            for (int c = acrossPair.lower; c <= acrossPair.upper; ++c) {
                minAlong = FastMath.min((int)minAlong, (int)mesh.getMinAlongIndex(c));
                maxAlong = FastMath.max((int)maxAlong, (int)mesh.getMaxAlongIndex(c));
            }
            for (Range alongPair : this.nodesIndices(minAlong, maxAlong, truncateLastLength)) {
                Mesh.Node node0 = mesh.addNode(alongPair.lower, acrossPair.lower);
                Mesh.Node node1 = mesh.addNode(alongPair.upper, acrossPair.lower);
                Mesh.Node node2 = mesh.addNode(alongPair.upper, acrossPair.upper);
                Mesh.Node node3 = mesh.addNode(alongPair.lower, acrossPair.upper);
                S2Point s2p0 = node0.move(new Vector3D(-0.5 * lengthOverlap, node0.getAlong(), -0.5 * widthOverlap, node0.getAcross()));
                S2Point s2p1 = node1.move(new Vector3D(0.5 * lengthOverlap, node1.getAlong(), -0.5 * widthOverlap, node1.getAcross()));
                S2Point s2p2 = node2.move(new Vector3D(0.5 * lengthOverlap, node2.getAlong(), 0.5 * widthOverlap, node2.getAcross()));
                S2Point s2p3 = node3.move(new Vector3D(-0.5 * lengthOverlap, node2.getAlong(), 0.5 * widthOverlap, node2.getAcross()));
                SphericalPolygonsSet quadrilateral = new SphericalPolygonsSet(zone.getTolerance(), new S2Point[]{s2p0, s2p1, s2p2, s2p3});
                if (new RegionFactory().intersection((Region)zone.copySelf(), (Region)quadrilateral).isEmpty()) continue;
                tiles.add(new Tile(this.toGeodetic(s2p0), this.toGeodetic(s2p1), this.toGeodetic(s2p2), this.toGeodetic(s2p3)));
                rangePairs.add(new RangePair(acrossPair, alongPair));
            }
        }
        for (RangePair rangePair : rangePairs) {
            for (int c = rangePair.across.lower; c < rangePair.across.upper; ++c) {
                mesh.addNode(rangePair.along.lower, c + 1).setEnabled();
                mesh.addNode(rangePair.along.upper, c).setEnabled();
            }
            for (int l = rangePair.along.lower; l < rangePair.along.upper; ++l) {
                mesh.addNode(l, rangePair.across.lower).setEnabled();
                mesh.addNode(l + 1, rangePair.across.upper).setEnabled();
            }
        }
        return tiles;
    }

    private List<GeodeticPoint> extractSample(Mesh mesh, SphericalPolygonsSet zone) throws OrekitException {
        int selectedAcrossModulus = -1;
        int selectedAlongModulus = -1;
        int selectedCount = -1;
        for (int acrossModulus = 0; acrossModulus < this.quantization; ++acrossModulus) {
            for (int alongModulus = 0; alongModulus < this.quantization; ++alongModulus) {
                int count = 0;
                for (int across = mesh.getMinAcrossIndex() + acrossModulus; across <= mesh.getMaxAcrossIndex(); across += this.quantization) {
                    for (int along = mesh.getMinAlongIndex() + alongModulus; along <= mesh.getMaxAlongIndex(); along += this.quantization) {
                        Mesh.Node node = mesh.getNode(along, across);
                        if (node == null || !node.isInside()) continue;
                        ++count;
                    }
                }
                if (count <= selectedCount) continue;
                selectedAcrossModulus = acrossModulus;
                selectedAlongModulus = alongModulus;
                selectedCount = count;
            }
        }
        ArrayList<GeodeticPoint> sample = new ArrayList<GeodeticPoint>(selectedCount);
        for (int across = mesh.getMinAcrossIndex() + selectedAcrossModulus; across <= mesh.getMaxAcrossIndex(); across += this.quantization) {
            for (int along = mesh.getMinAlongIndex() + selectedAlongModulus; along <= mesh.getMaxAlongIndex(); along += this.quantization) {
                Mesh.Node node = mesh.getNode(along, across);
                if (node == null || !node.isInside()) continue;
                sample.add(this.toGeodetic(node.getS2P()));
            }
        }
        return sample;
    }

    private Mesh mergeMeshes(Mesh mesh1, Mesh mesh2, Collection<Mesh.Node> mergingSeeds) throws OrekitException {
        Mesh smaller;
        Mesh larger;
        if (mesh1.getNumberOfNodes() >= mesh2.getNumberOfNodes()) {
            larger = mesh1;
            smaller = mesh2;
        } else {
            larger = mesh2;
            smaller = mesh1;
        }
        for (Mesh.Node insideNode : smaller.getInsideNodes()) {
            Mesh.Node node = larger.getClosestExistingNode(insideNode.getV());
            while (this.estimateAlongMotion(node, insideNode.getV()) > mesh1.getAlongGap()) {
                node = larger.addNode(node.getAlongIndex() + 1, node.getAcrossIndex());
            }
            while (this.estimateAlongMotion(node, insideNode.getV()) < -mesh1.getAlongGap()) {
                node = larger.addNode(node.getAlongIndex() - 1, node.getAcrossIndex());
            }
            while (this.estimateAcrossMotion(node, insideNode.getV()) > mesh1.getAcrossGap()) {
                node = larger.addNode(node.getAlongIndex(), node.getAcrossIndex() + 1);
            }
            while (this.estimateAcrossMotion(node, insideNode.getV()) < -mesh1.getAcrossGap()) {
                node = larger.addNode(node.getAlongIndex(), node.getAcrossIndex() - 1);
            }
            int otherAlong = this.estimateAlongMotion(node, insideNode.getV()) < 0.0 ? node.getAlongIndex() - 1 : node.getAlongIndex() + 1;
            int otherAcross = this.estimateAcrossMotion(node, insideNode.getV()) < 0.0 ? node.getAcrossIndex() - 1 : node.getAcrossIndex() + 1;
            this.addNode(node.getAlongIndex(), node.getAcrossIndex(), larger, mergingSeeds);
            this.addNode(node.getAlongIndex(), otherAcross, larger, mergingSeeds);
            this.addNode(otherAlong, node.getAcrossIndex(), larger, mergingSeeds);
            this.addNode(otherAlong, otherAcross, larger, mergingSeeds);
        }
        return larger;
    }

    private void addAllNeighborsIfNeeded(Mesh.Node base, Mesh mesh, Collection<Mesh.Node> newNodes) throws OrekitException {
        this.addNode(base.getAlongIndex() - 1, base.getAcrossIndex() - 1, mesh, newNodes);
        this.addNode(base.getAlongIndex() - 1, base.getAcrossIndex(), mesh, newNodes);
        this.addNode(base.getAlongIndex() - 1, base.getAcrossIndex() + 1, mesh, newNodes);
        this.addNode(base.getAlongIndex(), base.getAcrossIndex() - 1, mesh, newNodes);
        this.addNode(base.getAlongIndex(), base.getAcrossIndex() + 1, mesh, newNodes);
        this.addNode(base.getAlongIndex() + 1, base.getAcrossIndex() - 1, mesh, newNodes);
        this.addNode(base.getAlongIndex() + 1, base.getAcrossIndex(), mesh, newNodes);
        this.addNode(base.getAlongIndex() + 1, base.getAcrossIndex() + 1, mesh, newNodes);
    }

    private void addNode(int alongIndex, int acrossIndex, Mesh mesh, Collection<Mesh.Node> newNodes) throws OrekitException {
        Mesh.Node node = mesh.addNode(alongIndex, acrossIndex);
        if (!node.isEnabled()) {
            node.setEnabled();
            newNodes.add(node);
        }
    }

    protected GeodeticPoint toGeodetic(S2Point point) {
        return new GeodeticPoint(1.5707963267948966 - point.getPhi(), point.getTheta(), 0.0);
    }

    public static SphericalPolygonsSet buildSimpleZone(double tolerance, double[] ... points) {
        S2Point[] vertices = new S2Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            vertices[i] = new S2Point(points[i][1], 1.5707963267948966 - points[i][0]);
        }
        return new SphericalPolygonsSet(tolerance, vertices);
    }

    public static SphericalPolygonsSet buildSimpleZone(double tolerance, GeodeticPoint ... points) {
        S2Point[] vertices = new S2Point[points.length];
        for (int i = 0; i < points.length; ++i) {
            vertices[i] = new S2Point(points[i].getLongitude(), 1.5707963267948966 - points[i].getLatitude());
        }
        return new SphericalPolygonsSet(tolerance, vertices);
    }

    private double estimateAlongMotion(Mesh.Node start, Vector3D end) {
        return Vector3D.dotProduct((Vector3D)start.getAlong(), (Vector3D)end.subtract((Vector)start.getV()));
    }

    private double estimateAcrossMotion(Mesh.Node start, Vector3D end) {
        return Vector3D.dotProduct((Vector3D)start.getAcross(), (Vector3D)end.subtract((Vector)start.getV()));
    }

    private boolean meetInside(S2Point s1, S2Point s2, SphericalPolygonsSet zone) {
        Circle circle = new Circle(s1, s2, zone.getTolerance());
        double alpha1 = circle.toSubSpace((Point)s1).getAlpha();
        double alpha2 = MathUtils.normalizeAngle((double)circle.toSubSpace((Point)s2).getAlpha(), (double)(alpha1 + Math.PI));
        SubCircle sub = new SubCircle((Hyperplane)circle, (Region)new ArcsSet(alpha1, alpha2, zone.getTolerance()));
        return this.recurseMeetInside((BSPTree<Sphere2D>)zone.getTree(false), (SubHyperplane<Sphere2D>)sub);
    }

    private boolean recurseMeetInside(BSPTree<Sphere2D> node, SubHyperplane<Sphere2D> sub) {
        if (node.getCut() == null) {
            if (sub.isEmpty()) {
                return false;
            }
            return (Boolean)node.getAttribute();
        }
        Hyperplane hyperplane = node.getCut().getHyperplane();
        SubHyperplane.SplitSubHyperplane split = sub.split(hyperplane);
        switch (split.getSide()) {
            case PLUS: {
                return this.recurseMeetInside((BSPTree<Sphere2D>)node.getPlus(), sub);
            }
            case MINUS: {
                return this.recurseMeetInside((BSPTree<Sphere2D>)node.getMinus(), sub);
            }
            case BOTH: {
                if (this.recurseMeetInside((BSPTree<Sphere2D>)node.getPlus(), (SubHyperplane<Sphere2D>)split.getPlus())) {
                    return true;
                }
                return this.recurseMeetInside((BSPTree<Sphere2D>)node.getMinus(), (SubHyperplane<Sphere2D>)split.getMinus());
            }
        }
        throw new OrekitInternalError(null);
    }

    private Iterable<Range> nodesIndices(int minIndex, final int maxIndex, final boolean truncateLast) {
        int first;
        if (truncateLast) {
            first = minIndex;
        } else {
            int range = maxIndex - minIndex;
            int nbTiles = (range + this.quantization - 1) / this.quantization;
            int extraNodes = nbTiles * this.quantization - range;
            int extraBefore = (extraNodes + 1) / 2;
            first = minIndex - extraBefore;
        }
        return new Iterable<Range>(){

            @Override
            public Iterator<Range> iterator() {
                return new Iterator<Range>(){
                    private int nextLower;
                    {
                        this.nextLower = first;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextLower < maxIndex;
                    }

                    @Override
                    public Range next() {
                        if (this.nextLower >= maxIndex) {
                            throw new NoSuchElementException();
                        }
                        int lower = this.nextLower;
                        this.nextLower += EllipsoidTessellator.this.quantization;
                        if (truncateLast && this.nextLower > maxIndex && lower < maxIndex) {
                            this.nextLower = maxIndex;
                        }
                        return new Range(lower, this.nextLower);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static class RangePair {
        private final Range across;
        private final Range along;

        RangePair(Range across, Range along) {
            this.across = across;
            this.along = along;
        }
    }

    private static class Range {
        private final int lower;
        private final int upper;

        Range(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }
    }
}

