/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OrekitEphemerisFile
implements EphemerisFile {
    private final Map<String, OrekitSatelliteEphemeris> satellites = new ConcurrentHashMap<String, OrekitSatelliteEphemeris>();

    public Map<String, OrekitSatelliteEphemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public OrekitSatelliteEphemeris addSatellite(String id) {
        OrekitSatelliteEphemeris newSat = new OrekitSatelliteEphemeris(id);
        this.satellites.put(id, newSat);
        return newSat;
    }

    public static class OrekitEphemerisSegment
    implements EphemerisFile.EphemerisSegment {
        private final List<TimeStampedPVCoordinates> coordinates;
        private final Frame frame;
        private final String frameCenterString;
        private final double mu;
        private final String timeScaleString;
        private final TimeScale timeScale;
        private final int samples;

        public OrekitEphemerisSegment(List<TimeStampedPVCoordinates> coordinates, Frame frame, String frameCenterString, double mu, TimeScale timeScale, int samples) {
            this.coordinates = coordinates;
            this.frame = frame;
            this.frameCenterString = frameCenterString;
            this.mu = mu;
            this.timeScale = timeScale;
            this.timeScaleString = timeScale.getName();
            this.samples = samples;
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        @Override
        public String getFrameCenterString() {
            return this.frameCenterString;
        }

        @Override
        public String getFrameString() {
            return this.frame.getName();
        }

        @Override
        public Frame getFrame() throws OrekitException {
            return this.frame;
        }

        @Override
        public String getTimeScaleString() {
            return this.timeScaleString;
        }

        @Override
        public TimeScale getTimeScale() throws OrekitException {
            return this.timeScale;
        }

        @Override
        public int getInterpolationSamples() {
            return this.samples;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return CartesianDerivativesFilter.USE_PV;
        }

        public List<TimeStampedPVCoordinates> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }
    }

    public static class OrekitSatelliteEphemeris
    implements EphemerisFile.SatelliteEphemeris {
        public static final int DEFAULT_INTERPOLATION_SIZE = 7;
        private final String id;
        private AbsoluteDate startDate;
        private AbsoluteDate stopDate;
        private final List<OrekitEphemerisSegment> segments;

        public OrekitSatelliteEphemeris(String id) {
            this.id = id;
            this.segments = new ArrayList<OrekitEphemerisSegment>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getMu() {
            if (this.segments.size() == 0) {
                return 0.0;
            }
            return this.segments.get(0).getMu();
        }

        @Override
        public List<? extends EphemerisFile.EphemerisSegment> getSegments() {
            return Collections.unmodifiableList(this.segments);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.startDate;
        }

        @Override
        public AbsoluteDate getStop() {
            return this.stopDate;
        }

        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states) throws OrekitException {
            return this.addNewSegment(states, CelestialBodyFactory.getEarth(), 7);
        }

        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states, int interpolationSampleSize) throws OrekitException {
            return this.addNewSegment(states, CelestialBodyFactory.getEarth(), interpolationSampleSize);
        }

        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states, CelestialBody body, int interpolationSampleSize) throws OrekitException {
            int minimumSampleSize = 2;
            if (states == null || states.size() == 0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "states");
            }
            if (interpolationSampleSize < 2) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, interpolationSampleSize);
            }
            AbsoluteDate start = states.get(0).getDate();
            AbsoluteDate stop = states.get(states.size() - 1).getDate();
            if (this.startDate == null || start.compareTo(this.startDate) < 0) {
                this.startDate = start;
            }
            if (this.stopDate == null || stop.compareTo(this.stopDate) > 0) {
                this.stopDate = stop;
            }
            ArrayList<TimeStampedPVCoordinates> coordinates = new ArrayList<TimeStampedPVCoordinates>();
            for (SpacecraftState state : states) {
                coordinates.add(state.getPVCoordinates());
            }
            Frame frame = states.get(0).getFrame();
            OrekitEphemerisSegment newSeg = new OrekitEphemerisSegment(coordinates, frame, body.getName(), body.getGM(), TimeScalesFactory.getUTC(), interpolationSampleSize);
            this.segments.add(newSeg);
            return newSeg;
        }
    }
}

