/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.util;

import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;

public class Incrementor {
    private static final MaxCountExceededCallback DEFAULT_CALLBACK = max -> {
        throw new MathIllegalStateException(LocalizedCoreFormats.MAX_COUNT_EXCEEDED, max);
    };
    private final int maximalCount;
    private final MaxCountExceededCallback maxCountCallback;
    private int count = 0;

    public Incrementor() {
        this(Integer.MAX_VALUE);
    }

    public Incrementor(int max) {
        this(max, DEFAULT_CALLBACK);
    }

    public Incrementor(int max, MaxCountExceededCallback cb) throws NullArgumentException {
        this(0, max, cb);
    }

    private Incrementor(int count, int max, MaxCountExceededCallback cb) throws NullArgumentException {
        if (cb == null) {
            throw new NullArgumentException();
        }
        if (max < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, max, 0);
        }
        this.maximalCount = max;
        this.maxCountCallback = cb;
        this.count = count;
    }

    public Incrementor withCount(int value) {
        return new Incrementor(value, this.maximalCount, this.maxCountCallback);
    }

    public Incrementor withMaximalCount(int max) {
        return new Incrementor(0, max, this.maxCountCallback);
    }

    public Incrementor withCallback(MaxCountExceededCallback cb) {
        return new Incrementor(0, this.maximalCount, cb);
    }

    public int getMaximalCount() {
        return this.maximalCount;
    }

    public int getCount() {
        return this.count;
    }

    public boolean canIncrement() {
        return this.canIncrement(1);
    }

    public boolean canIncrement(int nTimes) {
        if (nTimes < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, nTimes, 0);
        }
        return this.count + nTimes <= this.maximalCount;
    }

    public void increment(int nTimes) {
        if (nTimes < 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, nTimes, 0);
        }
        for (int i = 0; i < nTimes; ++i) {
            this.increment();
        }
    }

    public void increment() {
        if (++this.count > this.maximalCount) {
            this.maxCountCallback.trigger(this.maximalCount);
        }
    }

    public void reset() {
        this.count = 0;
    }

    public static interface MaxCountExceededCallback {
        public void trigger(int var1) throws MathIllegalStateException;
    }
}

