/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class MidpointFieldStateInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    MidpointFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected MidpointFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new MidpointFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        RealFieldElement coeffDot2 = (RealFieldElement)theta.multiply(2);
        RealFieldElement coeffDot1 = (RealFieldElement)((RealFieldElement)time.getField().getOne()).subtract((Object)coeffDot2);
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            RealFieldElement coeff1 = (RealFieldElement)theta.multiply(oneMinusThetaH);
            RealFieldElement coeff2 = (RealFieldElement)theta.multiply(thetaH);
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{coeff1, coeff2});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2});
        } else {
            RealFieldElement coeff1 = (RealFieldElement)oneMinusThetaH.multiply(theta);
            RealFieldElement coeff2 = (RealFieldElement)((RealFieldElement)oneMinusThetaH.multiply((Object)((RealFieldElement)theta.add(1.0)))).negate();
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{coeff1, coeff2});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot2});
        }
        return mapper.mapStateAndDerivative((RealFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

