/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;

public class DenseOutputModel
implements ODEStepHandler,
Serializable {
    private static final long serialVersionUID = 20160328L;
    private double initialTime;
    private double finalTime;
    private boolean forward = true;
    private int index = 0;
    private List<ODEStateInterpolator> steps = new ArrayList<ODEStateInterpolator>();

    public DenseOutputModel() {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
    }

    public void append(DenseOutputModel model) throws MathIllegalArgumentException, MathIllegalStateException {
        if (model.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = model.initialTime;
            this.forward = model.forward;
        } else {
            ODEStateAndDerivative s1 = this.steps.get(0).getPreviousState();
            ODEStateAndDerivative s2 = model.steps.get(0).getPreviousState();
            this.checkDimensionsEquality(s1.getPrimaryStateDimension(), s2.getPrimaryStateDimension());
            this.checkDimensionsEquality(s1.getNumberOfSecondaryStates(), s2.getNumberOfSecondaryStates());
            for (int i = 0; i < s1.getNumberOfSecondaryStates(); ++i) {
                this.checkDimensionsEquality(s1.getSecondaryStateDimension(i), s2.getSecondaryStateDimension(i));
            }
            if (this.forward ^ model.forward) {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.PROPAGATION_DIRECTION_MISMATCH, new Object[0]);
            }
            ODEStateInterpolator lastInterpolator = this.steps.get(this.index);
            double current = lastInterpolator.getCurrentState().getTime();
            double previous = lastInterpolator.getPreviousState().getTime();
            double step = current - previous;
            double gap = model.getInitialTime() - current;
            if (FastMath.abs((double)gap) > 0.001 * FastMath.abs((double)step)) {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.HOLE_BETWEEN_MODELS_TIME_RANGES, new Object[]{FastMath.abs((double)gap)});
            }
        }
        for (ODEStateInterpolator interpolator : model.steps) {
            this.steps.add(interpolator);
        }
        this.index = this.steps.size() - 1;
        this.finalTime = this.steps.get(this.index).getCurrentState().getTime();
    }

    private void checkDimensionsEquality(int d1, int d2) throws MathIllegalArgumentException {
        if (d1 != d2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{d2, d1});
        }
    }

    @Override
    public void init(ODEStateAndDerivative initialState, double targetTime) {
        this.initialTime = initialState.getTime();
        this.finalTime = targetTime;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    @Override
    public void handleStep(ODEStateInterpolator interpolator, boolean isLast) throws MathIllegalStateException {
        if (this.steps.size() == 0) {
            this.initialTime = interpolator.getPreviousState().getTime();
            this.forward = interpolator.isForward();
        }
        this.steps.add(interpolator);
        if (isLast) {
            this.finalTime = interpolator.getCurrentState().getTime();
            this.index = this.steps.size() - 1;
        }
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getFinalTime() {
        return this.finalTime;
    }

    public ODEStateAndDerivative getInterpolatedState(double time) {
        int iMin = 0;
        ODEStateInterpolator sMin = this.steps.get(iMin);
        double tMin = 0.5 * (sMin.getPreviousState().getTime() + sMin.getCurrentState().getTime());
        int iMax = this.steps.size() - 1;
        ODEStateInterpolator sMax = this.steps.get(iMax);
        double tMax = 0.5 * (sMax.getPreviousState().getTime() + sMax.getCurrentState().getTime());
        if (this.locatePoint(time, sMin) <= 0) {
            this.index = iMin;
            return sMin.getInterpolatedState(time);
        }
        if (this.locatePoint(time, sMax) >= 0) {
            this.index = iMax;
            return sMax.getInterpolatedState(time);
        }
        while (iMax - iMin > 5) {
            ODEStateInterpolator si = this.steps.get(this.index);
            int location = this.locatePoint(time, si);
            if (location < 0) {
                iMax = this.index;
                tMax = 0.5 * (si.getPreviousState().getTime() + si.getCurrentState().getTime());
            } else if (location > 0) {
                iMin = this.index;
                tMin = 0.5 * (si.getPreviousState().getTime() + si.getCurrentState().getTime());
            } else {
                return si.getInterpolatedState(time);
            }
            int iMed = (iMin + iMax) / 2;
            ODEStateInterpolator sMed = this.steps.get(iMed);
            double tMed = 0.5 * (sMed.getPreviousState().getTime() + sMed.getCurrentState().getTime());
            if (FastMath.abs((double)(tMed - tMin)) < 1.0E-6 || FastMath.abs((double)(tMax - tMed)) < 1.0E-6) {
                this.index = iMed;
            } else {
                double d12 = tMax - tMed;
                double d23 = tMed - tMin;
                double d13 = tMax - tMin;
                double dt1 = time - tMax;
                double dt2 = time - tMed;
                double dt3 = time - tMin;
                double iLagrange = (dt2 * dt3 * d23 * (double)iMax - dt1 * dt3 * d13 * (double)iMed + dt1 * dt2 * d12 * (double)iMin) / (d12 * d23 * d13);
                this.index = (int)FastMath.rint((double)iLagrange);
            }
            int low = FastMath.max((int)(iMin + 1), (int)((9 * iMin + iMax) / 10));
            int high = FastMath.min((int)(iMax - 1), (int)((iMin + 9 * iMax) / 10));
            if (this.index < low) {
                this.index = low;
                continue;
            }
            if (this.index <= high) continue;
            this.index = high;
        }
        this.index = iMin;
        while (this.index <= iMax && this.locatePoint(time, this.steps.get(this.index)) > 0) {
            ++this.index;
        }
        return this.steps.get(this.index).getInterpolatedState(time);
    }

    private int locatePoint(double time, ODEStateInterpolator interval) {
        if (this.forward) {
            if (time < interval.getPreviousState().getTime()) {
                return -1;
            }
            if (time > interval.getCurrentState().getTime()) {
                return 1;
            }
            return 0;
        }
        if (time > interval.getPreviousState().getTime()) {
            return -1;
        }
        if (time < interval.getCurrentState().getTime()) {
            return 1;
        }
        return 0;
    }
}

