/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.descriptive.StatisticalMultivariateSummary;
import org.hipparchus.stat.descriptive.StorelessMultivariateStatistic;
import org.hipparchus.stat.descriptive.moment.GeometricMean;
import org.hipparchus.stat.descriptive.moment.Mean;
import org.hipparchus.stat.descriptive.rank.Max;
import org.hipparchus.stat.descriptive.rank.Min;
import org.hipparchus.stat.descriptive.summary.Sum;
import org.hipparchus.stat.descriptive.summary.SumOfLogs;
import org.hipparchus.stat.descriptive.summary.SumOfSquares;
import org.hipparchus.stat.descriptive.vector.VectorialCovariance;
import org.hipparchus.stat.descriptive.vector.VectorialStorelessStatistic;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class MultivariateSummaryStatistics
implements StatisticalMultivariateSummary,
Serializable {
    private static final long serialVersionUID = 20160424L;
    private final int k;
    private final StorelessMultivariateStatistic sumImpl;
    private final StorelessMultivariateStatistic sumSqImpl;
    private final StorelessMultivariateStatistic minImpl;
    private final StorelessMultivariateStatistic maxImpl;
    private final StorelessMultivariateStatistic sumLogImpl;
    private final StorelessMultivariateStatistic geoMeanImpl;
    private final StorelessMultivariateStatistic meanImpl;
    private final VectorialCovariance covarianceImpl;
    private long n = 0L;

    public MultivariateSummaryStatistics(int dimension) {
        this(dimension, true);
    }

    public MultivariateSummaryStatistics(int dimension, boolean covarianceBiasCorrection) {
        this.k = dimension;
        this.sumImpl = new VectorialStorelessStatistic(this.k, new Sum());
        this.sumSqImpl = new VectorialStorelessStatistic(this.k, new SumOfSquares());
        this.minImpl = new VectorialStorelessStatistic(this.k, new Min());
        this.maxImpl = new VectorialStorelessStatistic(this.k, new Max());
        this.sumLogImpl = new VectorialStorelessStatistic(this.k, new SumOfLogs());
        this.geoMeanImpl = new VectorialStorelessStatistic(this.k, new GeometricMean());
        this.meanImpl = new VectorialStorelessStatistic(this.k, new Mean());
        this.covarianceImpl = new VectorialCovariance(this.k, covarianceBiasCorrection);
    }

    public void addValue(double[] value) throws MathIllegalArgumentException {
        MathUtils.checkNotNull((Object)value, (Localizable)LocalizedCoreFormats.INPUT_ARRAY, (Object[])new Object[0]);
        MathUtils.checkDimension((int)value.length, (int)this.k);
        this.sumImpl.increment(value);
        this.sumSqImpl.increment(value);
        this.minImpl.increment(value);
        this.maxImpl.increment(value);
        this.sumLogImpl.increment(value);
        this.geoMeanImpl.increment(value);
        this.meanImpl.increment(value);
        this.covarianceImpl.increment(value);
        ++this.n;
    }

    public void clear() {
        this.n = 0L;
        this.minImpl.clear();
        this.maxImpl.clear();
        this.sumImpl.clear();
        this.sumLogImpl.clear();
        this.sumSqImpl.clear();
        this.geoMeanImpl.clear();
        this.meanImpl.clear();
        this.covarianceImpl.clear();
    }

    @Override
    public int getDimension() {
        return this.k;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double[] getSum() {
        return this.sumImpl.getResult();
    }

    @Override
    public double[] getSumSq() {
        return this.sumSqImpl.getResult();
    }

    @Override
    public double[] getSumLog() {
        return this.sumLogImpl.getResult();
    }

    @Override
    public double[] getMean() {
        return this.meanImpl.getResult();
    }

    @Override
    public RealMatrix getCovariance() {
        return this.covarianceImpl.getResult();
    }

    @Override
    public double[] getMax() {
        return this.maxImpl.getResult();
    }

    @Override
    public double[] getMin() {
        return this.minImpl.getResult();
    }

    @Override
    public double[] getGeometricMean() {
        return this.geoMeanImpl.getResult();
    }

    @Override
    public double[] getStandardDeviation() {
        double[] stdDev = new double[this.k];
        if (this.getN() < 1L) {
            Arrays.fill(stdDev, Double.NaN);
        } else if (this.getN() < 2L) {
            Arrays.fill(stdDev, 0.0);
        } else {
            RealMatrix matrix = this.getCovariance();
            for (int i = 0; i < this.k; ++i) {
                stdDev[i] = FastMath.sqrt((double)matrix.getEntry(i, i));
            }
        }
        return stdDev;
    }

    public String toString() {
        String separator = ", ";
        String suffix = System.getProperty("line.separator");
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("MultivariateSummaryStatistics:" + suffix);
        outBuffer.append("n: " + this.getN() + suffix);
        this.append(outBuffer, this.getMin(), "min: ", ", ", suffix);
        this.append(outBuffer, this.getMax(), "max: ", ", ", suffix);
        this.append(outBuffer, this.getMean(), "mean: ", ", ", suffix);
        this.append(outBuffer, this.getGeometricMean(), "geometric mean: ", ", ", suffix);
        this.append(outBuffer, this.getSumSq(), "sum of squares: ", ", ", suffix);
        this.append(outBuffer, this.getSumLog(), "sum of logarithms: ", ", ", suffix);
        this.append(outBuffer, this.getStandardDeviation(), "standard deviation: ", ", ", suffix);
        outBuffer.append("covariance: " + this.getCovariance().toString() + suffix);
        return outBuffer.toString();
    }

    private void append(StringBuilder buffer, double[] data, String prefix, String separator, String suffix) {
        buffer.append(prefix);
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(data[i]);
        }
        buffer.append(suffix);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultivariateSummaryStatistics)) {
            return false;
        }
        MultivariateSummaryStatistics other = (MultivariateSummaryStatistics)object;
        return other.getN() == this.getN() && MathArrays.equalsIncludingNaN((double[])other.getGeometricMean(), (double[])this.getGeometricMean()) && MathArrays.equalsIncludingNaN((double[])other.getMax(), (double[])this.getMax()) && MathArrays.equalsIncludingNaN((double[])other.getMean(), (double[])this.getMean()) && MathArrays.equalsIncludingNaN((double[])other.getMin(), (double[])this.getMin()) && MathArrays.equalsIncludingNaN((double[])other.getSum(), (double[])this.getSum()) && MathArrays.equalsIncludingNaN((double[])other.getSumSq(), (double[])this.getSumSq()) && MathArrays.equalsIncludingNaN((double[])other.getSumLog(), (double[])this.getSumLog()) && other.getCovariance().equals(this.getCovariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double[])this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double[])this.getMax());
        result = result * 31 + MathUtils.hash((double[])this.getMean());
        result = result * 31 + MathUtils.hash((double[])this.getMin());
        result = result * 31 + MathUtils.hash((double[])this.getSum());
        result = result * 31 + MathUtils.hash((double[])this.getSumSq());
        result = result * 31 + MathUtils.hash((double[])this.getSumLog());
        result = result * 31 + this.getCovariance().hashCode();
        return result;
    }
}

