/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.AbstractConvergenceChecker;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;

public class SimplePointChecker<PAIR extends Pair<double[], ? extends Object>>
extends AbstractConvergenceChecker<PAIR> {
    private static final int ITERATION_CHECK_DISABLED = -1;
    private final int maxIterationCount;

    public SimplePointChecker(double relativeThreshold, double absoluteThreshold) {
        super(relativeThreshold, absoluteThreshold);
        this.maxIterationCount = -1;
    }

    public SimplePointChecker(double relativeThreshold, double absoluteThreshold, int maxIter) {
        super(relativeThreshold, absoluteThreshold);
        if (maxIter <= 0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, new Object[]{maxIter, 0});
        }
        this.maxIterationCount = maxIter;
    }

    @Override
    public boolean converged(int iteration, PAIR previous, PAIR current) {
        if (this.maxIterationCount != -1 && iteration >= this.maxIterationCount) {
            return true;
        }
        double[] p = (double[])previous.getKey();
        double[] c = (double[])current.getKey();
        for (int i = 0; i < p.length; ++i) {
            double size;
            double pi = p[i];
            double ci = c[i];
            double difference = FastMath.abs((double)(pi - ci));
            if (!(difference > (size = FastMath.max((double)FastMath.abs((double)pi), (double)FastMath.abs((double)ci))) * this.getRelativeThreshold()) || !(difference > this.getAbsoluteThreshold())) continue;
            return false;
        }
        return true;
    }
}

