/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.FieldSecondaryODE;
import org.hipparchus.util.MathArrays;

public class FieldExpandableODE<T extends RealFieldElement<T>> {
    private final FieldOrdinaryDifferentialEquation<T> primary;
    private List<FieldSecondaryODE<T>> components;
    private FieldEquationsMapper<T> mapper;

    public FieldExpandableODE(FieldOrdinaryDifferentialEquation<T> primary) {
        this.primary = primary;
        this.components = new ArrayList<FieldSecondaryODE<T>>();
        this.mapper = new FieldEquationsMapper(null, primary.getDimension());
    }

    public FieldEquationsMapper<T> getMapper() {
        return this.mapper;
    }

    public int addSecondaryEquations(FieldSecondaryODE<T> secondary) {
        this.components.add(secondary);
        this.mapper = new FieldEquationsMapper<T>(this.mapper, secondary.getDimension());
        return this.components.size();
    }

    public void init(FieldODEState<T> s0, T finalTime) {
        T t0 = s0.getTime();
        int index = 0;
        RealFieldElement[] primary0 = s0.getPrimaryState();
        this.primary.init((RealFieldElement)t0, primary0, (RealFieldElement)finalTime);
        while (++index < this.mapper.getNumberOfEquations()) {
            RealFieldElement[] secondary0 = s0.getSecondaryState(index);
            this.components.get(index - 1).init((RealFieldElement)t0, primary0, secondary0, (RealFieldElement)finalTime);
        }
    }

    public T[] computeDerivatives(T t, T[] y) throws MathIllegalArgumentException, MathIllegalStateException {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray((Field)t.getField(), (int)this.mapper.getTotalDimension());
        int index = 0;
        RealFieldElement[] primaryState = this.mapper.extractEquationData(index, (RealFieldElement[])y);
        RealFieldElement[] primaryStateDot = this.primary.computeDerivatives((RealFieldElement)t, primaryState);
        while (++index < this.mapper.getNumberOfEquations()) {
            RealFieldElement[] componentState = this.mapper.extractEquationData(index, (RealFieldElement[])y);
            RealFieldElement[] componentStateDot = this.components.get(index - 1).computeDerivatives((RealFieldElement)t, primaryState, primaryStateDot, componentState);
            this.mapper.insertEquationData(index, componentStateDot, yDot);
        }
        this.mapper.insertEquationData(0, primaryStateDot, yDot);
        return yDot;
    }
}

