/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.io.Serializable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.ode.ODEStateAndDerivative;

public class EquationsMapper
implements Serializable {
    private static final long serialVersionUID = 20160327L;
    private final int[] start;

    EquationsMapper(EquationsMapper mapper, int dimension) {
        int index = mapper == null ? 0 : mapper.getNumberOfEquations();
        this.start = new int[index + 2];
        if (mapper == null) {
            this.start[0] = 0;
        } else {
            System.arraycopy(mapper.start, 0, this.start, 0, index + 1);
        }
        this.start[index + 1] = this.start[index] + dimension;
    }

    public int getNumberOfEquations() {
        return this.start.length - 1;
    }

    public int getTotalDimension() {
        return this.start[this.start.length - 1];
    }

    public ODEStateAndDerivative mapStateAndDerivative(double t, double[] y, double[] yDot) throws MathIllegalArgumentException {
        if (y.length != this.getTotalDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{y.length, this.getTotalDimension()});
        }
        if (yDot.length != this.getTotalDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{yDot.length, this.getTotalDimension()});
        }
        int n = this.getNumberOfEquations();
        int index = 0;
        double[] state = this.extractEquationData(index, y);
        double[] derivative = this.extractEquationData(index, yDot);
        if (n < 2) {
            return new ODEStateAndDerivative(t, state, derivative);
        }
        double[][] secondaryState = new double[n - 1][];
        double[][] secondaryDerivative = new double[n - 1][];
        while (++index < this.getNumberOfEquations()) {
            secondaryState[index - 1] = this.extractEquationData(index, y);
            secondaryDerivative[index - 1] = this.extractEquationData(index, yDot);
        }
        return new ODEStateAndDerivative(t, state, derivative, secondaryState, secondaryDerivative);
    }

    public double[] extractEquationData(int index, double[] complete) throws MathIllegalArgumentException {
        this.checkIndex(index);
        int begin = this.start[index];
        int end = this.start[index + 1];
        if (complete.length < end) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{complete.length, end});
        }
        int dimension = end - begin;
        double[] equationData = new double[dimension];
        System.arraycopy(complete, begin, equationData, 0, dimension);
        return equationData;
    }

    public void insertEquationData(int index, double[] equationData, double[] complete) throws MathIllegalArgumentException {
        this.checkIndex(index);
        int begin = this.start[index];
        int end = this.start[index + 1];
        int dimension = end - begin;
        if (complete.length < end) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{complete.length, end});
        }
        if (equationData.length != dimension) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{equationData.length, dimension});
        }
        System.arraycopy(equationData, 0, complete, begin, dimension);
    }

    private void checkIndex(int index) throws MathIllegalArgumentException {
        if (index < 0 || index > this.start.length - 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, new Object[]{index, 0, this.start.length - 2});
        }
    }
}

