/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collection;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class TimeStampedFieldAngularCoordinates<T extends RealFieldElement<T>>
extends FieldAngularCoordinates<T> {
    private final FieldAbsoluteDate<T> date;

    public TimeStampedFieldAngularCoordinates(AbsoluteDate date, FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) throws OrekitException {
        this(new FieldAbsoluteDate(u1.getPosition().getX().getField(), date), u1, u2, v1, v2, tolerance);
    }

    public TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) throws OrekitException {
        super(u1, u2, v1, v2, tolerance);
        this.date = date;
    }

    public TimeStampedFieldAngularCoordinates(AbsoluteDate date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this(new FieldAbsoluteDate(rotation.getQ0().getField(), date), rotation, rotationRate, rotationAcceleration);
    }

    public TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    public TimeStampedFieldAngularCoordinates(Field<T> field, TimeStampedAngularCoordinates ac) {
        this(new FieldAbsoluteDate<T>(field, ac.getDate()), new FieldRotation(field, ac.getRotation()), new FieldVector3D(field, ac.getRotationRate()), new FieldVector3D(field, ac.getRotationAcceleration()));
    }

    public TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldRotation<FieldDerivativeStructure<T>> r) {
        super(r);
        this.date = date;
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> revert() {
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> shiftedBy(T dt) {
        FieldAngularCoordinates<T> sac = super.shiftedBy(dt);
        return new TimeStampedFieldAngularCoordinates<T>(this.date.shiftedBy(dt), sac.getRotation(), sac.getRotationRate(), sac.getRotationAcceleration());
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        FieldVector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().compose(offset.getRotation(), RotationConvention.VECTOR_OPERATOR), this.getRotationRate().add(rOmega), new FieldVector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.getRotationRate(), (FieldVector3D)rOmega)));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset((FieldAngularCoordinates)offset.revert());
    }

    public static <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> interpolate(AbsoluteDate date, AngularDerivativesFilter filter, Collection<TimeStampedFieldAngularCoordinates<T>> sample) throws OrekitException {
        return TimeStampedFieldAngularCoordinates.interpolate(new FieldAbsoluteDate(sample.iterator().next().getRotation().getQ0().getField(), date), filter, sample);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> interpolate(FieldAbsoluteDate<T> date, AngularDerivativesFilter filter, Collection<TimeStampedFieldAngularCoordinates<T>> sample) throws OrekitException {
        void var11_13;
        FieldVector3D meanRate;
        FieldVector3D sum;
        Field field = sample.iterator().next().getRotation().getQ0().getField();
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min((double)-0.9999, (double)(-FastMath.cos((double)(epsilon / 4.0))));
        if (filter != AngularDerivativesFilter.USE_R) {
            sum = FieldVector3D.getZero((Field)field);
            for (TimeStampedFieldAngularCoordinates<T> timeStampedFieldAngularCoordinates : sample) {
                sum = sum.add(timeStampedFieldAngularCoordinates.getRotationRate());
            }
            meanRate = new FieldVector3D(1.0 / (double)sample.size(), sum);
        } else {
            if (sample.size() < 2) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, sample.size());
            }
            sum = FieldVector3D.getZero((Field)field);
            TimeStampedFieldAngularCoordinates<T> previous = null;
            for (TimeStampedFieldAngularCoordinates<T> timeStampedFieldAngularCoordinates : sample) {
                if (previous != null) {
                    sum = sum.add(TimeStampedFieldAngularCoordinates.estimateRate(previous.getRotation(), timeStampedFieldAngularCoordinates.getRotation(), timeStampedFieldAngularCoordinates.date.durationFrom(previous.getDate())));
                }
                previous = timeStampedFieldAngularCoordinates;
            }
            meanRate = new FieldVector3D(1.0 / (double)(sample.size() - 1), sum);
        }
        FieldAngularCoordinates offset = new TimeStampedFieldAngularCoordinates<T>(date, FieldRotation.getIdentity((Field)field), meanRate, FieldVector3D.getZero((Field)field));
        boolean restart = true;
        boolean bl = false;
        while (restart && var11_13 < sample.size() + 2) {
            restart = false;
            FieldHermiteInterpolator fieldHermiteInterpolator = new FieldHermiteInterpolator();
            double sign = 1.0;
            FieldRotation previous = FieldRotation.getIdentity((Field)field);
            block8: for (TimeStampedFieldAngularCoordinates<T> timeStampedFieldAngularCoordinates : sample) {
                T dt = timeStampedFieldAngularCoordinates.date.durationFrom(date);
                FieldAngularCoordinates fixed = timeStampedFieldAngularCoordinates.subtractOffset(offset.shiftedBy((RealFieldElement)dt));
                RealFieldElement dot = (RealFieldElement)dt.linearCombination((Object)fixed.getRotation().getQ0(), (Object)previous.getQ0(), (Object)fixed.getRotation().getQ1(), (Object)previous.getQ1(), (Object)fixed.getRotation().getQ2(), (Object)previous.getQ2(), (Object)fixed.getRotation().getQ3(), (Object)previous.getQ3());
                sign = FastMath.copySign((double)1.0, (double)(dot.getReal() * sign));
                previous = fixed.getRotation();
                if (fixed.getRotation().getQ0().getReal() * sign < threshold) {
                    restart = true;
                    break;
                }
                RealFieldElement[][] rodrigues = fixed.getModifiedRodrigues(sign);
                switch (filter) {
                    case USE_RRA: {
                        fieldHermiteInterpolator.addSamplePoint(dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0], rodrigues[1], rodrigues[2]});
                        continue block8;
                    }
                    case USE_RR: {
                        fieldHermiteInterpolator.addSamplePoint(dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0], rodrigues[1]});
                        continue block8;
                    }
                    case USE_R: {
                        fieldHermiteInterpolator.addSamplePoint(dt, (FieldElement[][])new RealFieldElement[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw new OrekitInternalError(null);
            }
            if (!restart) {
                RealFieldElement[][] p = (RealFieldElement[][])fieldHermiteInterpolator.derivatives((FieldElement)field.getZero(), 2);
                FieldAngularCoordinates fieldAngularCoordinates = TimeStampedFieldAngularCoordinates.createFromModifiedRodrigues((RealFieldElement[][])p);
                return new TimeStampedFieldAngularCoordinates<T>(offset.getDate(), fieldAngularCoordinates.getRotation(), fieldAngularCoordinates.getRotationRate(), fieldAngularCoordinates.getRotationAcceleration()).addOffset(offset);
            }
            offset = offset.addOffset(new FieldAngularCoordinates(new FieldRotation(FieldVector3D.getPlusI((Field)field), (RealFieldElement)((RealFieldElement)field.getZero()).add(epsilon), RotationConvention.VECTOR_OPERATOR), FieldVector3D.getZero((Field)field), FieldVector3D.getZero((Field)field)));
            ++var11_13;
        }
        throw new OrekitInternalError(null);
    }
}

