/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.GHIJjsPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.LnsCoefficients;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenZonalLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class DSSTZonal
implements DSSTForceModel {
    private static final double TRUNCATION_TOLERANCE = 1.0E-4;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int I = 1;
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private final int maxDegree;
    private final int maxDegreeShortPeriodics;
    private final int maxOrder;
    private final double[] fact;
    private final TreeMap<CoefficientsFactory.NSKey, Double> Vns;
    private int maxEccPowMeanElements;
    private final int maxEccPowShortPeriodics;
    private final int maxFrequencyShortPeriodics;
    private ZonalShortPeriodicCoefficients zonalSPCoefs;
    private double a;
    private double k;
    private double h;
    private double q;
    private double p;
    private double ecc;
    private double alpha;
    private double beta;
    private double gamma;
    private double X;
    private double XX;
    private double XXX;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double mCo2AB;
    private double m2aoA;
    private double muoa;
    private double roa;
    private HansenZonalLinear[] hansenObjects;
    private double U;
    private double A;
    private double B;
    private double C;
    private double meanMotion;
    private double hk;
    private double k2mh2;
    private double k2mh2o2;
    private double oon2a2;
    private double oon2a;
    private double x3on2a;
    private double xon2a2;
    private double cxo2n2a2;
    private double x2on2a2xp1;
    private double BB;

    public DSSTZonal(UnnormalizedSphericalHarmonicsProvider provider, int maxDegreeShortPeriodics, int maxEccPowShortPeriodics, int maxFrequencyShortPeriodics) throws OrekitException {
        this.provider = provider;
        this.maxDegree = provider.getMaxDegree();
        this.maxOrder = provider.getMaxOrder();
        this.checkIndexRange(maxDegreeShortPeriodics, 2, this.maxDegree);
        this.maxDegreeShortPeriodics = maxDegreeShortPeriodics;
        this.checkIndexRange(maxEccPowShortPeriodics, 0, maxDegreeShortPeriodics - 1);
        this.maxEccPowShortPeriodics = maxEccPowShortPeriodics;
        this.checkIndexRange(maxFrequencyShortPeriodics, 1, 2 * maxDegreeShortPeriodics + 1);
        this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
        this.Vns = CoefficientsFactory.computeVns(this.maxDegree + 1);
        int maxFact = 2 * this.maxDegree + 1;
        this.fact = new double[maxFact];
        this.fact[0] = 1.0;
        for (int i = 1; i < maxFact; ++i) {
            this.fact[i] = (double)i * this.fact[i - 1];
        }
        this.maxEccPowMeanElements = this.maxDegree == 2 ? 0 : Integer.MIN_VALUE;
    }

    private void checkIndexRange(int index, int min, int max) throws OrekitException {
        if (index < min || index > max) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, min, max);
        }
    }

    public UnnormalizedSphericalHarmonicsProvider getProvider() {
        return this.provider;
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements aux, boolean meanOnly) throws OrekitException {
        this.computeMeanElementsTruncations(aux);
        int maxEccPow = !meanOnly ? FastMath.max((int)this.maxEccPowMeanElements, (int)this.maxEccPowShortPeriodics) : this.maxEccPowMeanElements;
        this.hansenObjects = new HansenZonalLinear[maxEccPow + 1];
        for (int s = 0; s <= maxEccPow; ++s) {
            this.hansenObjects[s] = new HansenZonalLinear(this.maxDegree, s);
        }
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        this.zonalSPCoefs = new ZonalShortPeriodicCoefficients(this.maxFrequencyShortPeriodics, 3, new TimeSpanMap<Slot>(new Slot(this.maxFrequencyShortPeriodics, 3)));
        list.add(this.zonalSPCoefs);
        return list;
    }

    private void computeMeanElementsTruncations(AuxiliaryElements aux) throws OrekitException {
        if (this.maxDegree == 2) {
            this.maxEccPowMeanElements = 0;
        } else {
            this.initializeStep(aux);
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(aux.getDate());
            double ax2or = 2.0 * this.a / this.provider.getAe();
            double xmuran = this.provider.getMu() / this.a;
            double eo2 = FastMath.max((double)0.0025, (double)(this.ecc / 2.0));
            double x2o2 = this.XX / 2.0;
            double[] eccPwr = new double[this.maxDegree + 1];
            double[] chiPwr = new double[this.maxDegree + 1];
            double[] hafPwr = new double[this.maxDegree + 1];
            eccPwr[0] = 1.0;
            chiPwr[0] = this.X;
            hafPwr[0] = 1.0;
            for (int i = 1; i <= this.maxDegree; ++i) {
                eccPwr[i] = eccPwr[i - 1] * eo2;
                chiPwr[i] = chiPwr[i - 1] * x2o2;
                hafPwr[i] = hafPwr[i - 1] * 0.5;
                xmuran /= ax2or;
            }
            this.maxEccPowMeanElements = 0;
            int n = this.maxDegree;
            do {
                double snm;
                double cnm;
                double csnm;
                int m = 0;
                while ((csnm = FastMath.hypot((double)(cnm = harmonics.getUnnormalizedCnm(n, m)), (double)(snm = harmonics.getUnnormalizedSnm(n, m)))) != 0.0) {
                    double lastTerm = 0.0;
                    int nsld2 = (n - this.maxEccPowMeanElements - 1) / 2;
                    int l = n - 2 * nsld2;
                    double term = 0.0;
                    do {
                        if ((term = m < l ? csnm * xmuran * (this.fact[n - l] / this.fact[n - m]) * (this.fact[n + l] / (this.fact[nsld2] * this.fact[nsld2 + l])) * eccPwr[l] * UpperBounds.getDnl(this.XX, chiPwr[l], n, l) * (UpperBounds.getRnml(this.gamma, n, l, m, 1, 1) + UpperBounds.getRnml(this.gamma, n, l, m, -1, 1)) : csnm * xmuran * (this.fact[n + m] / (this.fact[nsld2] * this.fact[nsld2 + l])) * eccPwr[l] * hafPwr[m - l] * UpperBounds.getDnl(this.XX, chiPwr[l], n, l) * (UpperBounds.getRnml(this.gamma, n, m, l, 1, 1) + UpperBounds.getRnml(this.gamma, n, m, l, -1, 1))) >= 1.0E-4) {
                            this.maxEccPowMeanElements = l;
                        } else if (term < lastTerm) break;
                        lastTerm = term;
                        --nsld2;
                    } while ((l += 2) < n);
                    if (term >= 1.0E-4) {
                        this.maxEccPowMeanElements = FastMath.min((int)(this.maxDegree - 2), (int)this.maxEccPowMeanElements);
                        return;
                    }
                    if (++m <= FastMath.min((int)n, (int)this.maxOrder)) continue;
                }
                xmuran *= ax2or;
            } while (--n > this.maxEccPowMeanElements + 2);
            this.maxEccPowMeanElements = FastMath.min((int)(this.maxDegree - 2), (int)this.maxEccPowMeanElements);
        }
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) throws OrekitException {
        this.a = aux.getSma();
        this.k = aux.getK();
        this.h = aux.getH();
        this.q = aux.getQ();
        this.p = aux.getP();
        this.ecc = aux.getEcc();
        this.alpha = aux.getAlpha();
        this.beta = aux.getBeta();
        this.gamma = aux.getGamma();
        this.A = aux.getA();
        this.B = aux.getB();
        this.C = aux.getC();
        this.X = 1.0 / this.B;
        this.XX = this.X * this.X;
        this.XXX = this.X * this.XX;
        this.ooAB = 1.0 / (this.A * this.B);
        this.BoA = this.B / this.A;
        this.mCo2AB = -this.C * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + this.B);
        this.m2aoA = -2.0 * this.a / this.A;
        this.muoa = this.provider.getMu() / this.a;
        this.roa = this.provider.getAe() / this.a;
        this.meanMotion = aux.getMeanMotion();
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState) throws OrekitException {
        return this.computeMeanElementRates(spacecraftState.getDate());
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    private double[] computeMeanElementRates(AbsoluteDate date) throws OrekitException {
        double[] dU = this.computeUDerivatives(date);
        double dUda = dU[0];
        double dUdk = dU[1];
        double dUdh = dU[2];
        double dUdAl = dU[3];
        double dUdBe = dU[4];
        double dUdGa = dU[5];
        double UAlphaGamma = this.alpha * dUdGa - this.gamma * dUdAl;
        double UBetaGamma = this.beta * dUdGa - this.gamma * dUdBe;
        double pUAGmIqUBGoAB = (this.p * UAlphaGamma - 1.0 * this.q * UBetaGamma) * this.ooAB;
        double da = 0.0;
        double dh = this.BoA * dUdk + this.k * pUAGmIqUBGoAB;
        double dk = -this.BoA * dUdh - this.h * pUAGmIqUBGoAB;
        double dp = this.mCo2AB * UBetaGamma;
        double dq = this.mCo2AB * UAlphaGamma * 1.0;
        double dM = this.m2aoA * dUda + this.BoABpo * (this.h * dUdh + this.k * dUdk) + pUAGmIqUBGoAB;
        return new double[]{0.0, dk, dh, dq, dp, dM};
    }

    private double[] computeUDerivatives(AbsoluteDate date) throws OrekitException {
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        this.U = 0.0;
        double[][] GsHs = CoefficientsFactory.computeGsHs(this.k, this.h, this.alpha, this.beta, this.maxEccPowMeanElements);
        double[][] Qns = CoefficientsFactory.computeQns(this.gamma, this.maxDegree, this.maxEccPowMeanElements);
        double[] roaPow = new double[this.maxDegree + 1];
        roaPow[0] = 1.0;
        for (int i = 1; i <= this.maxDegree; ++i) {
            roaPow[i] = this.roa * roaPow[i - 1];
        }
        double dUda = 0.0;
        double dUdk = 0.0;
        double dUdh = 0.0;
        double dUdAl = 0.0;
        double dUdBe = 0.0;
        double dUdGa = 0.0;
        for (int s = 0; s <= this.maxEccPowMeanElements; ++s) {
            this.hansenObjects[s].computeInitValues(this.X);
            double gs = GsHs[0][s];
            double dGsdh = 0.0;
            double dGsdk = 0.0;
            double dGsdAl = 0.0;
            double dGsdBe = 0.0;
            if (s > 0) {
                double sxgsm1 = (double)s * GsHs[0][s - 1];
                double sxhsm1 = (double)s * GsHs[1][s - 1];
                dGsdh = this.beta * sxgsm1 - this.alpha * sxhsm1;
                dGsdk = this.alpha * sxgsm1 + this.beta * sxhsm1;
                dGsdAl = this.k * sxgsm1 - this.h * sxhsm1;
                dGsdBe = this.h * sxgsm1 + this.k * sxhsm1;
            }
            double d0s = s == 0 ? 1.0 : 2.0;
            for (int n = s + 2; n <= this.maxDegree; ++n) {
                if ((n - s) % 2 != 0) continue;
                double kns = this.hansenObjects[s].getValue(-n - 1, this.X);
                double dkns = this.hansenObjects[s].getDerivative(-n - 1, this.X);
                double vns = this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                double coef0 = d0s * roaPow[n] * vns * -harmonics.getUnnormalizedCnm(n, 0);
                double coef1 = coef0 * Qns[n][s];
                double coef2 = coef1 * kns;
                double coef3 = coef2 * gs;
                double dqns = Qns[n][s + 1];
                this.U += coef3;
                dUda += coef3 * (double)(n + 1);
                dUdk += coef1 * (kns * dGsdk + this.k * this.XXX * gs * dkns);
                dUdh += coef1 * (kns * dGsdh + this.h * this.XXX * gs * dkns);
                dUdAl += coef2 * dGsdAl;
                dUdBe += coef2 * dGsdBe;
                dUdGa += coef0 * kns * dqns * gs;
            }
        }
        this.U *= -this.muoa;
        return new double[]{dUda * this.muoa / this.a, dUdk * -this.muoa, dUdh * -this.muoa, dUdAl * -this.muoa, dUdBe * -this.muoa, dUdGa * -this.muoa};
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    private boolean isBetween(int index, int lowerBound, int upperBound) {
        return index >= lowerBound && index <= upperBound;
    }

    @Override
    public void updateShortPeriodTerms(SpacecraftState ... meanStates) throws OrekitException {
        Slot slot = this.zonalSPCoefs.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            this.initializeStep(new AuxiliaryElements(meanState.getOrbit(), 1));
            this.hk = this.h * this.k;
            this.k2mh2 = this.k * this.k - this.h * this.h;
            this.k2mh2o2 = this.k2mh2 / 2.0;
            this.oon2a2 = 1.0 / (this.A * this.meanMotion);
            this.oon2a = this.a * this.oon2a2;
            this.x3on2a = this.XXX * this.oon2a;
            this.xon2a2 = this.X * this.oon2a2;
            this.cxo2n2a2 = this.xon2a2 * this.C / 2.0;
            this.x2on2a2xp1 = this.xon2a2 * this.X / (this.X + 1.0);
            this.BB = this.B * this.B;
            double[][] rhoSigma = this.computeRhoSigmaCoefficients(meanState.getDate(), slot);
            this.computeDiCoefficients(meanState.getDate(), slot);
            FourierCjSjCoefficients cjsj = new FourierCjSjCoefficients(meanState.getDate(), this.maxDegreeShortPeriodics, this.maxEccPowShortPeriodics, this.maxFrequencyShortPeriodics);
            this.computeCijSijCoefficients(meanState.getDate(), slot, cjsj, rhoSigma);
        }
    }

    private void computeDiCoefficients(AbsoluteDate date, Slot slot) throws OrekitException {
        double[] meanElementRates = this.computeMeanElementRates(date);
        double[] currentDi = new double[6];
        for (int i = 0; i < 6; ++i) {
            currentDi[i] = meanElementRates[i] / this.meanMotion;
            if (i != 5) continue;
            int n = i;
            currentDi[n] = currentDi[n] + -3.0 * this.U * this.oon2a2;
        }
        slot.di.addGridPoint(date, currentDi);
    }

    private void computeCijSijCoefficients(AbsoluteDate date, Slot slot, FourierCjSjCoefficients cjsj, double[][] rhoSigma) {
        int nMax = this.maxDegreeShortPeriodics;
        double[] currentCi0 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        for (int j = 1; j < slot.cij.length; ++j) {
            double coef4;
            double coef3;
            double coef2;
            double coef1;
            double[] currentCij = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            double[] currentSij = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            if (j == 1) {
                coef1 = 4.0 * this.k * this.U - this.hk * cjsj.getCj(1) + this.k2mh2o2 * cjsj.getSj(1);
                coef2 = 4.0 * this.h * this.U + this.k2mh2o2 * cjsj.getCj(1) + this.hk * cjsj.getSj(1);
                coef3 = (this.k * cjsj.getCj(1) + this.h * cjsj.getSj(1)) / 4.0;
                coef4 = (8.0 * this.U - this.h * cjsj.getCj(1) + this.k * cjsj.getSj(1)) / 4.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (j == 2) {
                coef1 = this.k2mh2 * this.U;
                coef2 = 2.0 * this.hk * this.U;
                coef3 = this.h * this.U / 2.0;
                coef4 = this.k * this.U / 2.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (this.isBetween(j, 1, 2 * nMax - 3) && j + 2 < cjsj.jMax) {
                coef1 = (double)(j + 2) * (-this.hk * cjsj.getCj(j + 2) + this.k2mh2o2 * cjsj.getSj(j + 2));
                coef2 = (double)(j + 2) * (this.k2mh2o2 * cjsj.getCj(j + 2) + this.hk * cjsj.getSj(j + 2));
                coef3 = (double)(j + 2) * (this.k * cjsj.getCj(j + 2) + this.h * cjsj.getSj(j + 2)) / 4.0;
                coef4 = (double)(j + 2) * (this.h * cjsj.getCj(j + 2) - this.k * cjsj.getSj(j + 2)) / 4.0;
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + -coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + -coef1 / 2.0;
            }
            if (this.isBetween(j, 1, 2 * nMax - 2) && j + 1 < cjsj.jMax) {
                coef1 = (double)(2 * (j + 1)) * (-this.h * cjsj.getCj(j + 1) + this.k * cjsj.getSj(j + 1));
                coef2 = (double)(2 * (j + 1)) * (this.k * cjsj.getCj(j + 1) + this.h * cjsj.getSj(j + 1));
                coef3 = (double)(j + 1) * cjsj.getCj(j + 1);
                coef4 = (double)(j + 1) * cjsj.getSj(j + 1);
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] - coef3;
                currentSij[2] = currentSij[2] - coef4;
                currentCij[5] = currentCij[5] - coef2 / 2.0;
                currentSij[5] = currentSij[5] + -coef1 / 2.0;
            }
            if (this.isBetween(j, 2, 2 * nMax) && j - 1 < cjsj.jMax) {
                coef1 = (double)(2 * (j - 1)) * (this.h * cjsj.getCj(j - 1) + this.k * cjsj.getSj(j - 1));
                coef2 = (double)(2 * (j - 1)) * (this.k * cjsj.getCj(j - 1) - this.h * cjsj.getSj(j - 1));
                coef3 = (double)(j - 1) * cjsj.getCj(j - 1);
                coef4 = (double)(j - 1) * cjsj.getSj(j - 1);
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] - coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] - coef3;
                currentCij[2] = currentCij[2] + coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] + coef2 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            if (this.isBetween(j, 3, 2 * nMax + 1) && j - 2 < cjsj.jMax) {
                coef1 = (double)(j - 2) * (this.hk * cjsj.getCj(j - 2) + this.k2mh2o2 * cjsj.getSj(j - 2));
                coef2 = (double)(j - 2) * (-this.k2mh2o2 * cjsj.getCj(j - 2) + this.hk * cjsj.getSj(j - 2));
                coef3 = (double)(j - 2) * (this.k * cjsj.getCj(j - 2) - this.h * cjsj.getSj(j - 2)) / 4.0;
                coef4 = (double)(j - 2) * (this.h * cjsj.getCj(j - 2) + this.k * cjsj.getSj(j - 2)) / 4.0;
                double coef5 = (double)(j - 2) * (this.k2mh2o2 * cjsj.getCj(j - 2) - this.hk * cjsj.getSj(j - 2));
                currentCij[0] = currentCij[0] + coef1;
                currentSij[0] = currentSij[0] + coef2;
                currentCij[1] = currentCij[1] + coef4;
                currentSij[1] = currentSij[1] + -coef3;
                currentCij[2] = currentCij[2] + coef3;
                currentSij[2] = currentSij[2] + coef4;
                currentCij[5] = currentCij[5] + coef5 / 2.0;
                currentSij[5] = currentSij[5] + coef1 / 2.0;
            }
            currentCij[0] = currentCij[0] * this.x3on2a;
            currentSij[0] = currentSij[0] * this.x3on2a;
            currentCij[1] = currentCij[1] * this.xon2a2;
            currentSij[1] = currentSij[1] * this.xon2a2;
            currentCij[2] = currentCij[2] * this.xon2a2;
            currentSij[2] = currentSij[2] * this.xon2a2;
            currentCij[5] = currentCij[5] * this.x2on2a2xp1;
            currentSij[5] = currentSij[5] * this.x2on2a2xp1;
            if (this.isBetween(j, 1, 2 * nMax - 1) && j < cjsj.jMax) {
                double CjAlphaGamma = this.alpha * cjsj.getdCjdGamma(j) - this.gamma * cjsj.getdCjdAlpha(j);
                double CjAlphaBeta = this.alpha * cjsj.getdCjdBeta(j) - this.beta * cjsj.getdCjdAlpha(j);
                double CjBetaGamma = this.beta * cjsj.getdCjdGamma(j) - this.gamma * cjsj.getdCjdBeta(j);
                double CjHK = this.h * cjsj.getdCjdK(j) - this.k * cjsj.getdCjdH(j);
                double SjAlphaGamma = this.alpha * cjsj.getdSjdGamma(j) - this.gamma * cjsj.getdSjdAlpha(j);
                double SjAlphaBeta = this.alpha * cjsj.getdSjdBeta(j) - this.beta * cjsj.getdSjdAlpha(j);
                double SjBetaGamma = this.beta * cjsj.getdSjdGamma(j) - this.gamma * cjsj.getdSjdBeta(j);
                double SjHK = this.h * cjsj.getdSjdK(j) - this.k * cjsj.getdSjdH(j);
                double coef12 = this.x3on2a * (3.0 - this.BB) * (double)j;
                currentCij[0] = currentCij[0] + coef12 * cjsj.getSj(j);
                currentSij[0] = currentSij[0] - coef12 * cjsj.getCj(j);
                double coef22 = this.p * CjAlphaGamma - 1.0 * this.q * CjBetaGamma;
                double coef32 = this.p * SjAlphaGamma - 1.0 * this.q * SjBetaGamma;
                currentCij[1] = currentCij[1] - this.xon2a2 * (this.h * coef22 + this.BB * cjsj.getdCjdH(j) - 1.5 * this.k * (double)j * cjsj.getSj(j));
                currentSij[1] = currentSij[1] - this.xon2a2 * (this.h * coef32 + this.BB * cjsj.getdSjdH(j) + 1.5 * this.k * (double)j * cjsj.getCj(j));
                currentCij[2] = currentCij[2] + this.xon2a2 * (this.k * coef22 + this.BB * cjsj.getdCjdK(j) + 1.5 * this.h * (double)j * cjsj.getSj(j));
                currentSij[2] = currentSij[2] + this.xon2a2 * (this.k * coef32 + this.BB * cjsj.getdSjdK(j) - 1.5 * this.h * (double)j * cjsj.getCj(j));
                double coef42 = CjHK - CjAlphaBeta - (double)j * cjsj.getSj(j);
                double coef5 = SjHK - SjAlphaBeta + (double)j * cjsj.getCj(j);
                currentCij[3] = this.cxo2n2a2 * (-1.0 * CjAlphaGamma + this.q * coef42);
                currentSij[3] = this.cxo2n2a2 * (-1.0 * SjAlphaGamma + this.q * coef5);
                currentCij[4] = this.cxo2n2a2 * (-CjBetaGamma + this.p * coef42);
                currentSij[4] = this.cxo2n2a2 * (-SjBetaGamma + this.p * coef5);
                double coef6 = this.h * cjsj.getdCjdH(j) + this.k * cjsj.getdCjdK(j);
                double coef7 = this.h * cjsj.getdSjdH(j) + this.k * cjsj.getdSjdK(j);
                currentCij[5] = currentCij[5] + this.oon2a2 * (-2.0 * this.a * cjsj.getdCjdA(j) + coef6 / (this.X + 1.0) + this.X * coef22 - 3.0 * cjsj.getCj(j));
                currentSij[5] = currentSij[5] + this.oon2a2 * (-2.0 * this.a * cjsj.getdSjdA(j) + coef7 / (this.X + 1.0) + this.X * coef32 - 3.0 * cjsj.getSj(j));
            }
            for (int i = 0; i < 6; ++i) {
                int n = i;
                currentCi0[n] = currentCi0[n] - (currentCij[i] * rhoSigma[j][0] + currentSij[i] * rhoSigma[j][1]);
            }
            slot.cij[j].addGridPoint(date, currentCij);
            slot.sij[j].addGridPoint(date, currentSij);
        }
        slot.cij[0].addGridPoint(date, currentCi0);
    }

    private double[][] computeRhoSigmaCoefficients(AbsoluteDate date, Slot slot) {
        CjSjCoefficient cjsjKH = new CjSjCoefficient(this.k, this.h);
        double b = 1.0 / (1.0 + this.B);
        double mbtj = 1.0;
        double[][] rhoSigma = new double[slot.cij.length][2];
        for (int j = 1; j < rhoSigma.length; ++j) {
            double coef = (1.0 + (double)j * this.B) * (mbtj *= -b);
            double rho = coef * cjsjKH.getCj(j);
            double sigma = coef * cjsjKH.getSj(j);
            rhoSigma[j][0] = rho;
            rhoSigma[j][1] = sigma;
        }
        return rhoSigma;
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = 20160319L;
        private final ShortPeriodicsInterpolatedCoefficient di;
        private final ShortPeriodicsInterpolatedCoefficient[] cij;
        private final ShortPeriodicsInterpolatedCoefficient[] sij;

        Slot(int maxFrequencyShortPeriodics, int interpolationPoints) {
            int rows = maxFrequencyShortPeriodics + 1;
            this.di = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            this.cij = new ShortPeriodicsInterpolatedCoefficient[rows];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[rows];
            for (int j = 0; j <= maxFrequencyShortPeriodics; ++j) {
                this.cij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private class FourierCjSjCoefficients {
        private final GHIJjsPolynomials ghijCoef;
        private final LnsCoefficients lnsCoef;
        private final int nMax;
        private final int sMax;
        private final int jMax;
        private final double[][] cCoef;
        private final double[][] sCoef;
        private final double hXXX;
        private final double kXXX;

        FourierCjSjCoefficients(AbsoluteDate date, int nMax, int sMax, int jMax) throws OrekitException {
            this.ghijCoef = new GHIJjsPolynomials(DSSTZonal.this.k, DSSTZonal.this.h, DSSTZonal.this.alpha, DSSTZonal.this.beta);
            double[][] Qns = CoefficientsFactory.computeQns(DSSTZonal.this.gamma, nMax, nMax);
            this.lnsCoef = new LnsCoefficients(nMax, nMax, Qns, DSSTZonal.this.Vns, DSSTZonal.this.roa);
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.hXXX = DSSTZonal.this.h * DSSTZonal.this.XXX;
            this.kXXX = DSSTZonal.this.k * DSSTZonal.this.XXX;
            this.cCoef = new double[7][jMax + 1];
            this.sCoef = new double[7][jMax + 1];
            for (int s = 0; s <= sMax; ++s) {
                DSSTZonal.this.hansenObjects[s].computeInitValues(DSSTZonal.this.X);
            }
            this.generateCoefficients(date);
        }

        private void generateCoefficients(AbsoluteDate date) throws OrekitException {
            UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = DSSTZonal.this.provider.onDate(date);
            for (int j = 1; j <= this.jMax; ++j) {
                double coef4;
                double coef3;
                double coef1;
                double coef0;
                double dkns;
                double kns;
                double jn;
                double dlns;
                double lns;
                double dGjsdBeta;
                double dGjsdAlpha;
                double dGjsdk;
                double dGjsdh;
                double gjs;
                double dHjsdBeta;
                double dHjsdAlpha;
                double dHjsdk;
                double dHjsdh;
                double hjs;
                for (int i = 0; i <= 6; ++i) {
                    this.cCoef[i][j] = 0.0;
                    this.sCoef[i][j] = 0.0;
                }
                if (this.isBetween(j, 1, this.nMax - 1)) {
                    double coef42;
                    double coef32;
                    double coef2;
                    double coef12;
                    double coef02;
                    double dkns2;
                    double kns2;
                    double jn2;
                    double dlns2;
                    int n;
                    int jms;
                    int s;
                    for (s = j; s <= FastMath.min((int)(this.nMax - 1), (int)this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = s + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            double lns2 = this.lnsCoef.getLns(n, -jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, -jms);
                            hjs = this.ghijCoef.getHjs(s, -jms);
                            dHjsdh = this.ghijCoef.getdHjsdh(s, -jms);
                            dHjsdk = this.ghijCoef.getdHjsdk(s, -jms);
                            dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(s, -jms);
                            dHjsdBeta = this.ghijCoef.getdHjsdBeta(s, -jms);
                            gjs = this.ghijCoef.getGjs(s, -jms);
                            dGjsdh = this.ghijCoef.getdGjsdh(s, -jms);
                            dGjsdk = this.ghijCoef.getdGjsdk(s, -jms);
                            dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(s, -jms);
                            dGjsdBeta = this.ghijCoef.getdGjsdBeta(s, -jms);
                            jn2 = -harmonics.getUnnormalizedCnm(n, 0);
                            kns2 = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                            dkns2 = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                            coef02 = (double)d0smj * jn2;
                            coef12 = coef02 * lns2;
                            coef2 = coef12 * kns2;
                            coef32 = coef2 * hjs;
                            coef42 = coef2 * gjs;
                            double[] dArray = this.cCoef[0];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + coef32;
                            double[] dArray2 = this.cCoef[1];
                            int n3 = j;
                            dArray2[n3] = dArray2[n3] + coef32 * (double)(n + 1);
                            double[] dArray3 = this.cCoef[2];
                            int n4 = j;
                            dArray3[n4] = dArray3[n4] + coef12 * (kns2 * dHjsdh + hjs * this.hXXX * dkns2);
                            double[] dArray4 = this.cCoef[3];
                            int n5 = j;
                            dArray4[n5] = dArray4[n5] + coef12 * (kns2 * dHjsdk + hjs * this.kXXX * dkns2);
                            double[] dArray5 = this.cCoef[4];
                            int n6 = j;
                            dArray5[n6] = dArray5[n6] + coef2 * dHjsdAlpha;
                            double[] dArray6 = this.cCoef[5];
                            int n7 = j;
                            dArray6[n7] = dArray6[n7] + coef2 * dHjsdBeta;
                            double[] dArray7 = this.cCoef[6];
                            int n8 = j;
                            dArray7[n8] = dArray7[n8] + coef02 * dlns2 * kns2 * hjs;
                            double[] dArray8 = this.sCoef[0];
                            int n9 = j;
                            dArray8[n9] = dArray8[n9] + coef42;
                            double[] dArray9 = this.sCoef[1];
                            int n10 = j;
                            dArray9[n10] = dArray9[n10] + coef42 * (double)(n + 1);
                            double[] dArray10 = this.sCoef[2];
                            int n11 = j;
                            dArray10[n11] = dArray10[n11] + coef12 * (kns2 * dGjsdh + gjs * this.hXXX * dkns2);
                            double[] dArray11 = this.sCoef[3];
                            int n12 = j;
                            dArray11[n12] = dArray11[n12] + coef12 * (kns2 * dGjsdk + gjs * this.kXXX * dkns2);
                            double[] dArray12 = this.sCoef[4];
                            int n13 = j;
                            dArray12[n13] = dArray12[n13] + coef2 * dGjsdAlpha;
                            double[] dArray13 = this.sCoef[5];
                            int n14 = j;
                            dArray13[n14] = dArray13[n14] + coef2 * dGjsdBeta;
                            double[] dArray14 = this.sCoef[6];
                            int n15 = j;
                            dArray14[n15] = dArray14[n15] + coef02 * dlns2 * kns2 * gjs;
                        }
                    }
                    for (s = 0; s <= FastMath.min((int)(this.nMax - j), (int)this.sMax); ++s) {
                        int jps = j + s;
                        double d0spj = s == -j ? 1.0 : 2.0;
                        for (int n16 = FastMath.max((int)(j + s), (int)(j + 1)); n16 <= this.nMax; ++n16) {
                            if ((n16 + jps) % 2 != 0) continue;
                            lns = this.lnsCoef.getLns(n16, jps);
                            dlns = this.lnsCoef.getdLnsdGamma(n16, jps);
                            double hjs2 = this.ghijCoef.getHjs(s, jps);
                            double dHjsdh2 = this.ghijCoef.getdHjsdh(s, jps);
                            double dHjsdk2 = this.ghijCoef.getdHjsdk(s, jps);
                            double dHjsdAlpha2 = this.ghijCoef.getdHjsdAlpha(s, jps);
                            double dHjsdBeta2 = this.ghijCoef.getdHjsdBeta(s, jps);
                            double gjs2 = this.ghijCoef.getGjs(s, jps);
                            double dGjsdh2 = this.ghijCoef.getdGjsdh(s, jps);
                            double dGjsdk2 = this.ghijCoef.getdGjsdk(s, jps);
                            double dGjsdAlpha2 = this.ghijCoef.getdGjsdAlpha(s, jps);
                            double dGjsdBeta2 = this.ghijCoef.getdGjsdBeta(s, jps);
                            jn = -harmonics.getUnnormalizedCnm(n16, 0);
                            kns = DSSTZonal.this.hansenObjects[s].getValue(-n16 - 1, DSSTZonal.this.X);
                            dkns = DSSTZonal.this.hansenObjects[s].getDerivative(-n16 - 1, DSSTZonal.this.X);
                            coef0 = d0spj * jn;
                            coef1 = coef0 * lns;
                            double coef22 = coef1 * kns;
                            coef3 = coef22 * hjs2;
                            coef4 = coef22 * gjs2;
                            double[] dArray = this.cCoef[0];
                            int n17 = j;
                            dArray[n17] = dArray[n17] - coef3;
                            double[] dArray15 = this.cCoef[1];
                            int n18 = j;
                            dArray15[n18] = dArray15[n18] - coef3 * (double)(n16 + 1);
                            double[] dArray16 = this.cCoef[2];
                            int n19 = j;
                            dArray16[n19] = dArray16[n19] - coef1 * (kns * dHjsdh2 + hjs2 * this.hXXX * dkns);
                            double[] dArray17 = this.cCoef[3];
                            int n20 = j;
                            dArray17[n20] = dArray17[n20] - coef1 * (kns * dHjsdk2 + hjs2 * this.kXXX * dkns);
                            double[] dArray18 = this.cCoef[4];
                            int n21 = j;
                            dArray18[n21] = dArray18[n21] - coef22 * dHjsdAlpha2;
                            double[] dArray19 = this.cCoef[5];
                            int n22 = j;
                            dArray19[n22] = dArray19[n22] - coef22 * dHjsdBeta2;
                            double[] dArray20 = this.cCoef[6];
                            int n23 = j;
                            dArray20[n23] = dArray20[n23] - coef0 * dlns * kns * hjs2;
                            double[] dArray21 = this.sCoef[0];
                            int n24 = j;
                            dArray21[n24] = dArray21[n24] + coef4;
                            double[] dArray22 = this.sCoef[1];
                            int n25 = j;
                            dArray22[n25] = dArray22[n25] + coef4 * (double)(n16 + 1);
                            double[] dArray23 = this.sCoef[2];
                            int n26 = j;
                            dArray23[n26] = dArray23[n26] + coef1 * (kns * dGjsdh2 + gjs2 * this.hXXX * dkns);
                            double[] dArray24 = this.sCoef[3];
                            int n27 = j;
                            dArray24[n27] = dArray24[n27] + coef1 * (kns * dGjsdk2 + gjs2 * this.kXXX * dkns);
                            double[] dArray25 = this.sCoef[4];
                            int n28 = j;
                            dArray25[n28] = dArray25[n28] + coef22 * dGjsdAlpha2;
                            double[] dArray26 = this.sCoef[5];
                            int n29 = j;
                            dArray26[n29] = dArray26[n29] + coef22 * dGjsdBeta2;
                            double[] dArray27 = this.sCoef[6];
                            int n30 = j;
                            dArray27[n30] = dArray27[n30] + coef0 * dlns * kns * gjs2;
                        }
                    }
                    for (s = 1; s <= FastMath.min((int)j, (int)this.sMax); ++s) {
                        jms = j - s;
                        int d0smj = s == j ? 1 : 2;
                        for (n = j + 1; n <= this.nMax; ++n) {
                            if ((n + jms) % 2 != 0) continue;
                            double lns3 = this.lnsCoef.getLns(n, jms);
                            dlns2 = this.lnsCoef.getdLnsdGamma(n, jms);
                            double ijs = this.ghijCoef.getIjs(s, jms);
                            double dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                            double dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                            double dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                            double dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                            double jjs = this.ghijCoef.getJjs(s, jms);
                            double dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                            double dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                            double dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                            double dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                            jn2 = -harmonics.getUnnormalizedCnm(n, 0);
                            kns2 = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                            dkns2 = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                            coef02 = (double)d0smj * jn2;
                            coef12 = coef02 * lns3;
                            coef2 = coef12 * kns2;
                            coef32 = coef2 * ijs;
                            coef42 = coef2 * jjs;
                            double[] dArray = this.cCoef[0];
                            int n31 = j;
                            dArray[n31] = dArray[n31] - coef32;
                            double[] dArray28 = this.cCoef[1];
                            int n32 = j;
                            dArray28[n32] = dArray28[n32] - coef32 * (double)(n + 1);
                            double[] dArray29 = this.cCoef[2];
                            int n33 = j;
                            dArray29[n33] = dArray29[n33] - coef12 * (kns2 * dIjsdh + ijs * this.hXXX * dkns2);
                            double[] dArray30 = this.cCoef[3];
                            int n34 = j;
                            dArray30[n34] = dArray30[n34] - coef12 * (kns2 * dIjsdk + ijs * this.kXXX * dkns2);
                            double[] dArray31 = this.cCoef[4];
                            int n35 = j;
                            dArray31[n35] = dArray31[n35] - coef2 * dIjsdAlpha;
                            double[] dArray32 = this.cCoef[5];
                            int n36 = j;
                            dArray32[n36] = dArray32[n36] - coef2 * dIjsdBeta;
                            double[] dArray33 = this.cCoef[6];
                            int n37 = j;
                            dArray33[n37] = dArray33[n37] - coef02 * dlns2 * kns2 * ijs;
                            double[] dArray34 = this.sCoef[0];
                            int n38 = j;
                            dArray34[n38] = dArray34[n38] + coef42;
                            double[] dArray35 = this.sCoef[1];
                            int n39 = j;
                            dArray35[n39] = dArray35[n39] + coef42 * (double)(n + 1);
                            double[] dArray36 = this.sCoef[2];
                            int n40 = j;
                            dArray36[n40] = dArray36[n40] + coef12 * (kns2 * dJjsdh + jjs * this.hXXX * dkns2);
                            double[] dArray37 = this.sCoef[3];
                            int n41 = j;
                            dArray37[n41] = dArray37[n41] + coef12 * (kns2 * dJjsdk + jjs * this.kXXX * dkns2);
                            double[] dArray38 = this.sCoef[4];
                            int n42 = j;
                            dArray38[n42] = dArray38[n42] + coef2 * dJjsdAlpha;
                            double[] dArray39 = this.sCoef[5];
                            int n43 = j;
                            dArray39[n43] = dArray39[n43] + coef2 * dJjsdBeta;
                            double[] dArray40 = this.sCoef[6];
                            int n44 = j;
                            dArray40[n44] = dArray40[n44] + coef02 * dlns2 * kns2 * jjs;
                        }
                    }
                }
                if (this.isBetween(j, 2, this.nMax)) {
                    double jj = -harmonics.getUnnormalizedCnm(j, 0);
                    double kns3 = DSSTZonal.this.hansenObjects[0].getValue(-j - 1, DSSTZonal.this.X);
                    double dkns3 = DSSTZonal.this.hansenObjects[0].getDerivative(-j - 1, DSSTZonal.this.X);
                    double lns4 = this.lnsCoef.getLns(j, j);
                    hjs = this.ghijCoef.getHjs(0, j);
                    dHjsdh = this.ghijCoef.getdHjsdh(0, j);
                    dHjsdk = this.ghijCoef.getdHjsdk(0, j);
                    dHjsdAlpha = this.ghijCoef.getdHjsdAlpha(0, j);
                    dHjsdBeta = this.ghijCoef.getdHjsdBeta(0, j);
                    gjs = this.ghijCoef.getGjs(0, j);
                    dGjsdh = this.ghijCoef.getdGjsdh(0, j);
                    dGjsdk = this.ghijCoef.getdGjsdk(0, j);
                    dGjsdAlpha = this.ghijCoef.getdGjsdAlpha(0, j);
                    dGjsdBeta = this.ghijCoef.getdGjsdBeta(0, j);
                    double coef03 = 2.0 * jj;
                    double coef13 = coef03 * lns4;
                    double coef2 = coef13 * kns3;
                    double coef33 = coef2 * hjs;
                    double coef43 = coef2 * gjs;
                    double[] dArray = this.cCoef[0];
                    int n = j;
                    dArray[n] = dArray[n] - coef33;
                    double[] dArray41 = this.cCoef[1];
                    int n45 = j;
                    dArray41[n45] = dArray41[n45] - coef33 * (double)(j + 1);
                    double[] dArray42 = this.cCoef[2];
                    int n46 = j;
                    dArray42[n46] = dArray42[n46] - coef13 * (kns3 * dHjsdh + hjs * this.hXXX * dkns3);
                    double[] dArray43 = this.cCoef[3];
                    int n47 = j;
                    dArray43[n47] = dArray43[n47] - coef13 * (kns3 * dHjsdk + hjs * this.kXXX * dkns3);
                    double[] dArray44 = this.cCoef[4];
                    int n48 = j;
                    dArray44[n48] = dArray44[n48] - coef2 * dHjsdAlpha;
                    double[] dArray45 = this.cCoef[5];
                    int n49 = j;
                    dArray45[n49] = dArray45[n49] - coef2 * dHjsdBeta;
                    double[] dArray46 = this.sCoef[0];
                    int n50 = j;
                    dArray46[n50] = dArray46[n50] + coef43;
                    double[] dArray47 = this.sCoef[1];
                    int n51 = j;
                    dArray47[n51] = dArray47[n51] + coef43 * (double)(j + 1);
                    double[] dArray48 = this.sCoef[2];
                    int n52 = j;
                    dArray48[n52] = dArray48[n52] + coef13 * (kns3 * dGjsdh + gjs * this.hXXX * dkns3);
                    double[] dArray49 = this.sCoef[3];
                    int n53 = j;
                    dArray49[n53] = dArray49[n53] + coef13 * (kns3 * dGjsdk + gjs * this.kXXX * dkns3);
                    double[] dArray50 = this.sCoef[4];
                    int n54 = j;
                    dArray50[n54] = dArray50[n54] + coef2 * dGjsdAlpha;
                    double[] dArray51 = this.sCoef[5];
                    int n55 = j;
                    dArray51[n55] = dArray51[n55] + coef2 * dGjsdBeta;
                    for (int s = 1; s <= FastMath.min((int)(j - 1), (int)this.sMax); ++s) {
                        int d0smj;
                        int jms = j - s;
                        int n56 = d0smj = s == j ? 1 : 2;
                        if (s % 2 != 0) continue;
                        kns3 = DSSTZonal.this.hansenObjects[s].getValue(-j - 1, DSSTZonal.this.X);
                        dkns3 = DSSTZonal.this.hansenObjects[s].getDerivative(-j - 1, DSSTZonal.this.X);
                        lns4 = this.lnsCoef.getLns(j, jms);
                        double dlns3 = this.lnsCoef.getdLnsdGamma(j, jms);
                        double ijs = this.ghijCoef.getIjs(s, jms);
                        double dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                        double dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                        double dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                        double dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                        double jjs = this.ghijCoef.getJjs(s, jms);
                        double dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                        double dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                        double dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                        double dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                        coef03 = (double)d0smj * jj;
                        coef13 = coef03 * lns4;
                        coef2 = coef13 * kns3;
                        coef33 = coef2 * ijs;
                        coef43 = coef2 * jjs;
                        double[] dArray52 = this.cCoef[0];
                        int n57 = j;
                        dArray52[n57] = dArray52[n57] - coef33;
                        double[] dArray53 = this.cCoef[1];
                        int n58 = j;
                        dArray53[n58] = dArray53[n58] - coef33 * (double)(j + 1);
                        double[] dArray54 = this.cCoef[2];
                        int n59 = j;
                        dArray54[n59] = dArray54[n59] - coef13 * (kns3 * dIjsdh + ijs * this.hXXX * dkns3);
                        double[] dArray55 = this.cCoef[3];
                        int n60 = j;
                        dArray55[n60] = dArray55[n60] - coef13 * (kns3 * dIjsdk + ijs * this.kXXX * dkns3);
                        double[] dArray56 = this.cCoef[4];
                        int n61 = j;
                        dArray56[n61] = dArray56[n61] - coef2 * dIjsdAlpha;
                        double[] dArray57 = this.cCoef[5];
                        int n62 = j;
                        dArray57[n62] = dArray57[n62] - coef2 * dIjsdBeta;
                        double[] dArray58 = this.cCoef[6];
                        int n63 = j;
                        dArray58[n63] = dArray58[n63] - coef03 * dlns3 * kns3 * ijs;
                        double[] dArray59 = this.sCoef[0];
                        int n64 = j;
                        dArray59[n64] = dArray59[n64] + coef43;
                        double[] dArray60 = this.sCoef[1];
                        int n65 = j;
                        dArray60[n65] = dArray60[n65] + coef43 * (double)(j + 1);
                        double[] dArray61 = this.sCoef[2];
                        int n66 = j;
                        dArray61[n66] = dArray61[n66] + coef13 * (kns3 * dJjsdh + jjs * this.hXXX * dkns3);
                        double[] dArray62 = this.sCoef[3];
                        int n67 = j;
                        dArray62[n67] = dArray62[n67] + coef13 * (kns3 * dJjsdk + jjs * this.kXXX * dkns3);
                        double[] dArray63 = this.sCoef[4];
                        int n68 = j;
                        dArray63[n68] = dArray63[n68] + coef2 * dJjsdAlpha;
                        double[] dArray64 = this.sCoef[5];
                        int n69 = j;
                        dArray64[n69] = dArray64[n69] + coef2 * dJjsdBeta;
                        double[] dArray65 = this.sCoef[6];
                        int n70 = j;
                        dArray65[n70] = dArray65[n70] + coef03 * dlns3 * kns3 * jjs;
                    }
                }
                if (this.isBetween(j, 3, 2 * this.nMax - 1)) {
                    double dJjsdBeta;
                    double dJjsdAlpha;
                    double dJjsdk;
                    double dJjsdh;
                    double jjs;
                    double dIjsdBeta;
                    double dIjsdAlpha;
                    double dIjsdk;
                    double dIjsdh;
                    double ijs;
                    int d0smj;
                    int s;
                    int minjm1on = FastMath.min((int)(j - 1), (int)this.nMax);
                    if (j % 2 == 0) {
                        for (s = j - minjm1on; s <= FastMath.min((int)(j / 2 - 1), (int)this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = j - s; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                                dkns = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n71 = j;
                                dArray[n71] = dArray[n71] - coef3;
                                double[] dArray66 = this.cCoef[1];
                                int n72 = j;
                                dArray66[n72] = dArray66[n72] - coef3 * (double)(n + 1);
                                double[] dArray67 = this.cCoef[2];
                                int n73 = j;
                                dArray67[n73] = dArray67[n73] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray68 = this.cCoef[3];
                                int n74 = j;
                                dArray68[n74] = dArray68[n74] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray69 = this.cCoef[4];
                                int n75 = j;
                                dArray69[n75] = dArray69[n75] - coef2 * dIjsdAlpha;
                                double[] dArray70 = this.cCoef[5];
                                int n76 = j;
                                dArray70[n76] = dArray70[n76] - coef2 * dIjsdBeta;
                                double[] dArray71 = this.cCoef[6];
                                int n77 = j;
                                dArray71[n77] = dArray71[n77] - coef0 * dlns * kns * ijs;
                                double[] dArray72 = this.sCoef[0];
                                int n78 = j;
                                dArray72[n78] = dArray72[n78] + coef4;
                                double[] dArray73 = this.sCoef[1];
                                int n79 = j;
                                dArray73[n79] = dArray73[n79] + coef4 * (double)(n + 1);
                                double[] dArray74 = this.sCoef[2];
                                int n80 = j;
                                dArray74[n80] = dArray74[n80] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray75 = this.sCoef[3];
                                int n81 = j;
                                dArray75[n81] = dArray75[n81] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray76 = this.sCoef[4];
                                int n82 = j;
                                dArray76[n82] = dArray76[n82] + coef2 * dJjsdAlpha;
                                double[] dArray77 = this.sCoef[5];
                                int n83 = j;
                                dArray77[n83] = dArray77[n83] + coef2 * dJjsdBeta;
                                double[] dArray78 = this.sCoef[6];
                                int n84 = j;
                                dArray78[n84] = dArray78[n84] + coef0 * dlns * kns * jjs;
                            }
                        }
                        for (s = j / 2; s <= FastMath.min((int)(minjm1on - 1), (int)this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                                dkns = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n85 = j;
                                dArray[n85] = dArray[n85] - coef3;
                                double[] dArray79 = this.cCoef[1];
                                int n86 = j;
                                dArray79[n86] = dArray79[n86] - coef3 * (double)(n + 1);
                                double[] dArray80 = this.cCoef[2];
                                int n87 = j;
                                dArray80[n87] = dArray80[n87] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray81 = this.cCoef[3];
                                int n88 = j;
                                dArray81[n88] = dArray81[n88] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray82 = this.cCoef[4];
                                int n89 = j;
                                dArray82[n89] = dArray82[n89] - coef2 * dIjsdAlpha;
                                double[] dArray83 = this.cCoef[5];
                                int n90 = j;
                                dArray83[n90] = dArray83[n90] - coef2 * dIjsdBeta;
                                double[] dArray84 = this.cCoef[6];
                                int n91 = j;
                                dArray84[n91] = dArray84[n91] - coef0 * dlns * kns * ijs;
                                double[] dArray85 = this.sCoef[0];
                                int n92 = j;
                                dArray85[n92] = dArray85[n92] + coef4;
                                double[] dArray86 = this.sCoef[1];
                                int n93 = j;
                                dArray86[n93] = dArray86[n93] + coef4 * (double)(n + 1);
                                double[] dArray87 = this.sCoef[2];
                                int n94 = j;
                                dArray87[n94] = dArray87[n94] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray88 = this.sCoef[3];
                                int n95 = j;
                                dArray88[n95] = dArray88[n95] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray89 = this.sCoef[4];
                                int n96 = j;
                                dArray89[n96] = dArray89[n96] + coef2 * dJjsdAlpha;
                                double[] dArray90 = this.sCoef[5];
                                int n97 = j;
                                dArray90[n97] = dArray90[n97] + coef2 * dJjsdBeta;
                                double[] dArray91 = this.sCoef[6];
                                int n98 = j;
                                dArray91[n98] = dArray91[n98] + coef0 * dlns * kns * jjs;
                            }
                        }
                    } else {
                        for (s = (j - 1) / 2; s <= FastMath.min((int)(minjm1on - 1), (int)this.sMax); ++s) {
                            int jms = j - s;
                            d0smj = s == j ? 1 : 2;
                            for (int n = s + 1; n <= minjm1on; ++n) {
                                if ((n + jms) % 2 != 0) continue;
                                lns = this.lnsCoef.getLns(n, jms);
                                dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                ijs = this.ghijCoef.getIjs(s, jms);
                                dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                jjs = this.ghijCoef.getJjs(s, jms);
                                dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                jn = -harmonics.getUnnormalizedCnm(n, 0);
                                kns = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                                dkns = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                                coef0 = (double)d0smj * jn;
                                coef1 = coef0 * lns;
                                double coef2 = coef1 * kns;
                                coef3 = coef2 * ijs;
                                coef4 = coef2 * jjs;
                                double[] dArray = this.cCoef[0];
                                int n99 = j;
                                dArray[n99] = dArray[n99] - coef3;
                                double[] dArray92 = this.cCoef[1];
                                int n100 = j;
                                dArray92[n100] = dArray92[n100] - coef3 * (double)(n + 1);
                                double[] dArray93 = this.cCoef[2];
                                int n101 = j;
                                dArray93[n101] = dArray93[n101] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                double[] dArray94 = this.cCoef[3];
                                int n102 = j;
                                dArray94[n102] = dArray94[n102] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                double[] dArray95 = this.cCoef[4];
                                int n103 = j;
                                dArray95[n103] = dArray95[n103] - coef2 * dIjsdAlpha;
                                double[] dArray96 = this.cCoef[5];
                                int n104 = j;
                                dArray96[n104] = dArray96[n104] - coef2 * dIjsdBeta;
                                double[] dArray97 = this.cCoef[6];
                                int n105 = j;
                                dArray97[n105] = dArray97[n105] - coef0 * dlns * kns * ijs;
                                double[] dArray98 = this.sCoef[0];
                                int n106 = j;
                                dArray98[n106] = dArray98[n106] + coef4;
                                double[] dArray99 = this.sCoef[1];
                                int n107 = j;
                                dArray99[n107] = dArray99[n107] + coef4 * (double)(n + 1);
                                double[] dArray100 = this.sCoef[2];
                                int n108 = j;
                                dArray100[n108] = dArray100[n108] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                double[] dArray101 = this.sCoef[3];
                                int n109 = j;
                                dArray101[n109] = dArray101[n109] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                double[] dArray102 = this.sCoef[4];
                                int n110 = j;
                                dArray102[n110] = dArray102[n110] + coef2 * dJjsdAlpha;
                                double[] dArray103 = this.sCoef[5];
                                int n111 = j;
                                dArray103[n111] = dArray103[n111] + coef2 * dJjsdBeta;
                                double[] dArray104 = this.sCoef[6];
                                int n112 = j;
                                dArray104[n112] = dArray104[n112] + coef0 * dlns * kns * jjs;
                            }
                        }
                        if (this.nMax >= 4 && this.isBetween(j, 5, 2 * this.nMax - 3)) {
                            for (s = j - minjm1on; s <= FastMath.min((int)((j - 3) / 2), (int)this.sMax); ++s) {
                                int jms = j - s;
                                d0smj = s == j ? 1 : 2;
                                for (int n = j - s; n <= minjm1on; ++n) {
                                    if ((n + jms) % 2 != 0) continue;
                                    lns = this.lnsCoef.getLns(n, jms);
                                    dlns = this.lnsCoef.getdLnsdGamma(n, jms);
                                    ijs = this.ghijCoef.getIjs(s, jms);
                                    dIjsdh = this.ghijCoef.getdIjsdh(s, jms);
                                    dIjsdk = this.ghijCoef.getdIjsdk(s, jms);
                                    dIjsdAlpha = this.ghijCoef.getdIjsdAlpha(s, jms);
                                    dIjsdBeta = this.ghijCoef.getdIjsdBeta(s, jms);
                                    jjs = this.ghijCoef.getJjs(s, jms);
                                    dJjsdh = this.ghijCoef.getdJjsdh(s, jms);
                                    dJjsdk = this.ghijCoef.getdJjsdk(s, jms);
                                    dJjsdAlpha = this.ghijCoef.getdJjsdAlpha(s, jms);
                                    dJjsdBeta = this.ghijCoef.getdJjsdBeta(s, jms);
                                    jn = -harmonics.getUnnormalizedCnm(n, 0);
                                    kns = DSSTZonal.this.hansenObjects[s].getValue(-n - 1, DSSTZonal.this.X);
                                    dkns = DSSTZonal.this.hansenObjects[s].getDerivative(-n - 1, DSSTZonal.this.X);
                                    coef0 = (double)d0smj * jn;
                                    coef1 = coef0 * lns;
                                    double coef2 = coef1 * kns;
                                    coef3 = coef2 * ijs;
                                    coef4 = coef2 * jjs;
                                    double[] dArray = this.cCoef[0];
                                    int n113 = j;
                                    dArray[n113] = dArray[n113] - coef3;
                                    double[] dArray105 = this.cCoef[1];
                                    int n114 = j;
                                    dArray105[n114] = dArray105[n114] - coef3 * (double)(n + 1);
                                    double[] dArray106 = this.cCoef[2];
                                    int n115 = j;
                                    dArray106[n115] = dArray106[n115] - coef1 * (kns * dIjsdh + ijs * this.hXXX * dkns);
                                    double[] dArray107 = this.cCoef[3];
                                    int n116 = j;
                                    dArray107[n116] = dArray107[n116] - coef1 * (kns * dIjsdk + ijs * this.kXXX * dkns);
                                    double[] dArray108 = this.cCoef[4];
                                    int n117 = j;
                                    dArray108[n117] = dArray108[n117] - coef2 * dIjsdAlpha;
                                    double[] dArray109 = this.cCoef[5];
                                    int n118 = j;
                                    dArray109[n118] = dArray109[n118] - coef2 * dIjsdBeta;
                                    double[] dArray110 = this.cCoef[6];
                                    int n119 = j;
                                    dArray110[n119] = dArray110[n119] - coef0 * dlns * kns * ijs;
                                    double[] dArray111 = this.sCoef[0];
                                    int n120 = j;
                                    dArray111[n120] = dArray111[n120] + coef4;
                                    double[] dArray112 = this.sCoef[1];
                                    int n121 = j;
                                    dArray112[n121] = dArray112[n121] + coef4 * (double)(n + 1);
                                    double[] dArray113 = this.sCoef[2];
                                    int n122 = j;
                                    dArray113[n122] = dArray113[n122] + coef1 * (kns * dJjsdh + jjs * this.hXXX * dkns);
                                    double[] dArray114 = this.sCoef[3];
                                    int n123 = j;
                                    dArray114[n123] = dArray114[n123] + coef1 * (kns * dJjsdk + jjs * this.kXXX * dkns);
                                    double[] dArray115 = this.sCoef[4];
                                    int n124 = j;
                                    dArray115[n124] = dArray115[n124] + coef2 * dJjsdAlpha;
                                    double[] dArray116 = this.sCoef[5];
                                    int n125 = j;
                                    dArray116[n125] = dArray116[n125] + coef2 * dJjsdBeta;
                                    double[] dArray117 = this.sCoef[6];
                                    int n126 = j;
                                    dArray117[n126] = dArray117[n126] + coef0 * dlns * kns * jjs;
                                }
                            }
                        }
                    }
                }
                double[] dArray = this.cCoef[0];
                int n = j;
                dArray[n] = dArray[n] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray118 = this.cCoef[1];
                int n127 = j;
                dArray118[n127] = dArray118[n127] * (DSSTZonal.this.muoa / ((double)j * DSSTZonal.this.a));
                double[] dArray119 = this.cCoef[2];
                int n128 = j;
                dArray119[n128] = dArray119[n128] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray120 = this.cCoef[3];
                int n129 = j;
                dArray120[n129] = dArray120[n129] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray121 = this.cCoef[4];
                int n130 = j;
                dArray121[n130] = dArray121[n130] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray122 = this.cCoef[5];
                int n131 = j;
                dArray122[n131] = dArray122[n131] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray123 = this.cCoef[6];
                int n132 = j;
                dArray123[n132] = dArray123[n132] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray124 = this.sCoef[0];
                int n133 = j;
                dArray124[n133] = dArray124[n133] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray125 = this.sCoef[1];
                int n134 = j;
                dArray125[n134] = dArray125[n134] * (DSSTZonal.this.muoa / ((double)j * DSSTZonal.this.a));
                double[] dArray126 = this.sCoef[2];
                int n135 = j;
                dArray126[n135] = dArray126[n135] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray127 = this.sCoef[3];
                int n136 = j;
                dArray127[n136] = dArray127[n136] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray128 = this.sCoef[4];
                int n137 = j;
                dArray128[n137] = dArray128[n137] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray129 = this.sCoef[5];
                int n138 = j;
                dArray129[n138] = dArray129[n138] * (-DSSTZonal.this.muoa / (double)j);
                double[] dArray130 = this.sCoef[6];
                int n139 = j;
                dArray130[n139] = dArray130[n139] * (-DSSTZonal.this.muoa / (double)j);
            }
        }

        private boolean isBetween(int index, int lowerBound, int upperBound) {
            return index >= lowerBound && index <= upperBound;
        }

        public double getCj(int j) {
            return this.cCoef[0][j];
        }

        public double getdCjdA(int j) {
            return this.cCoef[1][j];
        }

        public double getdCjdH(int j) {
            return this.cCoef[2][j];
        }

        public double getdCjdK(int j) {
            return this.cCoef[3][j];
        }

        public double getdCjdAlpha(int j) {
            return this.cCoef[4][j];
        }

        public double getdCjdBeta(int j) {
            return this.cCoef[5][j];
        }

        public double getdCjdGamma(int j) {
            return this.cCoef[6][j];
        }

        public double getSj(int j) {
            return this.sCoef[0][j];
        }

        public double getdSjdA(int j) {
            return this.sCoef[1][j];
        }

        public double getdSjdH(int j) {
            return this.sCoef[2][j];
        }

        public double getdSjdK(int j) {
            return this.sCoef[3][j];
        }

        public double getdSjdAlpha(int j) {
            return this.sCoef[4][j];
        }

        public double getdSjdBeta(int j) {
            return this.sCoef[5][j];
        }

        public double getdSjdGamma(int j) {
            return this.sCoef[6][j];
        }
    }

    private static class ZonalShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private static final long serialVersionUID = 20151118L;
        private final int maxFrequencyShortPeriodics;
        private final int interpolationPoints;
        private final transient TimeSpanMap<Slot> slots;

        ZonalShortPeriodicCoefficients(int maxFrequencyShortPeriodics, int interpolationPoints, TimeSpanMap<Slot> slots) {
            this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.maxFrequencyShortPeriodics, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double L = meanOrbit.getLv();
            double center = L - meanOrbit.getLM();
            double[] shortPeriodicVariation = slot.cij[0].value(meanOrbit.getDate());
            double[] d = slot.di.value(meanOrbit.getDate());
            for (int i = 0; i < 6; ++i) {
                int n = i;
                shortPeriodicVariation[n] = shortPeriodicVariation[n] + center * d[i];
            }
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                double[] c = slot.cij[j].value(meanOrbit.getDate());
                double[] s = slot.sij[j].value(meanOrbit.getDate());
                double cos = FastMath.cos((double)((double)j * L));
                double sin = FastMath.sin((double)((double)j * L));
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodicVariation[n] = shortPeriodicVariation[n] + c[i] * cos;
                    int n2 = i;
                    shortPeriodicVariation[n2] = shortPeriodicVariation[n2] + s[i] * sin;
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return "DSST-central-body-zonal-";
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) throws OrekitException {
            Slot slot = this.slots.get(date);
            HashMap<String, double[]> coefficients = new HashMap<String, double[]>(2 * this.maxFrequencyShortPeriodics + 2);
            this.storeIfSelected(coefficients, selected, slot.cij[0].value(date), "d", 0);
            this.storeIfSelected(coefficients, selected, slot.di.value(date), "d", 1);
            for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                this.storeIfSelected(coefficients, selected, slot.cij[j].value(date), "c", j);
                this.storeIfSelected(coefficients, selected, slot.sij[j].value(date), "s", j);
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }

        private Object writeReplace() throws NotSerializableException {
            SortedSet<TimeSpanMap.Transition<Slot>> transitions = this.slots.getTransitions();
            AbsoluteDate[] transitionDates = new AbsoluteDate[transitions.size()];
            Slot[] allSlots = new Slot[transitions.size() + 1];
            int i = 0;
            for (TimeSpanMap.Transition transition : transitions) {
                if (i == 0) {
                    allSlots[i] = (Slot)transition.getBefore();
                }
                if (i >= transitionDates.length) continue;
                transitionDates[i] = transition.getDate();
                allSlots[++i] = (Slot)transition.getAfter();
            }
            return new DataTransferObject(this.maxFrequencyShortPeriodics, this.interpolationPoints, transitionDates, allSlots);
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20170420L;
            private final int maxFrequencyShortPeriodics;
            private final int interpolationPoints;
            private final AbsoluteDate[] transitionDates;
            private final Slot[] allSlots;

            DataTransferObject(int maxFrequencyShortPeriodics, int interpolationPoints, AbsoluteDate[] transitionDates, Slot[] allSlots) {
                this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
                this.interpolationPoints = interpolationPoints;
                this.transitionDates = transitionDates;
                this.allSlots = allSlots;
            }

            private Object readResolve() {
                TimeSpanMap<Slot> slots = new TimeSpanMap<Slot>(this.allSlots[0]);
                for (int i = 0; i < this.transitionDates.length; ++i) {
                    slots.addValidAfter(this.allSlots[i + 1], this.transitionDates[i]);
                }
                return new ZonalShortPeriodicCoefficients(this.maxFrequencyShortPeriodics, this.interpolationPoints, slots);
            }
        }
    }
}

