/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.JacobiPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenThirdBodyLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class DSSTThirdBody
implements DSSTForceModel {
    private static final int MAX_POWER = 22;
    private static final double BIG_TRUNCATION_TOLERANCE = 0.1;
    private static final double SMALL_TRUNCATION_TOLERANCE = 1.9E-6;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int MAX_ECCPOWER_SP = 4;
    private static final int I = 1;
    private final CelestialBody body;
    private final double gm;
    private final double[] fact;
    private final TreeMap<CoefficientsFactory.NSKey, Double> Vns;
    private double R3;
    private ThirdBodyShortPeriodicCoefficients shortPeriods;
    private double a;
    private double k;
    private double h;
    private double q;
    private double p;
    private double ecc;
    private double alpha;
    private double beta;
    private double gamma;
    private double A;
    private double B;
    private double C;
    private double BB;
    private double BBB;
    private double meanMotion;
    private double X;
    private double XX;
    private double XXX;
    private double m2aoA;
    private double BoA;
    private double ooAB;
    private double mCo2AB;
    private double BoABpo;
    private int maxAR3Pow;
    private int maxEccPow;
    private int maxEccPowShort;
    private int maxFreqF;
    private final HansenThirdBodyLinear[] hansenObjects;
    private double U;
    private double[][] Qns;
    private double[] aoR3Pow;
    private double muoR3;
    private double b;
    private double hXXX;
    private double kXXX;
    private final DSFactory factory;

    public DSSTThirdBody(CelestialBody body) {
        this.body = body;
        this.gm = body.getGM();
        this.maxAR3Pow = Integer.MIN_VALUE;
        this.maxEccPow = Integer.MIN_VALUE;
        this.Vns = CoefficientsFactory.computeVns(22);
        int dim = 44;
        this.fact = new double[44];
        this.fact[0] = 1.0;
        for (int i = 1; i < 44; ++i) {
            this.fact[i] = (double)i * this.fact[i - 1];
        }
        this.hansenObjects = new HansenThirdBodyLinear[23];
        for (int s = 0; s <= 22; ++s) {
            this.hansenObjects[s] = new HansenThirdBodyLinear(22, s);
        }
        this.factory = new DSFactory(1, 1);
    }

    public CelestialBody getBody() {
        return this.body;
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements aux, boolean meanOnly) throws OrekitException {
        this.initializeStep(aux);
        double aor = this.a / this.R3;
        double tol = aor > 0.3 || aor > 0.15 && this.ecc > 0.25 ? 0.1 : 1.9E-6;
        double eo2 = FastMath.max((double)0.0025, (double)(this.ecc / 2.0));
        double x2o2 = this.XX / 2.0;
        double[] eccPwr = new double[22];
        double[] chiPwr = new double[22];
        eccPwr[0] = 1.0;
        chiPwr[0] = this.X;
        for (int i = 1; i < 22; ++i) {
            eccPwr[i] = eccPwr[i - 1] * eo2;
            chiPwr[i] = chiPwr[i - 1] * x2o2;
        }
        double ao2rxx = aor / (2.0 * this.XX);
        double xmuarn = ao2rxx * ao2rxx * this.gm / (this.X * this.R3);
        double term = 0.0;
        this.maxAR3Pow = 2;
        this.maxEccPow = 0;
        int n = 2;
        int m = 2;
        int nsmd2 = 0;
        do {
            if ((term = xmuarn * (this.fact[n + m] / (this.fact[nsmd2] * this.fact[nsmd2 + m])) * (this.fact[n + m + 1] / (this.fact[m] * this.fact[n + 1])) * (this.fact[n - m + 1] / this.fact[n + 1]) * eccPwr[m] * UpperBounds.getDnl(this.XX, chiPwr[m], n + 2, m)) < tol) {
                if (m == 0) break;
                if (m < 2) {
                    xmuarn *= ao2rxx;
                    m = 0;
                    ++n;
                    ++nsmd2;
                    continue;
                }
                m -= 2;
                ++nsmd2;
                continue;
            }
            this.maxAR3Pow = n++;
            this.maxEccPow = FastMath.max((int)m, (int)this.maxEccPow);
            xmuarn *= ao2rxx;
            ++m;
        } while (n < 22);
        this.maxEccPow = FastMath.min((int)this.maxAR3Pow, (int)this.maxEccPow);
        this.aoR3Pow = new double[this.maxAR3Pow + 1];
        this.maxFreqF = this.maxAR3Pow + 1;
        this.maxEccPowShort = 4;
        this.Qns = CoefficientsFactory.computeQns(this.gamma, this.maxAR3Pow, FastMath.max((int)this.maxEccPow, (int)this.maxEccPowShort));
        int jMax = this.maxAR3Pow + 1;
        this.shortPeriods = new ThirdBodyShortPeriodicCoefficients(jMax, 3, this.maxFreqF, this.body.getName(), new TimeSpanMap<Slot>(new Slot(jMax, 3)));
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        list.add(this.shortPeriods);
        return list;
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) throws OrekitException {
        this.a = aux.getSma();
        this.k = aux.getK();
        this.h = aux.getH();
        this.q = aux.getQ();
        this.p = aux.getP();
        this.ecc = aux.getEcc();
        Vector3D bodyPos = this.body.getPVCoordinates(aux.getDate(), aux.getFrame()).getPosition();
        this.R3 = bodyPos.getNorm();
        Vector3D bodyDir = bodyPos.normalize();
        this.alpha = bodyDir.dotProduct((Vector)aux.getVectorF());
        this.beta = bodyDir.dotProduct((Vector)aux.getVectorG());
        this.gamma = bodyDir.dotProduct((Vector)aux.getVectorW());
        this.A = aux.getA();
        this.B = aux.getB();
        this.C = aux.getC();
        this.meanMotion = aux.getMeanMotion();
        this.BB = this.B * this.B;
        this.BBB = this.BB * this.B;
        this.b = 1.0 / (1.0 + this.B);
        this.X = 1.0 / this.B;
        this.XX = this.X * this.X;
        this.XXX = this.X * this.XX;
        this.m2aoA = -2.0 * this.a / this.A;
        this.BoA = this.B / this.A;
        this.ooAB = 1.0 / (this.A * this.B);
        this.mCo2AB = -this.C * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + this.B);
        this.muoR3 = this.gm / this.R3;
        this.hXXX = this.h * this.XXX;
        this.kXXX = this.k * this.XXX;
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState currentState) {
        this.Qns = CoefficientsFactory.computeQns(this.gamma, this.maxAR3Pow, this.maxEccPow);
        double aoR3 = this.a / this.R3;
        this.aoR3Pow[0] = 1.0;
        for (int i = 1; i <= this.maxAR3Pow; ++i) {
            this.aoR3Pow[i] = aoR3 * this.aoR3Pow[i - 1];
        }
        double[] dU = this.computeUDerivatives();
        double dUda = dU[0];
        double dUdk = dU[1];
        double dUdh = dU[2];
        double dUdAl = dU[3];
        double dUdBe = dU[4];
        double dUdGa = dU[5];
        double UAlphaGamma = this.alpha * dUdGa - this.gamma * dUdAl;
        double UBetaGamma = this.beta * dUdGa - this.gamma * dUdBe;
        double pUAGmIqUBGoAB = (this.p * UAlphaGamma - 1.0 * this.q * UBetaGamma) * this.ooAB;
        double da = 0.0;
        double dh = this.BoA * dUdk + this.k * pUAGmIqUBGoAB;
        double dk = -this.BoA * dUdh - this.h * pUAGmIqUBGoAB;
        double dp = this.mCo2AB * UBetaGamma;
        double dq = this.mCo2AB * UAlphaGamma * 1.0;
        double dM = this.m2aoA * dUda + this.BoABpo * (this.h * dUdh + this.k * dUdk) + pUAGmIqUBGoAB;
        return new double[]{0.0, dk, dh, dq, dp, dM};
    }

    @Override
    public void updateShortPeriodTerms(SpacecraftState ... meanStates) throws OrekitException {
        Slot slot = this.shortPeriods.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            this.initializeStep(new AuxiliaryElements(meanState.getOrbit(), 1));
            double aoR3 = this.a / this.R3;
            this.aoR3Pow[0] = 1.0;
            for (int i = 1; i <= this.maxAR3Pow; ++i) {
                this.aoR3Pow[i] = aoR3 * this.aoR3Pow[i - 1];
            }
            this.Qns = CoefficientsFactory.computeQns(this.gamma, this.maxAR3Pow, FastMath.max((int)this.maxEccPow, (int)this.maxEccPowShort));
            GeneratingFunctionCoefficients gfCoefs = new GeneratingFunctionCoefficients(this.maxAR3Pow, 4, this.maxAR3Pow + 1);
            double ax2oAn = -this.m2aoA / this.meanMotion;
            double BoAn = this.BoA / this.meanMotion;
            double ooABn = this.ooAB / this.meanMotion;
            double Co2ABn = -this.mCo2AB / this.meanMotion;
            double BoABpon = this.BoABpo / this.meanMotion;
            double m3onA = -3.0 / (this.A * this.meanMotion);
            for (int j = 1; j < slot.cij.length; ++j) {
                double[] currentCij = new double[6];
                double SAlphaGammaCj = this.alpha * gfCoefs.getdSdgammaCj(j) - this.gamma * gfCoefs.getdSdalphaCj(j);
                double SAlphaBetaCj = this.alpha * gfCoefs.getdSdbetaCj(j) - this.beta * gfCoefs.getdSdalphaCj(j);
                double SBetaGammaCj = this.beta * gfCoefs.getdSdgammaCj(j) - this.gamma * gfCoefs.getdSdbetaCj(j);
                double ShkCj = this.h * gfCoefs.getdSdkCj(j) - this.k * gfCoefs.getdSdhCj(j);
                double pSagmIqSbgoABnCj = (this.p * SAlphaGammaCj - 1.0 * this.q * SBetaGammaCj) * ooABn;
                double ShkmSabmdSdlCj = ShkCj - SAlphaBetaCj - gfCoefs.getdSdlambdaCj(j);
                currentCij[0] = ax2oAn * gfCoefs.getdSdlambdaCj(j);
                currentCij[1] = -(BoAn * gfCoefs.getdSdhCj(j) + this.h * pSagmIqSbgoABnCj + this.k * BoABpon * gfCoefs.getdSdlambdaCj(j));
                currentCij[2] = BoAn * gfCoefs.getdSdkCj(j) + this.k * pSagmIqSbgoABnCj - this.h * BoABpon * gfCoefs.getdSdlambdaCj(j);
                currentCij[3] = Co2ABn * (this.q * ShkmSabmdSdlCj - 1.0 * SAlphaGammaCj);
                currentCij[4] = Co2ABn * (this.p * ShkmSabmdSdlCj - SBetaGammaCj);
                currentCij[5] = -ax2oAn * gfCoefs.getdSdaCj(j) + BoABpon * (this.h * gfCoefs.getdSdhCj(j) + this.k * gfCoefs.getdSdkCj(j)) + pSagmIqSbgoABnCj + m3onA * gfCoefs.getSCj(j);
                slot.cij[j].addGridPoint(meanState.getDate(), currentCij);
                double[] currentSij = new double[6];
                double SAlphaGammaSj = this.alpha * gfCoefs.getdSdgammaSj(j) - this.gamma * gfCoefs.getdSdalphaSj(j);
                double SAlphaBetaSj = this.alpha * gfCoefs.getdSdbetaSj(j) - this.beta * gfCoefs.getdSdalphaSj(j);
                double SBetaGammaSj = this.beta * gfCoefs.getdSdgammaSj(j) - this.gamma * gfCoefs.getdSdbetaSj(j);
                double ShkSj = this.h * gfCoefs.getdSdkSj(j) - this.k * gfCoefs.getdSdhSj(j);
                double pSagmIqSbgoABnSj = (this.p * SAlphaGammaSj - 1.0 * this.q * SBetaGammaSj) * ooABn;
                double ShkmSabmdSdlSj = ShkSj - SAlphaBetaSj - gfCoefs.getdSdlambdaSj(j);
                currentSij[0] = ax2oAn * gfCoefs.getdSdlambdaSj(j);
                currentSij[1] = -(BoAn * gfCoefs.getdSdhSj(j) + this.h * pSagmIqSbgoABnSj + this.k * BoABpon * gfCoefs.getdSdlambdaSj(j));
                currentSij[2] = BoAn * gfCoefs.getdSdkSj(j) + this.k * pSagmIqSbgoABnSj - this.h * BoABpon * gfCoefs.getdSdlambdaSj(j);
                currentSij[3] = Co2ABn * (this.q * ShkmSabmdSdlSj - 1.0 * SAlphaGammaSj);
                currentSij[4] = Co2ABn * (this.p * ShkmSabmdSdlSj - SBetaGammaSj);
                currentSij[5] = -ax2oAn * gfCoefs.getdSdaSj(j) + BoABpon * (this.h * gfCoefs.getdSdhSj(j) + this.k * gfCoefs.getdSdkSj(j)) + pSagmIqSbgoABnSj + m3onA * gfCoefs.getSSj(j);
                slot.sij[j].addGridPoint(meanState.getDate(), currentSij);
                if (j != 1) continue;
                double[] value = new double[6];
                for (int i = 0; i < 6; ++i) {
                    value[i] = currentCij[i] * this.k / 2.0 + currentSij[i] * this.h / 2.0;
                }
                slot.cij[0].addGridPoint(meanState.getDate(), value);
            }
        }
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    private double[] computeUDerivatives() {
        double[][] GsHs = CoefficientsFactory.computeGsHs(this.k, this.h, this.alpha, this.beta, this.maxEccPow);
        this.U = 0.0;
        double dUda = 0.0;
        double dUdk = 0.0;
        double dUdh = 0.0;
        double dUdAl = 0.0;
        double dUdBe = 0.0;
        double dUdGa = 0.0;
        for (int s = 0; s <= this.maxEccPow; ++s) {
            this.hansenObjects[s].computeInitValues(this.B, this.BB, this.BBB);
            double gs = GsHs[0][s];
            double dGsdh = 0.0;
            double dGsdk = 0.0;
            double dGsdAl = 0.0;
            double dGsdBe = 0.0;
            if (s > 0) {
                double sxGsm1 = (double)s * GsHs[0][s - 1];
                double sxHsm1 = (double)s * GsHs[1][s - 1];
                dGsdh = this.beta * sxGsm1 - this.alpha * sxHsm1;
                dGsdk = this.alpha * sxGsm1 + this.beta * sxHsm1;
                dGsdAl = this.k * sxGsm1 - this.h * sxHsm1;
                dGsdBe = this.h * sxGsm1 + this.k * sxHsm1;
            }
            double delta0s = s == 0 ? 1.0 : 2.0;
            for (int n = FastMath.max((int)2, (int)s); n <= this.maxAR3Pow; ++n) {
                if ((n - s) % 2 != 0) continue;
                double kns = this.hansenObjects[s].getValue(n, this.B);
                double dkns = this.hansenObjects[s].getDerivative(n, this.B);
                double vns = this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                double coef0 = delta0s * this.aoR3Pow[n] * vns;
                double coef1 = coef0 * this.Qns[n][s];
                double coef2 = coef1 * kns;
                double dqns = n == s ? 0.0 : this.Qns[n][s + 1];
                this.U += coef2 * gs;
                dUda += coef2 * (double)n * gs;
                dUdh += coef1 * (kns * dGsdh + this.hXXX * gs * dkns);
                dUdk += coef1 * (kns * dGsdk + this.kXXX * gs * dkns);
                dUdAl += coef2 * dGsdAl;
                dUdBe += coef2 * dGsdBe;
                dUdGa += coef0 * kns * dqns * gs;
            }
        }
        this.U *= this.muoR3;
        return new double[]{dUda * this.muoR3 / this.a, dUdk * this.muoR3, dUdh * this.muoR3, dUdAl * this.muoR3, dUdBe * this.muoR3, dUdGa * this.muoR3};
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider provider) {
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = 20160319L;
        private final ShortPeriodicsInterpolatedCoefficient[] cij;
        private final ShortPeriodicsInterpolatedCoefficient[] sij;

        Slot(int jMax, int interpolationPoints) {
            this.cij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            this.sij = new ShortPeriodicsInterpolatedCoefficient[jMax + 1];
            for (int j = 0; j <= jMax; ++j) {
                this.cij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                this.sij[j] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
            }
        }
    }

    private static class ThirdBodyShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private static final long serialVersionUID = 20151119L;
        private final int jMax;
        private final int interpolationPoints;
        private final int maxFreqF;
        private final String prefix;
        private final transient TimeSpanMap<Slot> slots;

        ThirdBodyShortPeriodicCoefficients(int jMax, int interpolationPoints, int maxFreqF, String bodyName, TimeSpanMap<Slot> slots) {
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.maxFreqF = maxFreqF;
            this.prefix = "DSST-3rd-body-" + bodyName + "-";
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.jMax, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double F = meanOrbit.getLE();
            double[] shortPeriodic = slot.cij[0].value(meanOrbit.getDate());
            for (int j = 1; j <= this.maxFreqF; ++j) {
                double cosjF = FastMath.cos((double)((double)j * F));
                double sinjF = FastMath.sin((double)((double)j * F));
                double[] c = slot.cij[j].value(meanOrbit.getDate());
                double[] s = slot.sij[j].value(meanOrbit.getDate());
                for (int i = 0; i < 6; ++i) {
                    int n = i;
                    shortPeriodic[n] = shortPeriodic[n] + (c[i] * cosjF + s[i] * sinjF);
                }
            }
            return shortPeriodic;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return this.prefix;
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) throws OrekitException {
            Slot slot = this.slots.get(date);
            HashMap<String, double[]> coefficients = new HashMap<String, double[]>(2 * this.maxFreqF + 1);
            this.storeIfSelected(coefficients, selected, slot.cij[0].value(date), "c", 0);
            for (int j = 1; j <= this.maxFreqF; ++j) {
                this.storeIfSelected(coefficients, selected, slot.cij[j].value(date), "c", j);
                this.storeIfSelected(coefficients, selected, slot.sij[j].value(date), "s", j);
            }
            return coefficients;
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }

        private Object writeReplace() throws NotSerializableException {
            SortedSet<TimeSpanMap.Transition<Slot>> transitions = this.slots.getTransitions();
            AbsoluteDate[] transitionDates = new AbsoluteDate[transitions.size()];
            Slot[] allSlots = new Slot[transitions.size() + 1];
            int i = 0;
            for (TimeSpanMap.Transition transition : transitions) {
                if (i == 0) {
                    allSlots[i] = (Slot)transition.getBefore();
                }
                if (i >= transitionDates.length) continue;
                transitionDates[i] = transition.getDate();
                allSlots[++i] = (Slot)transition.getAfter();
            }
            return new DataTransferObject(this.jMax, this.interpolationPoints, this.maxFreqF, this.prefix, transitionDates, allSlots);
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20160319L;
            private final int jMax;
            private final int interpolationPoints;
            private final int maxFreqF;
            private final String prefix;
            private final AbsoluteDate[] transitionDates;
            private final Slot[] allSlots;

            DataTransferObject(int jMax, int interpolationPoints, int maxFreqF, String prefix, AbsoluteDate[] transitionDates, Slot[] allSlots) {
                this.jMax = jMax;
                this.interpolationPoints = interpolationPoints;
                this.maxFreqF = maxFreqF;
                this.prefix = prefix;
                this.transitionDates = transitionDates;
                this.allSlots = allSlots;
            }

            private Object readResolve() {
                TimeSpanMap<Slot> slots = new TimeSpanMap<Slot>(this.allSlots[0]);
                for (int i = 0; i < this.transitionDates.length; ++i) {
                    slots.addValidAfter(this.allSlots[i + 1], this.transitionDates[i]);
                }
                return new ThirdBodyShortPeriodicCoefficients(this.jMax, this.interpolationPoints, this.maxFreqF, this.prefix, slots);
            }
        }
    }

    private class GeneratingFunctionCoefficients {
        private final FourierCjSjCoefficients cjsjFourier;
        private final int jMax;
        private final double[][] cjCoefs;
        private final double[][] sjCoefs;

        GeneratingFunctionCoefficients(int nMax, int sMax, int jMax) {
            this.jMax = jMax;
            this.cjsjFourier = new FourierCjSjCoefficients(nMax, sMax, jMax);
            this.cjCoefs = new double[8][jMax + 1];
            this.sjCoefs = new double[8][jMax + 1];
            this.computeGeneratingFunctionCoefficients();
        }

        private void computeGeneratingFunctionCoefficients() {
            double[] dU = DSSTThirdBody.this.computeUDerivatives();
            for (int j = 1; j <= this.jMax; ++j) {
                this.cjCoefs[0][j] = this.cjsjFourier.getCj(j);
                this.cjCoefs[1][j] = this.cjsjFourier.getdCjda(j);
                this.cjCoefs[2][j] = this.cjsjFourier.getdCjdk(j) - (this.cjsjFourier.getSjLambda(j - 1) - this.cjsjFourier.getSjLambda(j + 1)) / 2.0;
                this.cjCoefs[3][j] = this.cjsjFourier.getdCjdh(j) - (this.cjsjFourier.getCjLambda(j - 1) + this.cjsjFourier.getCjLambda(j + 1)) / 2.0;
                this.cjCoefs[4][j] = this.cjsjFourier.getdCjdalpha(j);
                this.cjCoefs[5][j] = this.cjsjFourier.getdCjdbeta(j);
                this.cjCoefs[6][j] = this.cjsjFourier.getdCjdgamma(j);
                this.cjCoefs[7][j] = this.cjsjFourier.getCjLambda(j);
                this.sjCoefs[0][j] = this.cjsjFourier.getSj(j);
                this.sjCoefs[1][j] = this.cjsjFourier.getdSjda(j);
                this.sjCoefs[2][j] = this.cjsjFourier.getdSjdk(j) + (this.cjsjFourier.getCjLambda(j - 1) - this.cjsjFourier.getCjLambda(j + 1)) / 2.0;
                this.sjCoefs[3][j] = this.cjsjFourier.getdSjdh(j) - (this.cjsjFourier.getSjLambda(j - 1) + this.cjsjFourier.getSjLambda(j + 1)) / 2.0;
                this.sjCoefs[4][j] = this.cjsjFourier.getdSjdalpha(j);
                this.sjCoefs[5][j] = this.cjsjFourier.getdSjdbeta(j);
                this.sjCoefs[6][j] = this.cjsjFourier.getdSjdgamma(j);
                this.sjCoefs[7][j] = this.cjsjFourier.getSjLambda(j);
                if (j != 1) continue;
                double[] dArray = this.cjCoefs[0];
                int n = j;
                dArray[n] = dArray[n] + -DSSTThirdBody.this.h * DSSTThirdBody.this.U;
                double[] dArray2 = this.cjCoefs[1];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + -DSSTThirdBody.this.h * dU[0];
                double[] dArray3 = this.cjCoefs[2];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + -DSSTThirdBody.this.h * dU[1];
                double[] dArray4 = this.cjCoefs[3];
                int n4 = j;
                dArray4[n4] = dArray4[n4] + -(DSSTThirdBody.this.h * dU[2] + DSSTThirdBody.this.U + this.cjsjFourier.getC0Lambda());
                double[] dArray5 = this.cjCoefs[4];
                int n5 = j;
                dArray5[n5] = dArray5[n5] + -DSSTThirdBody.this.h * dU[3];
                double[] dArray6 = this.cjCoefs[5];
                int n6 = j;
                dArray6[n6] = dArray6[n6] + -DSSTThirdBody.this.h * dU[4];
                double[] dArray7 = this.cjCoefs[6];
                int n7 = j;
                dArray7[n7] = dArray7[n7] + -DSSTThirdBody.this.h * dU[5];
                double[] dArray8 = this.sjCoefs[0];
                int n8 = j;
                dArray8[n8] = dArray8[n8] + DSSTThirdBody.this.k * DSSTThirdBody.this.U;
                double[] dArray9 = this.sjCoefs[1];
                int n9 = j;
                dArray9[n9] = dArray9[n9] + DSSTThirdBody.this.k * dU[0];
                double[] dArray10 = this.sjCoefs[2];
                int n10 = j;
                dArray10[n10] = dArray10[n10] + (DSSTThirdBody.this.k * dU[1] + DSSTThirdBody.this.U + this.cjsjFourier.getC0Lambda());
                double[] dArray11 = this.sjCoefs[3];
                int n11 = j;
                dArray11[n11] = dArray11[n11] + DSSTThirdBody.this.k * dU[2];
                double[] dArray12 = this.sjCoefs[4];
                int n12 = j;
                dArray12[n12] = dArray12[n12] + DSSTThirdBody.this.k * dU[3];
                double[] dArray13 = this.sjCoefs[5];
                int n13 = j;
                dArray13[n13] = dArray13[n13] + DSSTThirdBody.this.k * dU[4];
                double[] dArray14 = this.sjCoefs[6];
                int n14 = j;
                dArray14[n14] = dArray14[n14] + DSSTThirdBody.this.k * dU[5];
            }
        }

        public double getSCj(int j) {
            return this.cjCoefs[0][j];
        }

        public double getSSj(int j) {
            return this.sjCoefs[0][j];
        }

        public double getdSdaCj(int j) {
            return this.cjCoefs[1][j];
        }

        public double getdSdaSj(int j) {
            return this.sjCoefs[1][j];
        }

        public double getdSdkCj(int j) {
            return this.cjCoefs[2][j];
        }

        public double getdSdkSj(int j) {
            return this.sjCoefs[2][j];
        }

        public double getdSdhCj(int j) {
            return this.cjCoefs[3][j];
        }

        public double getdSdhSj(int j) {
            return this.sjCoefs[3][j];
        }

        public double getdSdalphaCj(int j) {
            return this.cjCoefs[4][j];
        }

        public double getdSdalphaSj(int j) {
            return this.sjCoefs[4][j];
        }

        public double getdSdbetaCj(int j) {
            return this.cjCoefs[5][j];
        }

        public double getdSdbetaSj(int j) {
            return this.sjCoefs[5][j];
        }

        public double getdSdgammaCj(int j) {
            return this.cjCoefs[6][j];
        }

        public double getdSdgammaSj(int j) {
            return this.sjCoefs[6][j];
        }

        public double getdSdlambdaCj(int j) {
            return this.cjCoefs[7][j];
        }

        public double getdSdlambdaSj(int j) {
            return this.sjCoefs[7][j];
        }
    }

    private class CjSjAlphaBetaKH {
        private final CjSjCoefficient cjsjkh;
        private final CjSjCoefficient cjsjalbe;
        private final double[] coefAandDeriv;
        private final double[] coefBandDeriv;
        private final double[] coefDandDeriv;
        private final double[] coefEandDeriv;

        CjSjAlphaBetaKH() {
            this.cjsjkh = new CjSjCoefficient(DSSTThirdBody.this.k, DSSTThirdBody.this.h);
            this.cjsjalbe = new CjSjCoefficient(DSSTThirdBody.this.alpha, DSSTThirdBody.this.beta);
            this.coefAandDeriv = new double[5];
            this.coefBandDeriv = new double[5];
            this.coefDandDeriv = new double[5];
            this.coefEandDeriv = new double[5];
        }

        public void computeCoefficients(int j, int s) {
            int sign = j < s ? -1 : 1;
            int absJmS = FastMath.abs((int)(j - s));
            int jps = j + s;
            this.coefAandDeriv[0] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getCj(absJmS);
            this.coefAandDeriv[1] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDk(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDk(absJmS);
            this.coefAandDeriv[2] = (double)sign * this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDh(absJmS) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDh(absJmS);
            this.coefAandDeriv[3] = (double)sign * this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getCj(absJmS);
            this.coefAandDeriv[4] = (double)sign * this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getSj(absJmS) + this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getCj(absJmS);
            this.coefBandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getCj(jps);
            this.coefBandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDk(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDk(jps);
            this.coefBandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDsjDh(jps) - this.cjsjalbe.getSj(s) * this.cjsjkh.getDcjDh(jps);
            this.coefBandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getCj(jps);
            this.coefBandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getSj(jps) - this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getCj(jps);
            this.coefDandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getSj(absJmS);
            this.coefDandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDk(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDk(absJmS);
            this.coefDandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDh(absJmS) - (double)sign * this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDh(absJmS);
            this.coefDandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getSj(absJmS);
            this.coefDandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getCj(absJmS) - (double)sign * this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getSj(absJmS);
            this.coefEandDeriv[0] = this.cjsjalbe.getCj(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getSj(jps);
            this.coefEandDeriv[1] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDk(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDk(jps);
            this.coefEandDeriv[2] = this.cjsjalbe.getCj(s) * this.cjsjkh.getDcjDh(jps) + this.cjsjalbe.getSj(s) * this.cjsjkh.getDsjDh(jps);
            this.coefEandDeriv[3] = this.cjsjalbe.getDcjDk(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getDsjDk(s) * this.cjsjkh.getSj(jps);
            this.coefEandDeriv[4] = this.cjsjalbe.getDcjDh(s) * this.cjsjkh.getCj(jps) + this.cjsjalbe.getDsjDh(s) * this.cjsjkh.getSj(jps);
        }

        public double getCoefA() {
            return this.coefAandDeriv[0];
        }

        public double getdCoefAdk() {
            return this.coefAandDeriv[1];
        }

        public double getdCoefAdh() {
            return this.coefAandDeriv[2];
        }

        public double getdCoefAdalpha() {
            return this.coefAandDeriv[3];
        }

        public double getdCoefAdbeta() {
            return this.coefAandDeriv[4];
        }

        public double getCoefB() {
            return this.coefBandDeriv[0];
        }

        public double getdCoefBdk() {
            return this.coefBandDeriv[1];
        }

        public double getdCoefBdh() {
            return this.coefBandDeriv[2];
        }

        public double getdCoefBdalpha() {
            return this.coefBandDeriv[3];
        }

        public double getdCoefBdbeta() {
            return this.coefBandDeriv[4];
        }

        public double getCoefD() {
            return this.coefDandDeriv[0];
        }

        public double getdCoefDdk() {
            return this.coefDandDeriv[1];
        }

        public double getdCoefDdh() {
            return this.coefDandDeriv[2];
        }

        public double getdCoefDdalpha() {
            return this.coefDandDeriv[3];
        }

        public double getdCoefDdbeta() {
            return this.coefDandDeriv[4];
        }

        public double getCoefE() {
            return this.coefEandDeriv[0];
        }

        public double getdCoefEdk() {
            return this.coefEandDeriv[1];
        }

        public double getdCoefEdh() {
            return this.coefEandDeriv[2];
        }

        public double getdCoefEdalpha() {
            return this.coefEandDeriv[3];
        }

        public double getdCoefEdbeta() {
            return this.coefEandDeriv[4];
        }
    }

    private class GnsCoefficients {
        private final int nMax;
        private final int sMax;
        private final double[][] gns;
        private final double[][] dgnsda;
        private final double[][] dgnsdgamma;

        GnsCoefficients(int nMax, int sMax) {
            this.nMax = nMax;
            this.sMax = sMax;
            int rows = nMax + 1;
            int columns = sMax + 1;
            this.gns = new double[rows][columns];
            this.dgnsda = new double[rows][columns];
            this.dgnsdgamma = new double[rows][columns];
            this.generateCoefficients();
        }

        private void generateCoefficients() {
            for (int s = 0; s <= this.sMax; ++s) {
                int minN;
                for (int n = minN = FastMath.max((int)2, (int)s); n <= this.nMax; ++n) {
                    if ((n - s) % 2 == 0) {
                        double delta0s = s == 0 ? 1.0 : 2.0;
                        double vns = (Double)DSSTThirdBody.this.Vns.get(new CoefficientsFactory.NSKey(n, s));
                        double coef0 = delta0s * DSSTThirdBody.this.aoR3Pow[n] * vns * DSSTThirdBody.this.muoR3;
                        double coef1 = coef0 * DSSTThirdBody.this.Qns[n][s];
                        double dqns = n == s ? 0.0 : DSSTThirdBody.this.Qns[n][s + 1];
                        this.gns[n][s] = coef1;
                        this.dgnsda[n][s] = coef1 * (double)n / DSSTThirdBody.this.a;
                        this.dgnsdgamma[n][s] = coef0 * dqns;
                        continue;
                    }
                    this.gns[n][s] = 0.0;
                    this.dgnsda[n][s] = 0.0;
                    this.dgnsdgamma[n][s] = 0.0;
                }
            }
        }

        public double getGns(int n, int s) {
            return this.gns[n][s];
        }

        public double getdGnsda(int n, int s) {
            return this.dgnsda[n][s];
        }

        public double getdGnsdgamma(int n, int s) {
            return this.dgnsdgamma[n][s];
        }
    }

    private class WnsjEtomjmsCoefficient {
        private final double c;
        private final double dbdh;
        private final double dbdk;
        private final double dcdh;
        private final double dcdk;
        private final double[] omc2tn;
        private final double[] opc2tn;
        private final double[] btjms;

        WnsjEtomjmsCoefficient() {
            int i;
            this.c = DSSTThirdBody.this.ecc * DSSTThirdBody.this.b;
            double c2 = this.c * this.c;
            double b2Chi = DSSTThirdBody.this.b * DSSTThirdBody.this.b * DSSTThirdBody.this.X;
            this.dbdh = DSSTThirdBody.this.h * b2Chi;
            this.dbdk = DSSTThirdBody.this.k * b2Chi;
            if (DSSTThirdBody.this.ecc == 0.0) {
                this.dcdh = DSSTThirdBody.this.ecc * this.dbdh + DSSTThirdBody.this.b;
                this.dcdk = DSSTThirdBody.this.ecc * this.dbdk;
            } else {
                this.dcdh = DSSTThirdBody.this.ecc * this.dbdh + DSSTThirdBody.this.b * DSSTThirdBody.this.h / DSSTThirdBody.this.ecc;
                this.dcdk = DSSTThirdBody.this.ecc * this.dbdk + DSSTThirdBody.this.b * DSSTThirdBody.this.k / DSSTThirdBody.this.ecc;
            }
            this.omc2tn = new double[DSSTThirdBody.this.maxAR3Pow + DSSTThirdBody.this.maxFreqF + 2];
            this.opc2tn = new double[DSSTThirdBody.this.maxAR3Pow + DSSTThirdBody.this.maxFreqF + 2];
            double omc2 = 1.0 - c2;
            double opc2 = 1.0 + c2;
            this.omc2tn[0] = 1.0;
            this.opc2tn[0] = 1.0;
            for (i = 1; i <= DSSTThirdBody.this.maxAR3Pow + DSSTThirdBody.this.maxFreqF + 1; ++i) {
                this.omc2tn[i] = this.omc2tn[i - 1] * omc2;
                this.opc2tn[i] = this.opc2tn[i - 1] * opc2;
            }
            this.btjms = new double[DSSTThirdBody.this.maxAR3Pow + DSSTThirdBody.this.maxFreqF + 1];
            this.btjms[0] = 1.0;
            for (i = 1; i <= DSSTThirdBody.this.maxAR3Pow + DSSTThirdBody.this.maxFreqF; ++i) {
                this.btjms[i] = this.btjms[i - 1] * DSSTThirdBody.this.b;
            }
        }

        public double[] computeWjnsEmjmsAndDeriv(int j, int s, int n) {
            int l;
            double factCoef;
            double[] wjnsemjms = new double[]{0.0, 0.0, 0.0};
            int absJ = FastMath.abs((int)j);
            int absS = FastMath.abs((int)s);
            int absJmS = FastMath.abs((int)(j - s));
            int absJpS = FastMath.abs((int)(j + s));
            if (absS > absJ) {
                factCoef = DSSTThirdBody.this.fact[n + s] / DSSTThirdBody.this.fact[n + j] * (DSSTThirdBody.this.fact[n - s] / DSSTThirdBody.this.fact[n - j]);
                l = n - absS;
            } else {
                factCoef = 1.0;
                l = n - absJ;
            }
            double sign = absJmS % 2 != 0 ? -1.0 : 1.0;
            double coef1 = this.omc2tn[l] / this.opc2tn[n];
            double coef2 = sign * this.btjms[absJmS];
            DerivativeStructure jac = JacobiPolynomials.getValue(l, absJmS, absJpS, DSSTThirdBody.this.factory.variable(0, DSSTThirdBody.this.X));
            double dcoef1dc = -coef1 * 2.0 * this.c * ((double)n / this.opc2tn[1] + (double)l / this.omc2tn[1]);
            double dcoef1dh = dcoef1dc * this.dcdh;
            double dcoef1dk = dcoef1dc * this.dcdk;
            double dcoef2db = absJmS == 0 ? 0.0 : sign * (double)absJmS * this.btjms[absJmS - 1];
            double dcoef2dh = dcoef2db * this.dbdh;
            double dcoef2dk = dcoef2db * this.dbdk;
            double jacobi = jac.getValue();
            double djacobidh = jac.getPartialDerivative(new int[]{1}) * DSSTThirdBody.this.hXXX;
            double djacobidk = jac.getPartialDerivative(new int[]{1}) * DSSTThirdBody.this.kXXX;
            double term1 = factCoef * coef1 * coef2;
            double term2 = factCoef * coef1 * jacobi;
            double term3 = factCoef * coef2 * jacobi;
            wjnsemjms[0] = term1 * jacobi;
            wjnsemjms[1] = dcoef1dk * term3 + dcoef2dk * term2 + djacobidk * term1;
            wjnsemjms[2] = dcoef1dh * term3 + dcoef2dh * term2 + djacobidh * term1;
            return wjnsemjms;
        }
    }

    private class FourierCjSjCoefficients {
        private final GnsCoefficients gns;
        private final WnsjEtomjmsCoefficient wnsjEtomjmsCoefficient;
        private final CjSjAlphaBetaKH ABDECoefficients;
        private final double[][] cj;
        private final double[][] sj;
        private final double[] cjlambda;
        private final double[] sjlambda;
        private final int nMax;
        private final int sMax;
        private final int jMax;

        FourierCjSjCoefficients(int nMax, int sMax, int jMax) {
            this.nMax = nMax;
            this.sMax = sMax;
            this.jMax = jMax;
            this.wnsjEtomjmsCoefficient = new WnsjEtomjmsCoefficient();
            this.ABDECoefficients = new CjSjAlphaBetaKH();
            this.gns = new GnsCoefficients(nMax, sMax);
            this.cj = new double[7][jMax + 1];
            this.sj = new double[7][jMax + 1];
            this.cjlambda = new double[jMax];
            this.sjlambda = new double[jMax];
            this.computeCoefficients();
        }

        private void computeCoefficients() {
            for (int j = 1; j <= this.jMax; ++j) {
                int i;
                for (i = 0; i <= 6; ++i) {
                    this.cj[i][j] = 0.0;
                    this.sj[i][j] = 0.0;
                }
                if (j < this.jMax) {
                    this.cjlambda[j] = 0.0;
                    this.sjlambda[j] = 0.0;
                }
                for (int s = 0; s <= this.sMax; ++s) {
                    int minN;
                    this.ABDECoefficients.computeCoefficients(j, s);
                    for (int n = minN = FastMath.max((int)2, (int)FastMath.max((int)(j - 1), (int)s)); n <= this.nMax; ++n) {
                        if ((n - s) % 2 != 0) continue;
                        double[] wjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n + 1);
                        double[] wmjnp1semjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n + 1);
                        double coef1 = -(wjnp1semjms[0] * this.ABDECoefficients.getCoefA() + wmjnp1semjms[0] * this.ABDECoefficients.getCoefB());
                        double coef2 = wjnp1semjms[0] * this.ABDECoefficients.getCoefD() + wmjnp1semjms[0] * this.ABDECoefficients.getCoefE();
                        double[] dArray = this.cj[0];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + this.gns.getGns(n, s) * coef1;
                        double[] dArray2 = this.cj[1];
                        int n3 = j;
                        dArray2[n3] = dArray2[n3] + this.gns.getdGnsda(n, s) * coef1;
                        double[] dArray3 = this.cj[2];
                        int n4 = j;
                        dArray3[n4] = dArray3[n4] + -this.gns.getGns(n, s) * (wjnp1semjms[1] * this.ABDECoefficients.getCoefA() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdk() + wmjnp1semjms[1] * this.ABDECoefficients.getCoefB() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdk());
                        double[] dArray4 = this.cj[3];
                        int n5 = j;
                        dArray4[n5] = dArray4[n5] + -this.gns.getGns(n, s) * (wjnp1semjms[2] * this.ABDECoefficients.getCoefA() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdh() + wmjnp1semjms[2] * this.ABDECoefficients.getCoefB() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdh());
                        double[] dArray5 = this.cj[4];
                        int n6 = j;
                        dArray5[n6] = dArray5[n6] + -this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdalpha() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdalpha());
                        double[] dArray6 = this.cj[5];
                        int n7 = j;
                        dArray6[n7] = dArray6[n7] + -this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefAdbeta() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefBdbeta());
                        double[] dArray7 = this.cj[6];
                        int n8 = j;
                        dArray7[n8] = dArray7[n8] + this.gns.getdGnsdgamma(n, s) * coef1;
                        double[] dArray8 = this.sj[0];
                        int n9 = j;
                        dArray8[n9] = dArray8[n9] + this.gns.getGns(n, s) * coef2;
                        double[] dArray9 = this.sj[1];
                        int n10 = j;
                        dArray9[n10] = dArray9[n10] + this.gns.getdGnsda(n, s) * coef2;
                        double[] dArray10 = this.sj[2];
                        int n11 = j;
                        dArray10[n11] = dArray10[n11] + this.gns.getGns(n, s) * (wjnp1semjms[1] * this.ABDECoefficients.getCoefD() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdk() + wmjnp1semjms[1] * this.ABDECoefficients.getCoefE() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdk());
                        double[] dArray11 = this.sj[3];
                        int n12 = j;
                        dArray11[n12] = dArray11[n12] + this.gns.getGns(n, s) * (wjnp1semjms[2] * this.ABDECoefficients.getCoefD() + wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdh() + wmjnp1semjms[2] * this.ABDECoefficients.getCoefE() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdh());
                        double[] dArray12 = this.sj[4];
                        int n13 = j;
                        dArray12[n13] = dArray12[n13] + this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdalpha() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdalpha());
                        double[] dArray13 = this.sj[5];
                        int n14 = j;
                        dArray13[n14] = dArray13[n14] + this.gns.getGns(n, s) * (wjnp1semjms[0] * this.ABDECoefficients.getdCoefDdbeta() + wmjnp1semjms[0] * this.ABDECoefficients.getdCoefEdbeta());
                        double[] dArray14 = this.sj[6];
                        int n15 = j;
                        dArray14[n15] = dArray14[n15] + this.gns.getdGnsdgamma(n, s) * coef2;
                        if (n < j || j >= this.jMax) continue;
                        double[] wjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(j, s, n);
                        double[] wmjnsemjms = this.wnsjEtomjmsCoefficient.computeWjnsEmjmsAndDeriv(-j, s, n);
                        int n16 = j;
                        this.cjlambda[n16] = this.cjlambda[n16] + this.gns.getGns(n, s) * (wjnsemjms[0] * this.ABDECoefficients.getCoefD() + wmjnsemjms[0] * this.ABDECoefficients.getCoefE());
                        int n17 = j;
                        this.sjlambda[n17] = this.sjlambda[n17] + this.gns.getGns(n, s) * (wjnsemjms[0] * this.ABDECoefficients.getCoefA() + wmjnsemjms[0] * this.ABDECoefficients.getCoefB());
                    }
                }
                for (i = 0; i <= 6; ++i) {
                    double[] dArray = this.cj[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)j;
                    double[] dArray15 = this.sj[i];
                    int n18 = j;
                    dArray15[n18] = dArray15[n18] / (double)j;
                }
            }
            this.cjlambda[0] = DSSTThirdBody.this.k * this.cjlambda[1] / 2.0 + DSSTThirdBody.this.h * this.sjlambda[1] / 2.0;
        }

        public double getCj(int j) {
            return this.cj[0][j];
        }

        public double getdCjda(int j) {
            return this.cj[1][j];
        }

        public double getdCjdk(int j) {
            return this.cj[2][j];
        }

        public double getdCjdh(int j) {
            return this.cj[3][j];
        }

        public double getdCjdalpha(int j) {
            return this.cj[4][j];
        }

        public double getdCjdbeta(int j) {
            return this.cj[5][j];
        }

        public double getdCjdgamma(int j) {
            return this.cj[6][j];
        }

        public double getSj(int j) {
            return this.sj[0][j];
        }

        public double getdSjda(int j) {
            return this.sj[1][j];
        }

        public double getdSjdk(int j) {
            return this.sj[2][j];
        }

        public double getdSjdh(int j) {
            return this.sj[3][j];
        }

        public double getdSjdalpha(int j) {
            return this.sj[4][j];
        }

        public double getdSjdbeta(int j) {
            return this.sj[5][j];
        }

        public double getdSjdgamma(int j) {
            return this.sj[6][j];
        }

        public double getC0Lambda() {
            return this.cjlambda[0];
        }

        public double getCjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return 0.0;
            }
            return this.cjlambda[j];
        }

        public double getSjLambda(int j) {
            if (j < 1 || j >= this.jMax) {
                return 0.0;
            }
            return this.sjlambda[j];
        }
    }
}

