/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.FieldDenseOutputModel;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.FieldSecondaryODE;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldAbstractPropagator;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.integration.FieldAdditionalEquations;
import org.orekit.propagation.integration.FieldIntegratedEphemeris;
import org.orekit.propagation.integration.FieldModeHandler;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;

public abstract class FieldAbstractIntegratedPropagator<T extends RealFieldElement<T>>
extends FieldAbstractPropagator<T> {
    private final List<FieldEventDetector<T>> detectors = new ArrayList<FieldEventDetector<T>>();
    private final FieldODEIntegrator<T> integrator;
    private FieldModeHandler<T> modeHandler;
    private List<FieldAdditionalEquations<T>> additionalEquations = new ArrayList<FieldAdditionalEquations<T>>();
    private int calls;
    private FieldStateMapper<T> stateMapper;
    private FieldEquationsMapper<T> equationsMapper;
    private FieldODEStateInterpolator<T> mathInterpolator;
    private boolean resetAtEnd;
    private boolean meanOrbit;

    protected FieldAbstractIntegratedPropagator(Field<T> field, FieldODEIntegrator<T> integrator, boolean meanOrbit) {
        super(field);
        this.integrator = integrator;
        this.meanOrbit = meanOrbit;
        this.resetAtEnd = true;
    }

    public void setResetAtEnd(boolean resetAtEnd) {
        this.resetAtEnd = resetAtEnd;
    }

    protected void initMapper() {
        this.stateMapper = this.createMapper(null, Double.NaN, null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    protected boolean isMeanOrbit() {
        return this.meanOrbit;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(double mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public double getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (FieldAdditionalEquations<T> equation : this.additionalEquations) {
            if (!equation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalEquations.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalEquations.get(i).getName();
        }
        return managed;
    }

    public void addAdditionalEquations(FieldAdditionalEquations<T> additional) throws OrekitException {
        if (this.isAdditionalStateManaged(additional.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additional.getName());
        }
        this.additionalEquations.add(additional);
    }

    @Override
    public <D extends FieldEventDetector<T>> void addEventDetector(D detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<FieldEventDetector<T>> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (FieldEventDetector<T> detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(FieldODEIntegrator<T> integ, FieldEventDetector<T> detector) {
        integ.addEventHandler((FieldODEEventHandler)new FieldAdaptedEventDetector(detector), detector.getMaxCheckInterval().getReal(), detector.getThreshold().getReal(), detector.getMaxIterationCount());
    }

    @Override
    public void setSlaveMode() {
        super.setSlaveMode();
        if (this.integrator != null) {
            this.integrator.clearStepHandlers();
        }
        this.modeHandler = null;
    }

    @Override
    public void setMasterMode(FieldOrekitStepHandler<T> handler) {
        super.setMasterMode(handler);
        this.integrator.clearStepHandlers();
        FieldAdaptedStepHandler wrapped = new FieldAdaptedStepHandler(handler);
        this.integrator.addStepHandler((FieldODEStepHandler)wrapped);
        this.modeHandler = wrapped;
    }

    @Override
    public void setEphemerisMode() {
        FieldEphemerisModeHandler ephemeris;
        super.setEphemerisMode();
        this.integrator.clearStepHandlers();
        this.modeHandler = ephemeris = new FieldEphemerisModeHandler();
        this.integrator.addStepHandler((FieldODEStepHandler)ephemeris);
    }

    @Override
    public FieldBoundedPropagator<T> getGeneratedEphemeris() throws IllegalStateException {
        if (this.getMode() != 2) {
            throw new OrekitIllegalStateException(OrekitMessages.PROPAGATOR_NOT_IN_EPHEMERIS_GENERATION_MODE, new Object[0]);
        }
        return ((FieldEphemerisModeHandler)this.modeHandler).getEphemeris();
    }

    protected abstract FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> var1, double var2, OrbitType var4, PositionAngle var5, AttitudeProvider var6, Frame var7);

    protected abstract MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> var1);

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> target) throws OrekitException {
        try {
            if (this.getStartDate() == null) {
                if (this.getInitialState() == null) {
                    throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
                }
                this.setStartDate(this.getInitialState().getDate());
            }
            return this.propagate(this.getStartDate(), target);
        }
        catch (OrekitException oe) {
            for (Throwable t = oe; t != null; t = t.getCause()) {
                if (!(t instanceof OrekitException)) continue;
                throw t;
            }
            throw new OrekitException(oe);
        }
    }

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> tStart, FieldAbsoluteDate<T> tEnd) throws OrekitException {
        try {
            if (this.getInitialState() == null) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            if (!tStart.equals(this.getInitialState().getDate())) {
                this.propagate(tStart, false);
            }
            return this.propagate(tEnd, true);
        }
        catch (OrekitException oe) {
            for (Throwable t = oe; t != null; t = t.getCause()) {
                if (!(t instanceof OrekitException)) continue;
                throw t;
            }
            throw new OrekitException(oe);
        }
    }

    protected FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> tEnd, boolean activateHandlers) throws OrekitException {
        try {
            FieldODEStateAndDerivative mathFinalState;
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            FieldOrbit initialOrbit = this.stateMapper.getOrbitType().convertType(this.getInitialState().getOrbit());
            if (Double.isNaN(this.getMu())) {
                this.setMu(initialOrbit.getMu());
            }
            if (this.getInitialState().getMass().getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            this.integrator.clearEventHandlers();
            this.setUpUserEventDetectors();
            FieldODEState<T> mathInitialState = this.createInitialState(this.getInitialIntegrationState());
            FieldExpandableODE<T> mathODE = this.createODE(this.integrator, mathInitialState);
            this.equationsMapper = mathODE.getMapper();
            this.mathInterpolator = null;
            if (this.modeHandler != null) {
                this.modeHandler.initialize(activateHandlers, tEnd);
            }
            try {
                this.beforeIntegration(this.getInitialState(), tEnd);
                mathFinalState = this.integrator.integrate(mathODE, mathInitialState, tEnd.durationFrom(this.getInitialState().getDate()));
                this.afterIntegration();
            }
            catch (OrekitExceptionWrapper oew) {
                throw oew.getException();
            }
            FieldSpacecraftState finalState = this.stateMapper.mapArrayToState(this.stateMapper.mapDoubleToDate(mathFinalState.getTime(), tEnd), mathFinalState.getPrimaryState(), mathFinalState.getPrimaryDerivative(), this.meanOrbit);
            finalState = this.updateAdditionalStates(finalState);
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                RealFieldElement[] secondary = mathFinalState.getSecondaryState(i + 1);
                finalState = finalState.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
            }
            if (this.resetAtEnd) {
                this.resetInitialState(finalState);
                this.setStartDate(finalState.getDate());
            }
            return finalState;
        }
        catch (OrekitException pe) {
            throw pe;
        }
        catch (MathIllegalArgumentException miae) {
            throw OrekitException.unwrap((MathRuntimeException)((Object)miae));
        }
        catch (MathIllegalStateException mise) {
            throw OrekitException.unwrap((MathRuntimeException)((Object)mise));
        }
    }

    protected FieldSpacecraftState<T> getInitialIntegrationState() throws OrekitException {
        return this.getInitialState();
    }

    private FieldODEState<T> createInitialState(FieldSpacecraftState<T> initialState) throws OrekitException {
        RealFieldElement[] primary = (RealFieldElement[])MathArrays.buildArray((Field)initialState.getA().getField(), (int)this.getBasicDimension());
        this.stateMapper.mapStateToArray(initialState, primary, null);
        RealFieldElement[][] secondary = (RealFieldElement[][])MathArrays.buildArray((Field)initialState.getA().getField(), (int)this.additionalEquations.size(), (int)-1);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            FieldAdditionalEquations<T> additional = this.additionalEquations.get(i);
            RealFieldElement[] addState = this.getInitialState().getAdditionalState(additional.getName());
            secondary[i] = (RealFieldElement[])MathArrays.buildArray((Field)initialState.getA().getField(), (int)addState.length);
            for (int j = 0; j < addState.length; ++j) {
                secondary[i][j] = addState[j];
            }
        }
        return new FieldODEState((RealFieldElement)initialState.getA().getField().getZero(), primary, secondary);
    }

    private FieldExpandableODE<T> createODE(FieldODEIntegrator<T> integ, FieldODEState<T> mathInitialState) throws OrekitException {
        FieldExpandableODE ode = new FieldExpandableODE((FieldOrdinaryDifferentialEquation)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            FieldAdditionalEquations<T> additional = this.additionalEquations.get(i);
            ConvertedSecondaryStateEquations secondary = new ConvertedSecondaryStateEquations(additional, mathInitialState.getSecondaryStateDimension(i + 1));
            ode.addSecondaryEquations((FieldSecondaryODE)secondary);
        }
        return ode;
    }

    protected void beforeIntegration(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> tEnd) throws OrekitException {
    }

    protected void afterIntegration() throws OrekitException {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected FieldODEIntegrator<T> getIntegrator() {
        return this.integrator;
    }

    private FieldSpacecraftState<T> getCompleteState(T t, T[] ts, T[] tsDot) throws OrekitException {
        FieldSpacecraftState state = this.stateMapper.mapArrayToState((RealFieldElement)t, (RealFieldElement[])ts, (RealFieldElement[])tsDot, true);
        state = this.updateAdditionalStates(state);
        if (!this.additionalEquations.isEmpty()) {
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                state = state.addAdditionalState(this.additionalEquations.get(i).getName(), this.equationsMapper.extractEquationData(i + 1, ts));
            }
        }
        return state;
    }

    private class FieldEphemerisModeHandler
    implements FieldModeHandler<T>,
    FieldODEStepHandler<T> {
        private FieldDenseOutputModel<T> model;
        private FieldBoundedPropagator<T> ephemeris;
        private boolean activate;
        private FieldAbsoluteDate<T> endDate;

        FieldEphemerisModeHandler() {
        }

        @Override
        public void initialize(boolean activateHandlers, FieldAbsoluteDate<T> targetDate) {
            this.activate = activateHandlers;
            this.model = new FieldDenseOutputModel();
            this.endDate = targetDate;
            this.ephemeris = null;
        }

        public FieldBoundedPropagator<T> getEphemeris() {
            return this.ephemeris;
        }

        public void handleStep(FieldODEStateInterpolator<T> interpolator, boolean isLast) throws OrekitExceptionWrapper {
            try {
                if (this.activate) {
                    this.model.handleStep(interpolator, isLast);
                    if (isLast) {
                        FieldAbsoluteDate<RealFieldElement> maxDate;
                        FieldAbsoluteDate<RealFieldElement> minDate;
                        RealFieldElement tI = this.model.getInitialTime();
                        RealFieldElement tF = this.model.getFinalTime();
                        FieldAbsoluteDate<RealFieldElement> startDate = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
                        FieldAbsoluteDate<RealFieldElement> finalDate = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF, this.endDate);
                        if (tF.getReal() < tI.getReal()) {
                            minDate = finalDate;
                            maxDate = startDate;
                        } else {
                            minDate = startDate;
                            maxDate = finalDate;
                        }
                        HashMap<String, T[]> unmanaged = new HashMap<String, T[]>();
                        for (Map.Entry<String, T[]> initial : FieldAbstractIntegratedPropagator.this.getInitialState().getAdditionalStates().entrySet()) {
                            if (FieldAbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                            unmanaged.put(initial.getKey(), initial.getValue());
                        }
                        String[] names = new String[FieldAbstractIntegratedPropagator.this.additionalEquations.size()];
                        for (int i = 0; i < names.length; ++i) {
                            names[i] = ((FieldAdditionalEquations)FieldAbstractIntegratedPropagator.this.additionalEquations.get(i)).getName();
                        }
                        this.ephemeris = new FieldIntegratedEphemeris<RealFieldElement>(startDate, minDate, maxDate, FieldAbstractIntegratedPropagator.this.stateMapper, FieldAbstractIntegratedPropagator.this.meanOrbit, this.model, unmanaged, FieldAbstractIntegratedPropagator.this.getAdditionalStateProviders(), names);
                    }
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            this.model.init(s0, t);
        }
    }

    private class FieldAdaptedStepHandler
    implements FieldOrekitStepInterpolator<T>,
    FieldODEStepHandler<T>,
    FieldModeHandler<T> {
        private final FieldOrekitStepHandler<T> handler;
        private boolean activate;

        FieldAdaptedStepHandler(FieldOrekitStepHandler<T> handler) {
            this.handler = handler;
        }

        @Override
        public void initialize(boolean activateHandlers, FieldAbsoluteDate<T> targetDate) {
            this.activate = activateHandlers;
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            try {
                this.handler.init(FieldAbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public void handleStep(FieldODEStateInterpolator<T> interpolator, boolean isLast) {
            try {
                FieldAbstractIntegratedPropagator.this.mathInterpolator = interpolator;
                if (this.activate) {
                    this.handler.handleStep(this, isLast);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        @Override
        public FieldSpacecraftState<T> getPreviousState() throws OrekitException {
            return this.convert(FieldAbstractIntegratedPropagator.this.mathInterpolator.getPreviousState());
        }

        @Override
        public FieldSpacecraftState<T> getCurrentState() throws OrekitException {
            return this.convert(FieldAbstractIntegratedPropagator.this.mathInterpolator.getCurrentState());
        }

        @Override
        public FieldSpacecraftState<T> getInterpolatedState(FieldAbsoluteDate<T> date) throws OrekitException {
            return this.convert(FieldAbstractIntegratedPropagator.this.mathInterpolator.getInterpolatedState(date.durationFrom(FieldAbstractIntegratedPropagator.this.getStartDate())));
        }

        private FieldSpacecraftState<T> convert(FieldODEStateAndDerivative<T> os) throws OrekitException {
            try {
                FieldSpacecraftState s = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState(os.getTime(), os.getPrimaryState(), os.getPrimaryDerivative(), FieldAbstractIntegratedPropagator.this.meanOrbit);
                s = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(s);
                for (int i = 0; i < FieldAbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                    RealFieldElement[] secondary = os.getSecondaryState(i + 1);
                    s = s.addAdditionalState(((FieldAdditionalEquations)FieldAbstractIntegratedPropagator.this.additionalEquations.get(i)).getName(), secondary);
                }
                return s;
            }
            catch (OrekitException oe) {
                throw new OrekitException(oe);
            }
            catch (OrekitExceptionWrapper oew) {
                throw new OrekitException(oew.getException());
            }
        }

        @Override
        public boolean isForward() {
            return FieldAbstractIntegratedPropagator.this.mathInterpolator.isForward();
        }
    }

    private class FieldAdaptedEventDetector
    implements FieldODEEventHandler<T> {
        private final FieldEventDetector<T> detector;
        private T lastT;
        private T lastG;

        FieldAdaptedEventDetector(FieldEventDetector<T> detector) {
            this.detector = detector;
            this.lastT = (RealFieldElement)((RealFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
            this.lastG = (RealFieldElement)((RealFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
        }

        public void init(FieldODEStateAndDerivative<T> s0, T t) {
            try {
                this.detector.init(FieldAbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
                this.lastT = (RealFieldElement)((RealFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
                this.lastG = (RealFieldElement)((RealFieldElement)FieldAbstractIntegratedPropagator.this.getField().getZero()).add(Double.NaN);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public T g(FieldODEStateAndDerivative<T> s) {
            try {
                if (!Precision.equals((double)this.lastT.getReal(), (double)s.getTime().getReal(), (int)0)) {
                    this.lastT = s.getTime();
                    this.lastG = this.detector.g(FieldAbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()));
                }
                return this.lastG;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public Action eventOccurred(FieldODEStateAndDerivative<T> s, boolean increasing) {
            try {
                FieldEventHandler.Action whatNext = this.detector.eventOccurred(FieldAbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()), increasing);
                switch (whatNext) {
                    case STOP: {
                        return Action.STOP;
                    }
                    case RESET_STATE: {
                        return Action.RESET_STATE;
                    }
                    case RESET_DERIVATIVES: {
                        return Action.RESET_DERIVATIVES;
                    }
                }
                return Action.CONTINUE;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> s) {
            try {
                FieldSpacecraftState oldState = FieldAbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative());
                FieldSpacecraftState newState = this.detector.resetState(oldState);
                RealFieldElement[] primary = (RealFieldElement[])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)s.getPrimaryStateDimension());
                FieldAbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, primary, null);
                RealFieldElement[][] secondary = (RealFieldElement[][])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)FieldAbstractIntegratedPropagator.this.additionalEquations.size(), (int)-1);
                for (int i = 0; i < FieldAbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                    FieldAdditionalEquations additional = (FieldAdditionalEquations)FieldAbstractIntegratedPropagator.this.additionalEquations.get(i);
                    RealFieldElement[] NState = newState.getAdditionalState(additional.getName());
                    secondary[i] = (RealFieldElement[])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)NState.length);
                    for (int j = 0; j < NState.length; ++j) {
                        secondary[i][j] = NState[j];
                    }
                }
                return new FieldODEState(newState.getDate().durationFrom(FieldAbstractIntegratedPropagator.this.getStartDate()), primary, secondary);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedSecondaryStateEquations
    implements FieldSecondaryODE<T> {
        private final FieldAdditionalEquations<T> equations;
        private final int dimension;

        ConvertedSecondaryStateEquations(FieldAdditionalEquations<T> equations, int dimension) {
            this.equations = equations;
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void init(T t0, T[] primary0, T[] secondary0, T finalTime) {
            try {
                FieldSpacecraftState initialState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((RealFieldElement)t0, (RealFieldElement[])primary0, null, true);
                initialState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
                initialState = initialState.addAdditionalState(this.equations.getName(), (RealFieldElement[])secondary0);
                FieldAbsoluteDate target = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
                this.equations.init(initialState, target);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public T[] computeDerivatives(T t, T[] primary, T[] primaryDot, T[] secondary) throws OrekitExceptionWrapper {
            try {
                FieldSpacecraftState currentState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((RealFieldElement)t, (RealFieldElement[])primary, (RealFieldElement[])primaryDot, true);
                currentState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                currentState = currentState.addAdditionalState(this.equations.getName(), (RealFieldElement[])secondary);
                RealFieldElement[] secondaryDot = (RealFieldElement[])MathArrays.buildArray(FieldAbstractIntegratedPropagator.this.getField(), (int)secondary.length);
                RealFieldElement[] additionalMainDot = this.equations.computeDerivatives(currentState, secondaryDot);
                if (additionalMainDot != null) {
                    for (int i = 0; i < additionalMainDot.length; ++i) {
                        primaryDot[i] = (RealFieldElement)primaryDot[i].add((Object)additionalMainDot[i]);
                    }
                }
                return secondaryDot;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class ConvertedMainStateEquations
    implements FieldOrdinaryDifferentialEquation<T> {
        private final MainStateEquations<T> main;

        ConvertedMainStateEquations(MainStateEquations<T> main) {
            this.main = main;
            FieldAbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return FieldAbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void init(T t0, T[] y0, T finalTime) {
            try {
                FieldSpacecraftState initialState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((RealFieldElement)t0, (RealFieldElement[])y0, null, true);
                initialState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
                FieldAbsoluteDate target = FieldAbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
                this.main.init(initialState, target);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }

        public T[] computeDerivatives(T t, T[] y) throws OrekitExceptionWrapper {
            try {
                ++FieldAbstractIntegratedPropagator.this.calls;
                FieldSpacecraftState currentState = FieldAbstractIntegratedPropagator.this.stateMapper.mapArrayToState((RealFieldElement)t, (RealFieldElement[])y, null, true);
                currentState = FieldAbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
                return this.main.computeDerivatives(currentState);
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    public static interface MainStateEquations<T extends RealFieldElement<T>> {
        public void init(FieldSpacecraftState<T> var1, FieldAbsoluteDate<T> var2) throws OrekitException;

        public T[] computeDerivatives(FieldSpacecraftState<T> var1) throws OrekitException;
    }
}

