/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class LongitudeCrossingDetector
extends AbstractDetector<LongitudeCrossingDetector> {
    private static final long serialVersionUID = 20150824L;
    private OneAxisEllipsoid body;
    private final double longitude;
    private double sign;
    private double previousDelta;

    public LongitudeCrossingDetector(OneAxisEllipsoid body, double longitude) {
        this(600.0, 1.0E-6, body, longitude);
    }

    public LongitudeCrossingDetector(double maxCheck, double threshold, OneAxisEllipsoid body, double longitude) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), body, longitude);
    }

    private LongitudeCrossingDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super LongitudeCrossingDetector> handler, OneAxisEllipsoid body, double longitude) {
        super(maxCheck, threshold, maxIter, handler);
        this.body = body;
        this.longitude = longitude;
        this.sign = 1.0;
        this.previousDelta = Double.NaN;
    }

    @Override
    protected LongitudeCrossingDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super LongitudeCrossingDetector> newHandler) {
        return new LongitudeCrossingDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.body, this.longitude);
    }

    public OneAxisEllipsoid getBody() {
        return this.body;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        GeodeticPoint gp = this.body.transform(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
        double delta = MathUtils.normalizeAngle((double)(this.sign * (gp.getLongitude() - this.longitude)), (double)0.0);
        if (FastMath.abs((double)(delta - this.previousDelta)) > Math.PI) {
            this.sign = -this.sign;
            delta = MathUtils.normalizeAngle((double)(this.sign * (gp.getLongitude() - this.longitude)), (double)0.0);
        }
        this.previousDelta = delta;
        return delta;
    }
}

