/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;

public class FunctionalDetector
extends AbstractDetector<FunctionalDetector> {
    private static final long serialVersionUID = 20180525L;
    private final GFunction gFunction;

    public FunctionalDetector() {
        this(600.0, 1.0E-6, 100, new ContinueOnEvent(), a -> 1.0);
    }

    private FunctionalDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super FunctionalDetector> handler, GFunction gFunction) {
        super(maxCheck, threshold, maxIter, handler);
        this.gFunction = gFunction;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        return this.gFunction.apply(s);
    }

    @Override
    protected FunctionalDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super FunctionalDetector> newHandler) {
        return new FunctionalDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.gFunction);
    }

    public FunctionalDetector withGFunction(GFunction newGFunction) {
        return new FunctionalDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), newGFunction);
    }

    public GFunction getGFunction() {
        return this.gFunction;
    }

    @FunctionalInterface
    public static interface GFunction {
        public double apply(SpacecraftState var1) throws OrekitException;
    }
}

