/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.FieldOfView;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class FieldOfViewDetector
extends AbstractDetector<FieldOfViewDetector> {
    private static final long serialVersionUID = 20160114L;
    private final PVCoordinatesProvider targetPVProvider;
    private final FieldOfView fov;

    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, FieldOfView fov) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), pvTarget, fov);
    }

    private FieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super FieldOfViewDetector> handler, PVCoordinatesProvider pvTarget, FieldOfView fov) {
        super(maxCheck, threshold, maxIter, handler);
        this.targetPVProvider = pvTarget;
        this.fov = fov;
    }

    @Override
    protected FieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super FieldOfViewDetector> newHandler) {
        return new FieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.fov);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public FieldOfView getFieldOfView() {
        return this.fov;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Vector3D targetPosInert = this.targetPVProvider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        Vector3D lineOfSightSC = s.toTransform().transformPosition(targetPosInert);
        return this.fov.offsetFromBoundary(lineOfSightSC);
    }
}

