/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.Vertex;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.utils.SphericalPolygonsSetTransferObject;

public class FieldOfView
implements Serializable {
    private static final long serialVersionUID = 20150113L;
    private final transient SphericalPolygonsSet zone;
    private final double margin;
    private final transient EnclosingBall<Sphere2D, S2Point> cap;

    public FieldOfView(SphericalPolygonsSet zone, double margin) {
        this.zone = zone;
        this.margin = margin;
        this.cap = zone.getEnclosingCap();
    }

    public FieldOfView(Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2, double margin) throws OrekitException {
        RegionFactory factory = new RegionFactory();
        double tolerance = 1.0E-12 * FastMath.max((double)halfAperture1, (double)halfAperture2);
        Region<Sphere2D> dihedra1 = this.buildDihedra((RegionFactory<Sphere2D>)factory, tolerance, center, axis1, halfAperture1);
        Region<Sphere2D> dihedra2 = this.buildDihedra((RegionFactory<Sphere2D>)factory, tolerance, center, axis2, halfAperture2);
        this.zone = (SphericalPolygonsSet)factory.intersection(dihedra1, dihedra2);
        this.margin = margin;
        this.cap = this.zone.getEnclosingCap();
    }

    public FieldOfView(Vector3D center, Vector3D meridian, double insideRadius, int n, double margin) {
        Rotation r = new Rotation(center, Math.PI * 2 / (double)n, RotationConvention.VECTOR_OPERATOR);
        Vector3D orthogonal = Vector3D.crossProduct((Vector3D)Vector3D.crossProduct((Vector3D)center, (Vector3D)meridian), (Vector3D)center);
        Vector3D firstEdgeNormal = new Vector3D(FastMath.sin((double)insideRadius), center.normalize(), -FastMath.cos((double)insideRadius), orthogonal.normalize());
        Vector3D secondEdgeNormal = r.applyTo(firstEdgeNormal);
        Vector3D vertex = Vector3D.crossProduct((Vector3D)firstEdgeNormal, (Vector3D)secondEdgeNormal);
        double outsideRadius = Vector3D.angle((Vector3D)center, (Vector3D)vertex);
        this.zone = new SphericalPolygonsSet(center, vertex, outsideRadius, n, 1.0E-12 * insideRadius);
        this.margin = margin;
        S2Point[] support = new S2Point[n];
        support[0] = new S2Point(vertex);
        for (int i = 1; i < n; ++i) {
            support[i] = new S2Point(r.applyTo(support[i - 1].getVector()));
        }
        this.cap = new EnclosingBall((Point)new S2Point(center), outsideRadius, (Point[])support);
    }

    private Region<Sphere2D> buildDihedra(RegionFactory<Sphere2D> factory, double tolerance, Vector3D center, Vector3D axis, double halfAperture) throws OrekitException {
        if (halfAperture > 1.5707963267948966) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, halfAperture, 0.0, 1.5707963267948966);
        }
        Rotation r = new Rotation(axis, halfAperture, RotationConvention.VECTOR_OPERATOR);
        Vector3D normalCenterPlane = Vector3D.crossProduct((Vector3D)axis, (Vector3D)center);
        Vector3D normalSidePlus = r.applyInverseTo(normalCenterPlane);
        Vector3D normalSideMinus = r.applyTo(normalCenterPlane.negate());
        return factory.intersection((Region)new SphericalPolygonsSet(normalSidePlus, tolerance), (Region)new SphericalPolygonsSet(normalSideMinus, tolerance));
    }

    public SphericalPolygonsSet getZone() {
        return this.zone;
    }

    public double getMargin() {
        return this.margin;
    }

    public double offsetFromBoundary(Vector3D lineOfSight) {
        S2Point los = new S2Point(lineOfSight);
        double crudeDistance = ((S2Point)this.cap.getCenter()).distance((Point)los) - this.cap.getRadius();
        if (crudeDistance - this.margin > FastMath.max((double)FastMath.abs((double)this.margin), (double)0.01)) {
            return crudeDistance - this.margin;
        }
        return this.zone.projectToBoundary((Point)los).getOffset() - this.margin;
    }

    List<List<GeodeticPoint>> getFootprint(Transform fovToBody, OneAxisEllipsoid body, double angularStep) throws OrekitException {
        Vector3D bodyCenter;
        Frame bodyFrame = body.getBodyFrame();
        Vector3D position = fovToBody.transformPosition(Vector3D.ZERO);
        double r = position.getNorm();
        if (body.isInside(position)) {
            throw new OrekitException((Localizable)OrekitMessages.POINT_INSIDE_ELLIPSOID, new Object[0]);
        }
        ArrayList<List<GeodeticPoint>> footprint = new ArrayList<List<GeodeticPoint>>();
        List boundary = this.zone.getBoundaryLoops();
        for (Vertex loopStart : boundary) {
            int count = 0;
            ArrayList<GeodeticPoint> loop = new ArrayList<GeodeticPoint>();
            boolean intersectionsFound = false;
            Edge edge = loopStart.getOutgoing();
            while (count == 0 || edge.getStart() != loopStart) {
                ++count;
                int n = (int)FastMath.ceil((double)(edge.getLength() / angularStep));
                double delta = edge.getLength() / (double)n;
                for (int i = 0; i < n; ++i) {
                    Vector3D awaySC = new Vector3D(r, edge.getPointAt((double)i * delta));
                    Vector3D awayBody = fovToBody.transformPosition(awaySC);
                    Line lineOfSight = new Line(position, awayBody, 0.001);
                    GeodeticPoint gp = body.getIntersectionPoint(lineOfSight, position, bodyFrame, null);
                    if (gp != null && Vector3D.dotProduct((Vector3D)awayBody.subtract((Vector)position), (Vector3D)body.transform(gp).subtract((Vector)position)) < 0.0) {
                        gp = null;
                    }
                    if (gp != null) {
                        intersectionsFound = true;
                    } else {
                        gp = body.transform(body.pointOnLimb(position, awayBody), bodyFrame, null);
                    }
                    loop.add(0, gp);
                }
                edge = edge.getEnd().getOutgoing();
            }
            if (!intersectionsFound) continue;
            footprint.add(loop);
        }
        if (footprint.isEmpty() && this.zone.checkPoint((Point)new S2Point(bodyCenter = fovToBody.getInverse().transformPosition(Vector3D.ZERO))) != Region.Location.OUTSIDE) {
            Vector3D x = bodyCenter.orthogonal();
            Vector3D y = Vector3D.crossProduct((Vector3D)bodyCenter, (Vector3D)x).normalize();
            double sinEta = body.getEquatorialRadius() / r;
            double sinEta2 = sinEta * sinEta;
            double cosAlpha = (FastMath.cos((double)angularStep) + sinEta2 - 1.0) / sinEta2;
            int n = (int)FastMath.ceil((double)(Math.PI * 2 / FastMath.acos((double)cosAlpha)));
            double delta = Math.PI * 2 / (double)n;
            ArrayList<GeodeticPoint> loop = new ArrayList<GeodeticPoint>(n);
            for (int i = 0; i < n; ++i) {
                Vector3D outside = new Vector3D(r * FastMath.cos((double)((double)i * delta)), x, r * FastMath.sin((double)((double)i * delta)), y);
                loop.add(body.transform(body.pointOnLimb(position, outside), bodyFrame, null));
            }
            footprint.add(loop);
        }
        return footprint;
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20150113L;
        private final SphericalPolygonsSetTransferObject zone;
        private final double margin;

        private DTO(FieldOfView fov) {
            this.zone = new SphericalPolygonsSetTransferObject(fov.zone);
            this.margin = fov.margin;
        }

        private Object readResolve() {
            return new FieldOfView(this.zone.rebuildZone(), this.margin);
        }
    }
}

