/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import org.hipparchus.RealFieldElement;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnEvent;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;

public class FieldDateDetector<T extends RealFieldElement<T>>
extends FieldAbstractDetector<FieldDateDetector<T>, T>
implements FieldTimeStamped<T> {
    private FieldAbsoluteDate<T> gDate = null;
    private final ArrayList<FieldEventDate<T>> eventDateList;
    private int currentIndex = -1;

    @SafeVarargs
    public FieldDateDetector(T maxCheck, T threshold, FieldTimeStamped<T> ... dates) {
        this(maxCheck, threshold, 100, new FieldStopOnEvent(), dates);
    }

    public FieldDateDetector(FieldAbsoluteDate<T> target) {
        this((RealFieldElement)((RealFieldElement)target.getField().getZero()).add(1.0E10), (RealFieldElement)((RealFieldElement)target.getField().getZero()).add(1.0E-9), target);
    }

    @SafeVarargs
    private FieldDateDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldDateDetector<T>, T> handler, FieldTimeStamped<T> ... dates) {
        super(maxCheck, threshold, maxIter, handler);
        this.eventDateList = new ArrayList(dates.length);
        for (FieldTimeStamped<T> ts : dates) {
            this.addEventDate(ts.getDate());
        }
    }

    @Override
    protected FieldDateDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldDateDetector<T>, T> newHandler) {
        FieldTimeStamped[] dates = this.eventDateList.toArray(new FieldEventDate[this.eventDateList.size()]);
        return new FieldDateDetector<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, dates);
    }

    @Override
    public T g(FieldSpacecraftState<T> s) throws OrekitException {
        this.gDate = s.getDate();
        if (this.currentIndex < 0) {
            return (T)((RealFieldElement)((RealFieldElement)s.getA().getField().getZero()).add(-1.0));
        }
        FieldEventDate<T> event = this.getClosest(this.gDate);
        return event.isgIncrease() ? this.gDate.durationFrom(event.getDate()) : event.getDate().durationFrom(this.gDate);
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.currentIndex < 0 ? null : this.eventDateList.get(this.currentIndex).getDate();
    }

    public void addEventDate(FieldAbsoluteDate<T> target) throws IllegalArgumentException {
        if (this.currentIndex < 0) {
            boolean increasing = this.gDate == null ? true : target.durationFrom(this.gDate).getReal() > 0.0;
            this.currentIndex = 0;
            this.eventDateList.add(new FieldEventDate<T>(target, increasing));
        } else {
            int lastIndex = this.eventDateList.size() - 1;
            if (this.eventDateList.get(0).getDate().durationFrom(target).getReal() > this.getMaxCheckInterval().getReal()) {
                boolean increasing = !this.eventDateList.get(0).isgIncrease();
                this.eventDateList.add(0, new FieldEventDate<T>(target, increasing));
                ++this.currentIndex;
            } else if (target.durationFrom(this.eventDateList.get(lastIndex).getDate()).getReal() > this.getMaxCheckInterval().getReal()) {
                boolean increasing = !this.eventDateList.get(lastIndex).isgIncrease();
                this.eventDateList.add(new FieldEventDate<T>(target, increasing));
            } else {
                throw new OrekitIllegalArgumentException(OrekitMessages.EVENT_DATE_TOO_CLOSE, target, this.eventDateList.get(0).getDate(), this.eventDateList.get(lastIndex).getDate(), this.getMaxCheckInterval());
            }
        }
    }

    private FieldEventDate<T> getClosest(FieldAbsoluteDate<T> target) {
        block5: {
            T dt;
            block4: {
                dt = target.durationFrom(this.eventDateList.get(this.currentIndex).getDate());
                if (!(dt.getReal() < 0.0) || this.currentIndex <= 0) break block4;
                boolean found = false;
                while (this.currentIndex > 0 && !found) {
                    if (target.durationFrom(this.eventDateList.get(this.currentIndex - 1).getDate()).getReal() < this.eventDateList.get(this.currentIndex).getDate().durationFrom(target).getReal()) {
                        --this.currentIndex;
                        continue;
                    }
                    found = true;
                }
                break block5;
            }
            if (!(dt.getReal() > 0.0) || this.currentIndex >= this.eventDateList.size() - 1) break block5;
            int maxIndex = this.eventDateList.size() - 1;
            boolean found = false;
            while (this.currentIndex < maxIndex && !found) {
                if (target.durationFrom(this.eventDateList.get(this.currentIndex + 1).getDate()).getReal() > this.eventDateList.get(this.currentIndex).getDate().durationFrom(target).getReal()) {
                    ++this.currentIndex;
                    continue;
                }
                found = true;
            }
        }
        return this.eventDateList.get(this.currentIndex);
    }

    private static class FieldEventDate<T extends RealFieldElement<T>>
    implements FieldTimeStamped<T> {
        private final FieldAbsoluteDate<T> eventDate;
        private final boolean gIncrease;

        FieldEventDate(FieldAbsoluteDate<T> date, boolean increase) {
            this.eventDate = date;
            this.gIncrease = increase;
        }

        @Override
        public FieldAbsoluteDate<T> getDate() {
            return this.eventDate;
        }

        public boolean isgIncrease() {
            return this.gIncrease;
        }
    }
}

