/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ElevationExtremumDetector
extends AbstractDetector<ElevationExtremumDetector> {
    private static final long serialVersionUID = 20150909L;
    private final TopocentricFrame topo;

    public ElevationExtremumDetector(TopocentricFrame topo) {
        this(600.0, 1.0E-6, topo);
    }

    public ElevationExtremumDetector(double maxCheck, double threshold, TopocentricFrame topo) {
        this(maxCheck, threshold, 100, new StopOnIncreasing(), topo);
    }

    private ElevationExtremumDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super ElevationExtremumDetector> handler, TopocentricFrame topo) {
        super(maxCheck, threshold, maxIter, handler);
        this.topo = topo;
    }

    @Override
    protected ElevationExtremumDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super ElevationExtremumDetector> newHandler) {
        return new ElevationExtremumDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.topo);
    }

    public TopocentricFrame getTopocentricFrame() {
        return this.topo;
    }

    public double getElevation(SpacecraftState s) throws OrekitException {
        return this.topo.getElevation(s.getPVCoordinates().getPosition(), s.getFrame(), s.getDate());
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Transform inertToTopo = s.getFrame().getTransformTo((Frame)this.topo, s.getDate());
        TimeStampedPVCoordinates pvTopo = inertToTopo.transformPVCoordinates(s.getPVCoordinates());
        FieldVector3D<DerivativeStructure> pvDS = pvTopo.toDerivativeStructureVector(1);
        DerivativeStructure elevation = ((DerivativeStructure)pvDS.getZ()).divide((DerivativeStructure)pvDS.getNorm()).asin();
        return elevation.getPartialDerivative(new int[]{1});
    }
}

