/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnDecreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class CircularFieldOfViewDetector
extends AbstractDetector<CircularFieldOfViewDetector> {
    private static final long serialVersionUID = 20131118L;
    private final PVCoordinatesProvider targetPVProvider;
    private final Vector3D center;
    private final double halfAperture;

    public CircularFieldOfViewDetector(double maxCheck, PVCoordinatesProvider pvTarget, Vector3D center, double halfAperture) {
        this(maxCheck, 0.001, 100, new StopOnDecreasing(), pvTarget, center, halfAperture);
    }

    private CircularFieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super CircularFieldOfViewDetector> handler, PVCoordinatesProvider pvTarget, Vector3D center, double halfAperture) {
        super(maxCheck, threshold, maxIter, handler);
        this.targetPVProvider = pvTarget;
        this.center = center;
        this.halfAperture = halfAperture;
    }

    @Override
    protected CircularFieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super CircularFieldOfViewDetector> newHandler) {
        return new CircularFieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.center, this.halfAperture);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public Vector3D getCenter() {
        return this.center;
    }

    public double getHalfAperture() {
        return this.halfAperture;
    }

    @Override
    public double g(SpacecraftState s) throws OrekitException {
        Vector3D targetPosInert = new Vector3D(1.0, this.targetPVProvider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), -1.0, s.getPVCoordinates().getPosition());
        Vector3D targetPosSat = s.getAttitude().getRotation().applyTo(targetPosInert);
        return this.halfAperture - Vector3D.angle((Vector3D)targetPosSat, (Vector3D)this.center);
    }
}

