/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.nonstiff.AdamsBashforthIntegrator;
import org.orekit.errors.OrekitException;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public class AdamsBashforthIntegratorBuilder
implements ODEIntegratorBuilder {
    private final int nSteps;
    private final double minStep;
    private final double maxStep;
    private final double dP;

    public AdamsBashforthIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP) {
        this.nSteps = nSteps;
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit, OrbitType orbitType) throws OrekitException {
        double[][] tol = NumericalPropagator.tolerances(this.dP, orbit, orbitType);
        return new AdamsBashforthIntegrator(this.nSteps, this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

