/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.interpolation.SplineInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.data.BodiesElements;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.models.earth.displacement.OceanLoadingCoefficients;
import org.orekit.models.earth.displacement.StationDisplacement;
import org.orekit.models.earth.displacement.Tide;

public class OceanLoading
implements StationDisplacement {
    private static final double[] CARTWRIGHT_EDDEN_AMPLITUDE = new double[]{0.632208, 0.294107, 0.121046, 0.079915, 0.023818, -0.023589, 0.022994, 0.019333, -0.017871, 0.017192, 0.016018, 0.004671, -0.004662, -0.004519, 0.00447, 0.004467, 0.002589, -0.002455, -0.002172, 0.001972, 0.001947, 0.001914, -0.001898, 0.001802, 0.001304, 0.00117, 0.00113, 0.001061, -0.001022, -0.001017, 0.001014, 9.01E-4, -8.57E-4, 8.55E-4, 8.55E-4, 7.72E-4, 7.41E-4, 7.41E-4, -7.21E-4, 6.98E-4, 6.58E-4, 6.54E-4, -6.53E-4, 6.33E-4, 6.26E-4, -5.98E-4, 5.9E-4, 5.44E-4, 4.79E-4, -4.64E-4, 4.13E-4, -3.9E-4, 3.73E-4, 3.66E-4, 3.66E-4, -3.6E-4, -3.55E-4, 3.54E-4, 3.29E-4, 3.28E-4, 3.19E-4, 3.02E-4, 2.79E-4, -2.74E-4, -2.72E-4, 2.48E-4, -2.25E-4, 2.24E-4, -2.23E-4, -2.16E-4, 2.11E-4, 2.09E-4, 1.94E-4, 1.85E-4, -1.74E-4, -1.71E-4, 1.59E-4, 1.31E-4, 1.27E-4, 1.2E-4, 1.18E-4, 1.17E-4, 1.08E-4, 1.07E-4, 1.05E-4, -1.02E-4, 1.02E-4, 9.9E-5, -9.6E-5, 9.5E-5, -8.9E-5, -8.5E-5, -8.4E-5, -8.1E-5, -7.7E-5, -7.2E-5, -6.7E-5, 6.6E-5, 6.4E-5, 6.3E-5, 6.3E-5, 6.3E-5, 6.2E-5, 6.2E-5, -6.0E-5, 5.6E-5, 5.3E-5, 5.1E-5, 5.0E-5, 0.368645, -0.262232, -0.121995, -0.050208, 0.050031, -0.04947, 0.02062, 0.020613, 0.011279, -0.00953, -0.009469, -0.008012, 0.007414, -0.0073, 0.007227, -0.007131, -0.006644, 0.005249, 0.004137, 0.004087, 0.003944, 0.003943, 0.00342, 0.003418, 0.002885, 0.002884, 0.00216, -0.001936, 0.001934, -0.001798, 0.00169, 0.001689, 0.001516, 0.001514, -0.001511, 0.001383, 0.001372, 0.001371, -0.001253, -0.001075, 0.00102, 9.01E-4, 8.65E-4, -7.94E-4, 7.88E-4, 7.82E-4, -7.47E-4, -7.45E-4, 6.7E-4, -6.03E-4, -5.97E-4, 5.42E-4, 5.42E-4, -5.41E-4, -4.69E-4, -4.4E-4, 4.38E-4, 4.22E-4, 4.1E-4, -3.74E-4, -3.65E-4, 3.45E-4, 3.35E-4, -3.21E-4, -3.19E-4, 3.07E-4, 2.91E-4, 2.9E-4, -2.89E-4, 2.86E-4, 2.75E-4, 2.71E-4, 2.63E-4, -2.45E-4, 2.25E-4, 2.25E-4, 2.21E-4, -2.02E-4, -2.0E-4, -1.99E-4, 1.92E-4, 1.83E-4, 1.83E-4, 1.83E-4, -1.7E-4, 1.69E-4, 1.68E-4, 1.62E-4, 1.49E-4, -1.47E-4, -1.41E-4, 1.38E-4, 1.36E-4, 1.36E-4, 1.27E-4, 1.27E-4, -1.26E-4, -1.21E-4, -1.21E-4, 1.17E-4, -1.16E-4, -1.14E-4, -1.14E-4, -1.14E-4, 1.14E-4, 1.13E-4, 1.09E-4, 1.08E-4, 1.06E-4, -1.06E-4, -1.06E-4, 1.05E-4, 1.04E-4, -1.03E-4, -1.0E-4, -1.0E-4, -1.0E-4, 9.9E-5, -9.8E-5, 9.3E-5, 9.3E-5, 9.0E-5, -8.8E-5, 8.3E-5, -8.3E-5, -8.2E-5, -8.1E-5, -7.9E-5, -7.7E-5, -7.5E-5, -7.5E-5, -7.5E-5, 7.1E-5, 7.1E-5, -7.1E-5, 6.8E-5, 6.8E-5, 6.5E-5, 6.5E-5, 6.4E-5, 6.4E-5, 6.4E-5, -6.4E-5, -6.0E-5, 5.6E-5, 5.6E-5, 5.3E-5, 5.3E-5, 5.3E-5, -5.3E-5, 5.3E-5, 5.3E-5, 5.2E-5, 5.0E-5, -0.066607, -0.035184, -0.030988, 0.027929, -0.027616, -0.012753, -0.006728, -0.005837, -0.005286, -0.004921, -0.002884, -0.002583, -0.002422, 0.00231, 0.002283, -0.002037, 0.001883, -0.001811, -0.001687, -0.001004, -9.25E-4, -8.44E-4, 7.66E-4, 7.66E-4, -7.0E-4, -4.95E-4, -4.92E-4, 4.91E-4, 4.83E-4, 4.37E-4, -4.16E-4, -3.84E-4, 3.74E-4, -3.12E-4, -2.88E-4, -2.73E-4, 2.59E-4, 2.45E-4, -2.32E-4, 2.29E-4, -2.16E-4, 2.06E-4, -2.04E-4, -2.02E-4, 2.0E-4, 1.95E-4, -1.9E-4, 1.87E-4, 1.8E-4, -1.79E-4, 1.7E-4, 1.53E-4, -1.37E-4, -1.19E-4, -1.19E-4, -1.12E-4, -1.1E-4, -1.1E-4, 1.07E-4, -9.5E-5, -9.5E-5, -9.1E-5, -9.0E-5, -8.1E-5, -7.9E-5, -7.9E-5, 7.7E-5, -7.3E-5, 6.9E-5, -6.7E-5, -6.6E-5, 6.5E-5, 6.4E-5, -6.2E-5, 6.0E-5, 5.9E-5, -5.6E-5, 5.5E-5, -5.1E-5};
    private static final int[][] DOODSON_ARGUMENTS = new int[][]{{2, 0, 0, 0, 0, 0}, {2, 2, -2, 0, 0, 0}, {2, -1, 0, 1, 0, 0}, {2, 2, 0, 0, 0, 0}, {2, 2, 0, 0, 1, 0}, {2, 0, 0, 0, -1, 0}, {2, -1, 2, -1, 0, 0}, {2, -2, 2, 0, 0, 0}, {2, 1, 0, -1, 0, 0}, {2, 2, -3, 0, 0, 1}, {2, -2, 0, 2, 0, 0}, {2, -3, 2, 1, 0, 0}, {2, 1, -2, 1, 0, 0}, {2, -1, 0, 1, -1, 0}, {2, 3, 0, -1, 0, 0}, {2, 1, 0, 1, 0, 0}, {2, 2, 0, 0, 2, 0}, {2, 2, -1, 0, 0, -1}, {2, 0, -1, 0, 0, 1}, {2, 1, 0, 1, 1, 0}, {2, 3, 0, -1, 1, 0}, {2, 0, 1, 0, 0, -1}, {2, 0, -2, 2, 0, 0}, {2, -3, 0, 3, 0, 0}, {2, -2, 3, 0, 0, -1}, {2, 4, 0, 0, 0, 0}, {2, -1, 1, 1, 0, -1}, {2, -1, 3, -1, 0, -1}, {2, 2, 0, 0, -1, 0}, {2, -1, -1, 1, 0, 1}, {2, 4, 0, 0, 1, 0}, {2, -3, 4, -1, 0, 0}, {2, -1, 2, -1, -1, 0}, {2, 3, -2, 1, 0, 0}, {2, 1, 2, -1, 0, 0}, {2, -4, 2, 2, 0, 0}, {2, 4, -2, 0, 0, 0}, {2, 0, 2, 0, 0, 0}, {2, -2, 2, 0, -1, 0}, {2, 2, -4, 0, 0, 2}, {2, 2, -2, 0, -1, 0}, {2, 1, 0, -1, -1, 0}, {2, -1, 1, 0, 0, 0}, {2, 2, -1, 0, 0, 1}, {2, 2, 1, 0, 0, -1}, {2, -2, 0, 2, -1, 0}, {2, -2, 4, -2, 0, 0}, {2, 2, 2, 0, 0, 0}, {2, -4, 4, 0, 0, 0}, {2, -1, 0, -1, -2, 0}, {2, 1, 2, -1, 1, 0}, {2, -1, -2, 3, 0, 0}, {2, 3, -2, 1, 1, 0}, {2, 4, 0, -2, 0, 0}, {2, 0, 0, 2, 0, 0}, {2, 0, 2, -2, 0, 0}, {2, 0, 2, 0, 1, 0}, {2, -3, 3, 1, 0, -1}, {2, 0, 0, 0, -2, 0}, {2, 4, 0, 0, 2, 0}, {2, 4, -2, 0, 1, 0}, {2, 0, 0, 0, 0, 2}, {2, 1, 0, 1, 2, 0}, {2, 0, -2, 0, -2, 0}, {2, -2, 1, 0, 0, 1}, {2, -2, 1, 2, 0, -1}, {2, -1, 1, -1, 0, 1}, {2, 5, 0, -1, 0, 0}, {2, 1, -3, 1, 0, 1}, {2, -2, -1, 2, 0, 1}, {2, 3, 0, -1, 2, 0}, {2, 1, -2, 1, -1, 0}, {2, 5, 0, -1, 1, 0}, {2, -4, 0, 4, 0, 0}, {2, -3, 2, 1, -1, 0}, {2, -2, 1, 1, 0, 0}, {2, 4, 0, -2, 1, 0}, {2, 0, 0, 2, 1, 0}, {2, -5, 4, 1, 0, 0}, {2, 0, 2, 0, 2, 0}, {2, -1, 2, 1, 0, 0}, {2, 5, -2, -1, 0, 0}, {2, 1, -1, 0, 0, 0}, {2, 2, -2, 0, 0, 2}, {2, -5, 2, 3, 0, 0}, {2, -1, -2, 1, -2, 0}, {2, -3, 5, -1, 0, -1}, {2, -1, 0, 0, 0, 1}, {2, -2, 0, 0, -2, 0}, {2, 0, -1, 1, 0, 0}, {2, -3, 1, 1, 0, 1}, {2, 3, 0, -1, -1, 0}, {2, 1, 0, 1, -1, 0}, {2, -1, 2, 1, 1, 0}, {2, 0, -3, 2, 0, 1}, {2, 1, -1, -1, 0, 1}, {2, -3, 0, 3, -1, 0}, {2, 0, -2, 2, -1, 0}, {2, -4, 3, 2, 0, -1}, {2, -1, 0, 1, -2, 0}, {2, 5, 0, -1, 2, 0}, {2, -4, 5, 0, 0, -1}, {2, -2, 4, 0, 0, -2}, {2, -1, 0, 1, 0, 2}, {2, -2, -2, 4, 0, 0}, {2, 3, -2, -1, -1, 0}, {2, -2, 5, -2, 0, -1}, {2, 0, -1, 0, -1, 1}, {2, 5, -2, -1, 1, 0}, {1, 1, 0, 0, 0, 0}, {1, -1, 0, 0, 0, 0}, {1, 1, -2, 0, 0, 0}, {1, -2, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, -1, 0, 0, -1, 0}, {1, 2, 0, -1, 0, 0}, {1, 0, 0, 1, 0, 0}, {1, 3, 0, 0, 0, 0}, {1, -2, 2, -1, 0, 0}, {1, -2, 0, 1, -1, 0}, {1, -3, 2, 0, 0, 0}, {1, 0, 0, -1, 0, 0}, {1, 1, 0, 0, -1, 0}, {1, 3, 0, 0, 1, 0}, {1, 1, -3, 0, 0, 1}, {1, -3, 0, 2, 0, 0}, {1, 1, 2, 0, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 2, 0, -1, 1, 0}, {1, 0, 2, -1, 0, 0}, {1, 2, -2, 1, 0, 0}, {1, 3, -2, 0, 0, 0}, {1, -1, 2, 0, 0, 0}, {1, 1, 1, 0, 0, -1}, {1, 1, -1, 0, 0, 1}, {1, 4, 0, -1, 0, 0}, {1, -4, 2, 1, 0, 0}, {1, 0, -2, 1, 0, 0}, {1, -2, 2, -1, -1, 0}, {1, 3, 0, -2, 0, 0}, {1, -1, 0, 2, 0, 0}, {1, -1, 0, 0, -2, 0}, {1, 3, 0, 0, 2, 0}, {1, -3, 2, 0, -1, 0}, {1, 4, 0, -1, 1, 0}, {1, 0, 0, -1, -1, 0}, {1, 1, -2, 0, -1, 0}, {1, -3, 0, 2, -1, 0}, {1, 1, 0, 0, 2, 0}, {1, 1, -1, 0, 0, -1}, {1, -1, -1, 0, 0, 1}, {1, 0, 2, -1, 1, 0}, {1, -1, 1, 0, 0, -1}, {1, -1, -2, 2, 0, 0}, {1, 2, -2, 1, 1, 0}, {1, -4, 0, 3, 0, 0}, {1, -1, 2, 0, 1, 0}, {1, 3, -2, 0, 1, 0}, {1, 2, 0, -1, -1, 0}, {1, 0, 0, 1, -1, 0}, {1, -2, 2, 1, 0, 0}, {1, 4, -2, -1, 0, 0}, {1, -3, 3, 0, 0, -1}, {1, -2, 1, 1, 0, -1}, {1, -2, 3, -1, 0, -1}, {1, 0, -2, 1, -1, 0}, {1, -2, -1, 1, 0, 1}, {1, 4, -2, 1, 0, 0}, {1, -4, 4, -1, 0, 0}, {1, -4, 2, 1, -1, 0}, {1, 5, -2, 0, 0, 0}, {1, 3, 0, -2, 1, 0}, {1, -5, 2, 2, 0, 0}, {1, 2, 0, 1, 0, 0}, {1, 1, 3, 0, 0, -1}, {1, -2, 0, 1, -2, 0}, {1, 4, 0, -1, 2, 0}, {1, 1, -4, 0, 0, 2}, {1, 5, 0, -2, 0, 0}, {1, -1, 0, 2, 1, 0}, {1, -2, 1, 0, 0, 0}, {1, 4, -2, 1, 1, 0}, {1, -3, 4, -2, 0, 0}, {1, -1, 3, 0, 0, -1}, {1, 3, -3, 0, 0, 1}, {1, 5, -2, 0, 1, 0}, {1, 1, 2, 0, 1, 0}, {1, 2, 0, 1, 1, 0}, {1, -5, 4, 0, 0, 0}, {1, -2, 0, -1, -2, 0}, {1, 5, 0, -2, 1, 0}, {1, 1, 2, -2, 0, 0}, {1, 1, -2, 2, 0, 0}, {1, -2, 2, 1, 1, 0}, {1, 0, 3, -1, 0, -1}, {1, 2, -3, 1, 0, 1}, {1, -2, -2, 3, 0, 0}, {1, -1, 2, -2, 0, 0}, {1, -4, 3, 1, 0, -1}, {1, -4, 0, 3, -1, 0}, {1, -1, -2, 2, -1, 0}, {1, -2, 0, 3, 0, 0}, {1, 4, 0, -3, 0, 0}, {1, 0, 1, 1, 0, -1}, {1, 2, -1, -1, 0, 1}, {1, 2, -2, 1, -1, 0}, {1, 0, 0, -1, -2, 0}, {1, 2, 0, 1, 2, 0}, {1, 2, -2, -1, -1, 0}, {1, 0, 0, 1, 2, 0}, {1, 0, 1, 0, 0, 0}, {1, 2, -1, 0, 0, 0}, {1, 0, 2, -1, -1, 0}, {1, -1, -2, 0, -2, 0}, {1, -3, 1, 0, 0, 1}, {1, 3, -2, 0, -1, 0}, {1, -1, -1, 0, -1, 1}, {1, 4, -2, -1, 1, 0}, {1, 2, 1, -1, 0, -1}, {1, 0, -1, 1, 0, 1}, {1, -2, 4, -1, 0, 0}, {1, 4, -4, 1, 0, 0}, {1, -3, 1, 2, 0, -1}, {1, -3, 3, 0, -1, -1}, {1, 1, 2, 0, 2, 0}, {1, 1, -2, 0, -2, 0}, {1, 3, 0, 0, 3, 0}, {1, -1, 2, 0, -1, 0}, {1, -2, 1, -1, 0, 1}, {1, 0, -3, 1, 0, 1}, {1, -3, -1, 2, 0, 1}, {1, 2, 0, -1, 2, 0}, {1, 6, -2, -1, 0, 0}, {1, 2, 2, -1, 0, 0}, {1, -1, 1, 0, -1, -1}, {1, -2, 3, -1, -1, -1}, {1, -1, 0, 0, 0, 2}, {1, -5, 0, 4, 0, 0}, {1, 1, 0, 0, 0, -2}, {1, -2, 1, 1, -1, -1}, {1, 1, -1, 0, 1, 1}, {1, 1, 2, 0, 0, -2}, {1, -3, 1, 1, 0, 0}, {1, -4, 4, -1, -1, 0}, {1, 1, 0, -2, -1, 0}, {1, -2, -1, 1, -1, 1}, {1, -3, 2, 2, 0, 0}, {1, 5, -2, -2, 0, 0}, {1, 3, -4, 2, 0, 0}, {1, 1, -2, 0, 0, 2}, {1, -1, 4, -2, 0, 0}, {1, 2, 2, -1, 1, 0}, {1, -5, 2, 2, -1, 0}, {1, 1, -3, 0, -1, 1}, {1, 1, 1, 0, 1, -1}, {1, 6, -2, -1, 1, 0}, {1, -2, 2, -1, -2, 0}, {1, 4, -2, 1, 2, 0}, {1, -6, 4, 1, 0, 0}, {1, 5, -4, 0, 0, 0}, {1, -3, 4, 0, 0, 0}, {1, 1, 2, -2, 1, 0}, {1, -2, 1, 0, -1, 0}, {0, 2, 0, 0, 0, 0}, {0, 1, 0, -1, 0, 0}, {0, 0, 2, 0, 0, 0}, {0, 0, 0, 0, 1, 0}, {0, 2, 0, 0, 1, 0}, {0, 3, 0, -1, 0, 0}, {0, 1, -2, 1, 0, 0}, {0, 2, -2, 0, 0, 0}, {0, 3, 0, -1, 1, 0}, {0, 0, 1, 0, 0, -1}, {0, 2, 0, -2, 0, 0}, {0, 2, 0, 0, 2, 0}, {0, 3, -2, 1, 0, 0}, {0, 1, 0, -1, -1, 0}, {0, 1, 0, -1, 1, 0}, {0, 4, -2, 0, 0, 0}, {0, 1, 0, 1, 0, 0}, {0, 0, 3, 0, 0, -1}, {0, 4, 0, -2, 0, 0}, {0, 3, -2, 1, 1, 0}, {0, 3, -2, -1, 0, 0}, {0, 4, -2, 0, 1, 0}, {0, 0, 2, 0, 1, 0}, {0, 1, 0, 1, 1, 0}, {0, 4, 0, -2, 1, 0}, {0, 3, 0, -1, 2, 0}, {0, 5, -2, -1, 0, 0}, {0, 1, 2, -1, 0, 0}, {0, 1, -2, 1, -1, 0}, {0, 1, -2, 1, 1, 0}, {0, 2, -2, 0, -1, 0}, {0, 2, -3, 0, 0, 1}, {0, 2, -2, 0, 1, 0}, {0, 0, 2, -2, 0, 0}, {0, 1, -3, 1, 0, 1}, {0, 0, 0, 0, 2, 0}, {0, 0, 1, 0, 0, 1}, {0, 1, 2, -1, 1, 0}, {0, 3, 0, -3, 0, 0}, {0, 2, 1, 0, 0, -1}, {0, 1, -1, -1, 0, 1}, {0, 1, 0, 1, 2, 0}, {0, 5, -2, -1, 1, 0}, {0, 2, -1, 0, 0, 1}, {0, 2, 2, -2, 0, 0}, {0, 1, -1, 0, 0, 0}, {0, 5, 0, -3, 0, 0}, {0, 2, 0, -2, 1, 0}, {0, 1, 1, -1, 0, -1}, {0, 3, -4, 1, 0, 0}, {0, 0, 2, 0, 2, 0}, {0, 2, 0, -2, -1, 0}, {0, 4, -3, 0, 0, 1}, {0, 3, -1, -1, 0, 1}, {0, 0, 2, 0, 0, -2}, {0, 3, -3, 1, 0, 1}, {0, 2, -4, 2, 0, 0}, {0, 4, -2, -2, 0, 0}, {0, 3, 1, -1, 0, -1}, {0, 5, -4, 1, 0, 0}, {0, 3, -2, -1, -1, 0}, {0, 3, -2, 1, 2, 0}, {0, 4, -4, 0, 0, 0}, {0, 6, -2, -2, 0, 0}, {0, 5, 0, -3, 1, 0}, {0, 4, -2, 0, 2, 0}, {0, 2, 2, -2, 1, 0}, {0, 0, 4, 0, 0, -2}, {0, 3, -1, 0, 0, 0}, {0, 3, -3, -1, 0, 1}, {0, 4, 0, -2, 2, 0}, {0, 1, -2, -1, -1, 0}, {0, 2, -1, 0, 0, -1}, {0, 4, -4, 2, 0, 0}, {0, 2, 1, 0, 1, -1}, {0, 3, -2, -1, 1, 0}, {0, 4, -3, 0, 1, 1}, {0, 2, 0, 0, 3, 0}, {0, 6, -4, 0, 0, 0}};
    private static final Map<Tide, Double> CARTWRIGHT_EDDEN_AMPLITUDE_MAP = new HashMap<Tide, Double>(CARTWRIGHT_EDDEN_AMPLITUDE.length);
    private final OneAxisEllipsoid earth;
    private final MainTideData[][] mainTides;

    public OceanLoading(OneAxisEllipsoid earth, OceanLoadingCoefficients coefficients) {
        this.earth = earth;
        this.mainTides = new MainTideData[coefficients.getNbSpecies()][];
        for (int i = 0; i < this.mainTides.length; ++i) {
            this.mainTides[i] = new MainTideData[coefficients.getNbTides(i)];
            for (int j = 0; j < this.mainTides[i].length; ++j) {
                double amplitude = CARTWRIGHT_EDDEN_AMPLITUDE_MAP.get(coefficients.getTide(i, j));
                this.mainTides[i][j] = new MainTideData(coefficients, i, j, FastMath.abs((double)amplitude));
            }
        }
    }

    @Override
    public Vector3D displacement(BodiesElements elements, Frame earthFrame, Vector3D referencePoint) throws OrekitException {
        UnivariateFunction[] realZSpline = new UnivariateFunction[this.mainTides.length];
        UnivariateFunction[] imaginaryZSpline = new UnivariateFunction[this.mainTides.length];
        UnivariateFunction[] realWSpline = new UnivariateFunction[this.mainTides.length];
        UnivariateFunction[] imaginaryWSpline = new UnivariateFunction[this.mainTides.length];
        UnivariateFunction[] realSSpline = new UnivariateFunction[this.mainTides.length];
        UnivariateFunction[] imaginarySSpline = new UnivariateFunction[this.mainTides.length];
        for (int i = 0; i < this.mainTides.length; ++i) {
            double[] rates = new double[this.mainTides[i].length];
            for (int j = 0; j < rates.length; ++j) {
                rates[j] = this.mainTides[i][j].tide.getRate(elements);
            }
            realZSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).realZ);
            imaginaryZSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).imaginaryZ);
            realWSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).realW);
            imaginaryWSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).imaginaryW);
            realSSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).realS);
            imaginarySSpline[i] = this.spline(rates, this.mainTides[i], d -> ((MainTideData)d).imaginaryS);
        }
        double dz = 0.0;
        double dw = 0.0;
        double ds = 0.0;
        for (Map.Entry<Tide, Double> entry : CARTWRIGHT_EDDEN_AMPLITUDE_MAP.entrySet()) {
            Tide tide = entry.getKey();
            double amplitude = entry.getValue();
            int i = tide.getTauMultiplier();
            double rate = tide.getRate(elements);
            double rZ = realZSpline[i].value(rate);
            double iZ = imaginaryZSpline[i].value(rate);
            double rW = realWSpline[i].value(rate);
            double iW = imaginaryWSpline[i].value(rate);
            double rS = realSSpline[i].value(rate);
            double iS = imaginarySSpline[i].value(rate);
            double correction = tide.getTauMultiplier() == 0 ? Math.PI : (tide.getTauMultiplier() == 1 ? 1.5707963267948966 : 0.0);
            double phase = tide.getPhase(elements) + correction;
            dz += amplitude * FastMath.hypot((double)rZ, (double)iZ) * FastMath.cos((double)(phase + FastMath.atan2((double)iZ, (double)rZ)));
            dw += amplitude * FastMath.hypot((double)rW, (double)iW) * FastMath.cos((double)(phase + FastMath.atan2((double)iW, (double)rW)));
            ds += amplitude * FastMath.hypot((double)rS, (double)iS) * FastMath.cos((double)(phase + FastMath.atan2((double)iS, (double)rS)));
        }
        GeodeticPoint gp = this.earth.transform(referencePoint, earthFrame, elements.getDate());
        return new Vector3D(dz, gp.getZenith(), dw, gp.getWest(), ds, gp.getSouth());
    }

    private UnivariateFunction spline(double[] rates, MainTideData[] data, Function<MainTideData, Double> selector) {
        double[] y = new double[data.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = selector.apply(data[i]);
        }
        PolynomialSplineFunction psf = new SplineInterpolator().interpolate(rates, y);
        double[] knots = psf.getKnots();
        double minRate = knots[0];
        double valueAtMinRate = psf.value(minRate);
        double maxRate = knots[knots.length - 1];
        double valueAtMaxRate = psf.value(maxRate);
        return t -> t < minRate ? valueAtMinRate : (t > maxRate ? valueAtMaxRate : psf.value(t));
    }

    static {
        for (int i = 0; i < CARTWRIGHT_EDDEN_AMPLITUDE.length; ++i) {
            CARTWRIGHT_EDDEN_AMPLITUDE_MAP.put(new Tide(DOODSON_ARGUMENTS[i][0], DOODSON_ARGUMENTS[i][1], DOODSON_ARGUMENTS[i][2], DOODSON_ARGUMENTS[i][3], DOODSON_ARGUMENTS[i][4], DOODSON_ARGUMENTS[i][5]), CARTWRIGHT_EDDEN_AMPLITUDE[i]);
        }
    }

    private static class MainTideData {
        private final Tide tide;
        private final double realZ;
        private final double imaginaryZ;
        private final double realW;
        private final double imaginaryW;
        private final double realS;
        private final double imaginaryS;

        MainTideData(OceanLoadingCoefficients coefficients, int i, int j, double absAmplitude) {
            this.tide = coefficients.getTide(i, j);
            this.realZ = coefficients.getZenithAmplitude(i, j) * FastMath.cos((double)coefficients.getZenithPhase(i, j)) / absAmplitude;
            this.imaginaryZ = coefficients.getZenithAmplitude(i, j) * FastMath.sin((double)coefficients.getZenithPhase(i, j)) / absAmplitude;
            this.realW = coefficients.getWestAmplitude(i, j) * FastMath.cos((double)coefficients.getWestPhase(i, j)) / absAmplitude;
            this.imaginaryW = coefficients.getWestAmplitude(i, j) * FastMath.sin((double)coefficients.getWestPhase(i, j)) / absAmplitude;
            this.realS = coefficients.getSouthAmplitude(i, j) * FastMath.cos((double)coefficients.getSouthPhase(i, j)) / absAmplitude;
            this.imaginaryS = coefficients.getSouthAmplitude(i, j) * FastMath.sin((double)coefficients.getSouthPhase(i, j)) / absAmplitude;
        }
    }
}

