/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class GPSBlockIIR
extends AbstractGNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private static final double YAW_RATE = FastMath.toRadians((double)0.2);
    private final double END_MARGIN = 1800.0;

    public GPSBlockIIR(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double aNoon = FastMath.atan((double)(context.getMuRate() / YAW_RATE));
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = -cNoon;
        if (context.setUpTurnRegion(cNight, cNoon)) {
            double absBeta = FastMath.abs((double)context.getBeta());
            context.setHalfSpan(absBeta * FastMath.sqrt((double)(aNoon / absBeta - 1.0)));
            if (context.inTurnTimeRange(context.getDate(), 1800.0)) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart(context.getDate());
                if (context.inSunSide()) {
                    phiDot = -FastMath.copySign((double)YAW_RATE, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                } else {
                    phiDot = FastMath.copySign((double)YAW_RATE, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                    double phiEnd = context.getYawEnd(beta);
                    if (phiEnd / linearPhi < 0.0 || phiEnd / linearPhi > 1.0) {
                        return context.getNominalYaw();
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        RealFieldElement aNoon = FastMath.atan((RealFieldElement)((RealFieldElement)context.getMuRate().divide(YAW_RATE)));
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = -cNoon;
        if (context.setUpTurnRegion(cNight, cNoon)) {
            RealFieldElement absBeta = FastMath.abs(context.getBeta());
            context.setHalfSpan((RealFieldElement)absBeta.multiply((Object)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)aNoon.divide((Object)absBeta)).subtract(1.0)))));
            if (context.inTurnTimeRange(context.getDate(), 1800.0)) {
                RealFieldElement linearPhi;
                RealFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((RealFieldElement)beta);
                T dtStart = context.timeSinceTurnStart(context.getDate());
                if (context.inSunSide()) {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(-FastMath.copySign((double)YAW_RATE, (double)beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                } else {
                    phiDot = (RealFieldElement)((RealFieldElement)field.getZero()).add(FastMath.copySign((double)YAW_RATE, (double)beta.getReal()));
                    linearPhi = (RealFieldElement)phiStart.add(phiDot.multiply(dtStart));
                    T phiEnd = context.getYawEnd((RealFieldElement)beta);
                    if (phiEnd.getReal() / linearPhi.getReal() < 0.0 || phiEnd.getReal() / linearPhi.getReal() > 1.0) {
                        return context.getNominalYaw();
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.getNominalYaw();
    }
}

