/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.LOFType;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

class GNSSFieldAttitudeContext<T extends RealFieldElement<T>>
implements FieldTimeStamped<T> {
    private static final PVCoordinates PLUS_Y = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private static final int ORDER = 2;
    private final FieldPVCoordinates<T> plusY;
    private final FieldPVCoordinates<T> minusZ;
    private final TimeStampedFieldPVCoordinates<T> svPV;
    private final FieldPVCoordinates<FieldDerivativeStructure<T>> svPVDS;
    private final FieldDerivativeStructure<T> beta;
    private final FieldDerivativeStructure<T> svbCos;
    private final TimeStampedFieldAngularCoordinates<T> nominalYaw;
    private final FieldRotation<FieldDerivativeStructure<T>> nominalYawDS;
    private T muRate;
    private double cNight;
    private double cNoon;
    private FieldDerivativeStructure<T> delta;
    private T halfSpan;
    private FieldAbsoluteDate<T> turnStart;
    private FieldAbsoluteDate<T> turnEnd;

    GNSSFieldAttitudeContext(TimeStampedFieldPVCoordinates<T> sunPV, TimeStampedFieldPVCoordinates<T> svPV) throws OrekitException {
        Field<T> field = sunPV.getDate().getField();
        this.plusY = new FieldPVCoordinates<Field<T>>(field, PLUS_Y);
        this.minusZ = new FieldPVCoordinates<Field<T>>(field, MINUS_Z);
        FieldPVCoordinates sunPVDS = sunPV.toDerivativeStructurePV(2);
        this.svPV = svPV;
        this.svPVDS = svPV.toDerivativeStructurePV(2);
        this.svbCos = ((FieldDerivativeStructure)FieldVector3D.dotProduct(sunPVDS.getPosition(), this.svPVDS.getPosition())).divide(((FieldDerivativeStructure)sunPVDS.getPosition().getNorm()).multiply((FieldDerivativeStructure)this.svPVDS.getPosition().getNorm()));
        this.beta = ((FieldDerivativeStructure)FieldVector3D.angle(sunPVDS.getPosition(), this.svPVDS.getMomentum())).negate().add(1.5707963267948966);
        this.nominalYaw = new TimeStampedFieldAngularCoordinates<T>(svPV.getDate(), svPV.normalize(), sunPV.crossProduct(svPV).normalize(), this.minusZ, this.plusY, 1.0E-9);
        this.nominalYawDS = this.nominalYaw.toDerivativeStructureRotation(2);
        this.muRate = svPV.getAngularVelocity().getNorm();
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.svPV.getDate();
    }

    public T getSVBcos() {
        return (T)this.svbCos.getValue();
    }

    public T getBeta() {
        return (T)this.beta.getValue();
    }

    public FieldDerivativeStructure<T> getBetaDS() {
        return this.beta;
    }

    public T getSecuredBeta() {
        return (T)(FastMath.abs((double)this.beta.getReal()) < BETA_SIGN_CHANGE_PROTECTION ? this.beta.taylor(new RealFieldElement[]{(RealFieldElement)this.timeSinceTurnStart(this.getDate()).negate()}) : this.getBeta());
    }

    public TimeStampedFieldAngularCoordinates<T> getNominalYaw() {
        return this.nominalYaw;
    }

    public T yawAngle() {
        FieldVector3D xSat = this.nominalYaw.getRotation().revert().applyTo(Vector3D.PLUS_I);
        return (T)FastMath.copySign((RealFieldElement)FieldVector3D.angle(this.svPV.getVelocity(), (FieldVector3D)xSat), (double)(-this.beta.getReal()));
    }

    public FieldDerivativeStructure<T> yawAngleDS() {
        FieldVector3D xSat = this.nominalYawDS.revert().applyTo(Vector3D.PLUS_I);
        FDSFactory factory = ((FieldDerivativeStructure)xSat.getX()).getFactory();
        FieldVector3D v = this.svPV.getVelocity();
        FieldVector3D vDS = new FieldVector3D((RealFieldElement)factory.constant(v.getX()), (RealFieldElement)factory.constant(v.getY()), (RealFieldElement)factory.constant(v.getZ()));
        return ((FieldDerivativeStructure)FieldVector3D.angle((FieldVector3D)vDS, (FieldVector3D)xSat)).copySign((RealFieldElement)this.beta.getValue().negate());
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos.getValue().getReal() < this.cNight) {
            FieldDerivativeStructure absDelta = this.inOrbitPlaneAbsoluteAngle((T)this.svbCos.acos().negate().add(Math.PI));
            this.delta = absDelta.copySign((RealFieldElement)absDelta.getPartialDerivative(new int[]{1}).negate());
            return true;
        }
        if (this.svbCos.getValue().getReal() > this.cNoon) {
            FieldDerivativeStructure absDelta = this.inOrbitPlaneAbsoluteAngle((T)this.svbCos.acos());
            this.delta = absDelta.copySign((RealFieldElement)absDelta.getPartialDerivative(new int[]{1}).negate());
            return true;
        }
        return false;
    }

    public T getDelta() {
        return (T)this.delta.getValue();
    }

    public FieldDerivativeStructure<T> getDeltaDS() {
        return this.delta;
    }

    public boolean inSunSide() {
        return this.svbCos.getValue().getReal() > 0.0;
    }

    public T getYawStart(T sunBeta) {
        return (T)this.computePhi(sunBeta, FastMath.copySign(this.halfSpan, (RealFieldElement)this.svbCos.getValue()));
    }

    public T getYawEnd(T sunBeta) {
        return (T)this.computePhi(sunBeta, FastMath.copySign(this.halfSpan, (RealFieldElement)((RealFieldElement)this.svbCos.getValue().negate())));
    }

    public T yawRate(T sunBeta) {
        return (T)((RealFieldElement)((RealFieldElement)this.getYawEnd(sunBeta).subtract(this.getYawStart(sunBeta))).divide(this.getTurnDuration()));
    }

    public T getMuRate() {
        return this.muRate;
    }

    private FieldDerivativeStructure<T> inOrbitPlaneAbsoluteAngle(FieldDerivativeStructure<T> angle) {
        return (FieldDerivativeStructure)FastMath.acos((RealFieldElement)((FieldDerivativeStructure)FastMath.cos(angle)).divide((FieldDerivativeStructure)FastMath.cos(this.beta)));
    }

    public T inOrbitPlaneAbsoluteAngle(T angle) {
        return (T)FastMath.acos((RealFieldElement)((RealFieldElement)FastMath.cos(angle).divide(FastMath.cos((double)this.beta.getReal()))));
    }

    public T computePhi(T sunBeta, T inOrbitPlaneAngle) {
        return (T)FastMath.atan2((RealFieldElement)((RealFieldElement)FastMath.tan(sunBeta).negate()), (RealFieldElement)FastMath.sin(inOrbitPlaneAngle));
    }

    public void setHalfSpan(T halfSpan) {
        this.halfSpan = halfSpan;
        this.turnStart = this.svPV.getDate().shiftedBy((RealFieldElement)((RealFieldElement)this.delta.getValue().subtract(halfSpan)).divide(this.muRate));
        this.turnEnd = this.svPV.getDate().shiftedBy((RealFieldElement)((RealFieldElement)this.delta.getValue().add(halfSpan)).divide(this.muRate));
    }

    public boolean inTurnTimeRange(FieldAbsoluteDate<T> date, double endMargin) {
        return date.durationFrom(this.turnStart).getReal() > 0.0 && date.durationFrom(this.turnEnd).getReal() < endMargin;
    }

    public T getTurnDuration() {
        return (T)((RealFieldElement)((RealFieldElement)this.halfSpan.multiply(2)).divide(this.muRate));
    }

    public T timeSinceTurnStart(FieldAbsoluteDate<T> date) {
        return date.durationFrom(this.turnStart);
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(T yaw, T yawDot) {
        return this.turnCorrectedAttitude(this.beta.getFactory().build(new RealFieldElement[]{yaw, yawDot, (RealFieldElement)yaw.getField().getZero()}));
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(FieldDerivativeStructure<T> yaw) {
        FieldDerivativeStructure<T> nominalAngle = this.yawAngleDS();
        TimeStampedFieldAngularCoordinates<T> correction = new TimeStampedFieldAngularCoordinates<T>(this.nominalYaw.getDate(), new FieldRotation(FieldVector3D.getPlusK((Field)nominalAngle.getField()), (RealFieldElement)yaw.subtract(nominalAngle), RotationConvention.VECTOR_OPERATOR));
        return correction.addOffset((FieldAngularCoordinates)this.getNominalYaw());
    }

    public TimeStampedFieldAngularCoordinates<T> orbitNormalYaw() {
        FieldTransform<T> t = LOFType.VVLH.transformFromInertial(this.svPV.getDate(), this.svPV);
        return new TimeStampedFieldAngularCoordinates<T>(this.svPV.getDate(), t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

