/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class BeidouMeo
extends AbstractGNSSAttitudeProvider {
    private static final long serialVersionUID = 20171114L;
    private static final double BETA_0 = FastMath.toRadians((double)2.0);

    public BeidouMeo(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) throws OrekitException {
        if (FastMath.abs((double)context.getBeta()) < 2.0 * BETA_0) {
            return context.orbitNormalYaw();
        }
        return context.getNominalYaw();
    }

    @Override
    protected <T extends RealFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) throws OrekitException {
        if (FastMath.abs(context.getBeta()).getReal() < 2.0 * BETA_0) {
            return context.orbitNormalYaw();
        }
        return context.getNominalYaw();
    }
}

