/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.OrekitParseException;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.PulsatingSphericalHarmonics;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SecularTrendSphericalHarmonics;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.DateComponents;

public class ICGEMFormatReader
extends PotentialCoefficientsReader {
    private static final String PRODUCT_TYPE = "product_type";
    private static final String GRAVITY_FIELD = "gravity_field";
    private static final String GRAVITY_CONSTANT = "gravity_constant";
    private static final String REFERENCE_RADIUS = "radius";
    private static final String MAX_DEGREE = "max_degree";
    private static final String TIDE_SYSTEM_INDICATOR = "tide_system";
    private static final String ZERO_TIDE = "zero_tide";
    private static final String TIDE_FREE = "tide_free";
    private static final String TIDE_UNKNOWN = "unknown";
    private static final String NORMALIZATION_INDICATOR = "norm";
    private static final String NORMALIZED = "fully_normalized";
    private static final String UNNORMALIZED = "unnormalized";
    private static final String END_OF_HEADER = "end_of_head";
    private static final String GFC = "gfc";
    private static final String GFCT = "gfct";
    private static final String DOT = "dot";
    private static final String TRND = "trnd";
    private static final String ASIN = "asin";
    private static final String ACOS = "acos";
    private TideSystem tideSystem;
    private boolean normalized;
    private DateComponents referenceDate = null;
    private final List<List<Double>> cTrend = new ArrayList<List<Double>>();
    private final List<List<Double>> sTrend = new ArrayList<List<Double>>();
    private final Map<Double, List<List<Double>>> cCos = new HashMap<Double, List<List<Double>>>();
    private final Map<Double, List<List<Double>>> cSin = new HashMap<Double, List<List<Double>>>();
    private final Map<Double, List<List<Double>>> sCos = new HashMap<Double, List<List<Double>>>();
    private final Map<Double, List<List<Double>>> sSin = new HashMap<Double, List<List<Double>>>();

    public ICGEMFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        super(supportedNames, missingCoefficientsAllowed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        this.referenceDate = null;
        this.cTrend.clear();
        this.sTrend.clear();
        this.cCos.clear();
        this.cSin.clear();
        this.sCos.clear();
        this.sSin.clear();
        this.normalized = true;
        this.tideSystem = TideSystem.UNKNOWN;
        BufferedReader r = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        boolean inHeader = true;
        double[][] c = null;
        double[][] s = null;
        boolean okCoeffs = false;
        int lineNumber = 0;
        String line = r.readLine();
        while (line != null) {
            try {
                ++lineNumber;
                if (line.trim().length() != 0) {
                    int j;
                    int i;
                    String[] tab = line.split("\\s+");
                    if (inHeader) {
                        if (tab.length == 2 && PRODUCT_TYPE.equals(tab[0])) {
                            if (!GRAVITY_FIELD.equals(tab[1])) {
                                throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                            }
                        } else if (tab.length == 2 && tab[0].endsWith(GRAVITY_CONSTANT)) {
                            this.setMu(ICGEMFormatReader.parseDouble(tab[1]));
                        } else if (tab.length == 2 && REFERENCE_RADIUS.equals(tab[0])) {
                            this.setAe(ICGEMFormatReader.parseDouble(tab[1]));
                        } else if (tab.length == 2 && MAX_DEGREE.equals(tab[0])) {
                            int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(tab[1]));
                            int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                            c = ICGEMFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                            s = ICGEMFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                        } else if (tab.length == 2 && TIDE_SYSTEM_INDICATOR.equals(tab[0])) {
                            if (ZERO_TIDE.equals(tab[1])) {
                                this.tideSystem = TideSystem.ZERO_TIDE;
                            } else if (TIDE_FREE.equals(tab[1])) {
                                this.tideSystem = TideSystem.TIDE_FREE;
                            } else {
                                if (!TIDE_UNKNOWN.equals(tab[1])) throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                this.tideSystem = TideSystem.UNKNOWN;
                            }
                        } else if (tab.length == 2 && NORMALIZATION_INDICATOR.equals(tab[0])) {
                            if (NORMALIZED.equals(tab[1])) {
                                this.normalized = true;
                            } else {
                                if (!UNNORMALIZED.equals(tab[1])) throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                                this.normalized = false;
                            }
                        } else if (tab.length == 2 && END_OF_HEADER.equals(tab[0])) {
                            inHeader = false;
                        }
                    } else if (tab.length == 7 && GFC.equals(tab[0]) || tab.length == 8 && GFCT.equals(tab[0])) {
                        i = Integer.parseInt(tab[1]);
                        j = Integer.parseInt(tab[2]);
                        if (i < c.length && j < c[i].length) {
                            this.parseCoefficient(tab[3], c, i, j, "C", name);
                            this.parseCoefficient(tab[4], s, i, j, "S", name);
                            okCoeffs = true;
                            if (tab.length == 8) {
                                DateComponents localRef = new DateComponents(Integer.parseInt(tab[7].substring(0, 4)), Integer.parseInt(tab[7].substring(4, 6)), Integer.parseInt(tab[7].substring(6, 8)));
                                if (this.referenceDate == null) {
                                    this.referenceDate = localRef;
                                } else if (!this.referenceDate.equals(localRef)) {
                                    throw new OrekitException((Localizable)OrekitMessages.SEVERAL_REFERENCE_DATES_IN_GRAVITY_FIELD, this.referenceDate, localRef, name);
                                }
                            }
                        }
                    } else if (tab.length == 7 && (DOT.equals(tab[0]) || TRND.equals(tab[0]))) {
                        i = Integer.parseInt(tab[1]);
                        j = Integer.parseInt(tab[2]);
                        if (i < c.length && j < c[i].length) {
                            this.extendListOfLists(this.cTrend, i, j, 0.0);
                            this.extendListOfLists(this.sTrend, i, j, 0.0);
                            this.parseCoefficient(tab[3], this.cTrend, i, j, "Ctrend", name);
                            this.parseCoefficient(tab[4], this.sTrend, i, j, "Strend", name);
                        }
                    } else {
                        if (tab.length != 8 || !ASIN.equals(tab[0]) && !ACOS.equals(tab[0])) throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        i = Integer.parseInt(tab[1]);
                        j = Integer.parseInt(tab[2]);
                        if (i < c.length && j < c[i].length) {
                            Double period = Double.valueOf(tab[7]);
                            if (!this.cCos.containsKey(period)) {
                                this.cCos.put(period, new ArrayList());
                                this.cSin.put(period, new ArrayList());
                                this.sCos.put(period, new ArrayList());
                                this.sSin.put(period, new ArrayList());
                            }
                            List<List<Double>> cCosPeriod = this.cCos.get(period);
                            List<List<Double>> cSinPeriod = this.cSin.get(period);
                            List<List<Double>> sCosPeriod = this.sCos.get(period);
                            List<List<Double>> sSinPeriod = this.sSin.get(period);
                            this.extendListOfLists(cCosPeriod, i, j, 0.0);
                            this.extendListOfLists(cSinPeriod, i, j, 0.0);
                            this.extendListOfLists(sCosPeriod, i, j, 0.0);
                            this.extendListOfLists(sSinPeriod, i, j, 0.0);
                            if (ACOS.equals(tab[0])) {
                                this.parseCoefficient(tab[3], cCosPeriod, i, j, "Ccos", name);
                                this.parseCoefficient(tab[4], sCosPeriod, i, j, "SCos", name);
                            } else {
                                this.parseCoefficient(tab[3], cSinPeriod, i, j, "Csin", name);
                                this.parseCoefficient(tab[4], sSinPeriod, i, j, "Ssin", name);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                OrekitParseException pe = new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                pe.initCause(nfe);
                throw pe;
            }
            line = r.readLine();
        }
        if (this.missingCoefficientsAllowed() && c.length > 0 && c[0].length > 0 && Precision.equals((double)c[0][0], (double)0.0, (int)0)) {
            c[0][0] = 1.0;
        }
        if (Double.isNaN(this.getAe()) || Double.isNaN(this.getMu()) || !okCoeffs) {
            String loaderName = this.getClass().getName();
            loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1);
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_FILE_FORMAT_ERROR_FOR_LOADER, name, loaderName);
        }
        this.setRawCoefficients(this.normalized, c, s, name);
        this.setTideSystem(this.tideSystem);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) throws OrekitException {
        RawSphericalHarmonicsProvider provider = this.getConstantProvider(wantNormalized, degree, order);
        if (this.cTrend.isEmpty() && this.cCos.isEmpty()) {
            return provider;
        }
        if (!this.cTrend.isEmpty()) {
            double[][] cArrayTrend = this.toArray(this.cTrend);
            double[][] sArrayTrend = this.toArray(this.sTrend);
            ICGEMFormatReader.rescale(3.168808781402895E-8, this.normalized, cArrayTrend, sArrayTrend, wantNormalized, cArrayTrend, sArrayTrend);
            provider = new SecularTrendSphericalHarmonics(provider, this.referenceDate, cArrayTrend, sArrayTrend);
        }
        for (Map.Entry<Double, List<List<Double>>> entry : this.cCos.entrySet()) {
            double period = entry.getKey();
            double[][] cArrayCos = this.toArray(this.cCos.get(period));
            double[][] sArrayCos = this.toArray(this.sCos.get(period));
            double[][] cArraySin = this.toArray(this.cSin.get(period));
            double[][] sArraySin = this.toArray(this.sSin.get(period));
            ICGEMFormatReader.rescale(1.0, this.normalized, cArrayCos, sArrayCos, wantNormalized, cArrayCos, sArrayCos);
            ICGEMFormatReader.rescale(1.0, this.normalized, cArraySin, sArraySin, wantNormalized, cArraySin, sArraySin);
            provider = new PulsatingSphericalHarmonics(provider, period * 3.15576E7, cArrayCos, cArraySin, sArrayCos, sArraySin);
        }
        return provider;
    }
}

