/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.filtering.kalman.Measurement;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.time.AbsoluteDate;

class MeasurementDecorator
implements Measurement {
    private final ObservedMeasurement<?> observedMeasurement;
    private final RealMatrix covariance;
    private final AbsoluteDate reference;

    MeasurementDecorator(ObservedMeasurement<?> observedMeasurement, RealMatrix covariance, AbsoluteDate reference) {
        this.observedMeasurement = observedMeasurement;
        this.covariance = covariance;
        this.reference = reference;
    }

    public ObservedMeasurement<?> getObservedMeasurement() {
        return this.observedMeasurement;
    }

    public double getTime() {
        return this.observedMeasurement.getDate().durationFrom(this.reference);
    }

    public RealVector getValue() {
        return MatrixUtils.createRealVector((double[])this.observedMeasurement.getObservedValue());
    }

    public RealMatrix getCovariance() {
        return this.covariance;
    }
}

