/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TurnAroundRange
extends AbstractMeasurement<TurnAroundRange> {
    private final GroundStation masterStation;
    private final GroundStation slaveStation;

    public TurnAroundRange(GroundStation masterStation, GroundStation slaveStation, AbsoluteDate date, double turnAroundRange, double sigma, double baseWeight) throws OrekitException {
        this(masterStation, slaveStation, date, turnAroundRange, sigma, baseWeight, 0);
    }

    public TurnAroundRange(GroundStation masterStation, GroundStation slaveStation, AbsoluteDate date, double turnAroundRange, double sigma, double baseWeight, int propagatorIndex) throws OrekitException {
        super(date, turnAroundRange, sigma, baseWeight, Arrays.asList(propagatorIndex), masterStation.getEastOffsetDriver(), masterStation.getNorthOffsetDriver(), masterStation.getZenithOffsetDriver(), masterStation.getPrimeMeridianOffsetDriver(), masterStation.getPrimeMeridianDriftDriver(), masterStation.getPolarOffsetXDriver(), masterStation.getPolarDriftXDriver(), masterStation.getPolarOffsetYDriver(), masterStation.getPolarDriftYDriver(), slaveStation.getEastOffsetDriver(), slaveStation.getNorthOffsetDriver(), slaveStation.getZenithOffsetDriver(), slaveStation.getPrimeMeridianOffsetDriver(), slaveStation.getPrimeMeridianDriftDriver(), slaveStation.getPolarOffsetXDriver(), slaveStation.getPolarDriftXDriver(), slaveStation.getPolarOffsetYDriver(), slaveStation.getPolarDriftYDriver());
        this.masterStation = masterStation;
        this.slaveStation = slaveStation;
    }

    public GroundStation getMasterStation() {
        return this.masterStation;
    }

    public GroundStation getSlaveStation() {
        return this.slaveStation;
    }

    @Override
    protected EstimatedMeasurement<TurnAroundRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        SpacecraftState state = states[this.getPropagatorsIndices().get(0)];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || indices.containsKey(driver.getName())) continue;
            indices.put(driver.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field field = factory.getDerivativeField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = TurnAroundRange.getCoordinates(state, 0, factory);
        AbsoluteDate measurementDate = this.getDate();
        FieldAbsoluteDate<DerivativeStructure> measurementDateDS = new FieldAbsoluteDate<DerivativeStructure>(field, measurementDate);
        double delta = measurementDate.durationFrom(state.getDate());
        FieldTransform<DerivativeStructure> masterToInert = this.masterStation.getOffsetToInertial(state.getFrame(), measurementDateDS, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> masterArrival = masterToInert.transformPVCoordinates(new TimeStampedPVCoordinates(measurementDate, PVCoordinates.ZERO));
        DerivativeStructure masterTauD = TurnAroundRange.signalTimeOfFlight(pvaDS, masterArrival.getPosition(), measurementDateDS);
        DerivativeStructure dtLeg2 = masterTauD.negate().add(delta);
        SpacecraftState transitStateLeg2 = state.shiftedBy(dtLeg2.getValue());
        FieldPVCoordinates transitStateLeg2PV = pvaDS.shiftedBy((RealFieldElement)dtLeg2);
        TimeShiftable approxReboundDate = measurementDateDS.shiftedBy(-delta);
        FieldTransform<DerivativeStructure> slaveToInertApprox = this.slaveStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<DerivativeStructure>)approxReboundDate, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> QSlaveApprox = slaveToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxReboundDate, zero, zero, zero));
        DerivativeStructure slaveTauU = TurnAroundRange.signalTimeOfFlight(QSlaveApprox, transitStateLeg2PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg2PV).getDate());
        DerivativeStructure tauLeg2 = masterTauD.add(slaveTauU);
        FieldAbsoluteDate<DerivativeStructure> reboundDateDS = measurementDateDS.shiftedBy(tauLeg2.negate());
        FieldTransform<DerivativeStructure> slaveToInert = this.slaveStation.getOffsetToInertial(state.getFrame(), reboundDateDS, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> slaveRebound = slaveToInert.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(reboundDateDS, FieldPVCoordinates.getZero(field)));
        DerivativeStructure slaveTauD = TurnAroundRange.signalTimeOfFlight(transitStateLeg2PV, slaveRebound.getPosition(), reboundDateDS);
        DerivativeStructure dtLeg1 = dtLeg2.subtract(slaveTauU).subtract(slaveTauD);
        FieldPVCoordinates transitStateLeg1PV = pvaDS.shiftedBy((RealFieldElement)dtLeg1);
        TimeShiftable approxEmissionDate = measurementDateDS.shiftedBy(-2.0 * (slaveTauU.getValue() + masterTauD.getValue()));
        FieldTransform<DerivativeStructure> masterToInertApprox = this.masterStation.getOffsetToInertial(state.getFrame(), (FieldAbsoluteDate<DerivativeStructure>)approxEmissionDate, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> QMasterApprox = masterToInertApprox.transformPVCoordinates(new TimeStampedFieldPVCoordinates(approxEmissionDate, zero, zero, zero));
        DerivativeStructure masterTauU = TurnAroundRange.signalTimeOfFlight(QMasterApprox, transitStateLeg1PV.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate());
        AbsoluteDate emissionDate = ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).getDate().toAbsoluteDate().shiftedBy(-masterTauU.getValue());
        TimeStampedPVCoordinates masterDeparture = ((FieldTransform)masterToInertApprox.shiftedBy(emissionDate.durationFrom(masterToInertApprox.getDate()))).transformPVCoordinates(new TimeStampedPVCoordinates(emissionDate, PVCoordinates.ZERO)).toTimeStampedPVCoordinates();
        DerivativeStructure tauLeg1 = slaveTauD.add(masterTauU);
        EstimatedMeasurement<TurnAroundRange> estimated = new EstimatedMeasurement<TurnAroundRange>(this, iteration, evaluation, new SpacecraftState[]{transitStateLeg2.shiftedBy(-slaveTauU.getValue())}, new TimeStampedPVCoordinates[]{masterDeparture, ((TimeStampedFieldPVCoordinates)transitStateLeg1PV).toTimeStampedPVCoordinates(), slaveRebound.toTimeStampedPVCoordinates(), transitStateLeg2.getPVCoordinates(), masterArrival.toTimeStampedPVCoordinates()});
        double cOver2 = 1.49896229E8;
        DerivativeStructure turnAroundRange = tauLeg2.add(tauLeg1).multiply(1.49896229E8);
        estimated.setEstimatedValue(turnAroundRange.getValue());
        double[] derivatives = turnAroundRange.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = (Integer)indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index + 1]);
        }
        return estimated;
    }
}

