/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.FieldTransform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class RangeRate
extends AbstractMeasurement<RangeRate> {
    private final GroundStation station;
    private final boolean twoway;

    public RangeRate(GroundStation station, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, boolean twoway) throws OrekitException {
        this(station, date, rangeRate, sigma, baseWeight, twoway, 0);
    }

    public RangeRate(GroundStation station, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, boolean twoway, int propagatorIndex) throws OrekitException {
        super(date, rangeRate, sigma, baseWeight, Arrays.asList(propagatorIndex), station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver(), station.getPrimeMeridianOffsetDriver(), station.getPrimeMeridianDriftDriver(), station.getPolarOffsetXDriver(), station.getPolarDriftXDriver(), station.getPolarOffsetYDriver(), station.getPolarDriftYDriver());
        this.station = station;
        this.twoway = twoway;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    public GroundStation getStation() {
        return this.station;
    }

    @Override
    protected EstimatedMeasurement<RangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        EstimatedMeasurement<RangeRate> estimated;
        SpacecraftState state = states[this.getPropagatorsIndices().get(0)];
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver2 : this.getParametersDrivers()) {
            if (!driver2.isSelected()) continue;
            indices.put(driver2.getName(), nbParams++);
        }
        DSFactory factory = new DSFactory(nbParams, 1);
        Field field = factory.getDerivativeField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        TimeStampedFieldPVCoordinates<DerivativeStructure> pvaDS = RangeRate.getCoordinates(state, 0, factory);
        AbsoluteDate downlinkDate = this.getDate();
        FieldAbsoluteDate<DerivativeStructure> downlinkDateDS = new FieldAbsoluteDate<DerivativeStructure>(field, downlinkDate);
        FieldTransform<DerivativeStructure> offsetToInertialDownlink = this.station.getOffsetToInertial(state.getFrame(), downlinkDateDS, factory, indices);
        TimeStampedFieldPVCoordinates<DerivativeStructure> stationDownlink = offsetToInertialDownlink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(downlinkDateDS, zero, zero, zero));
        DerivativeStructure tauD = RangeRate.signalTimeOfFlight(pvaDS, stationDownlink.getPosition(), downlinkDateDS);
        double delta = downlinkDate.durationFrom(state.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        SpacecraftState transitState = state.shiftedBy(deltaMTauD.getValue());
        FieldPVCoordinates transitPV = pvaDS.shiftedBy((RealFieldElement)deltaMTauD);
        EstimatedMeasurement<RangeRate> evalOneWay1 = this.oneWayTheoreticalEvaluation(iteration, evaluation, true, stationDownlink, (TimeStampedFieldPVCoordinates<DerivativeStructure>)transitPV, transitState, indices);
        if (this.twoway) {
            AbsoluteDate approxUplinkDate = downlinkDate.shiftedBy(-2.0 * tauD.getValue());
            FieldAbsoluteDate<DerivativeStructure> approxUplinkDateDS = new FieldAbsoluteDate<DerivativeStructure>(field, approxUplinkDate);
            FieldTransform<DerivativeStructure> offsetToInertialApproxUplink = this.station.getOffsetToInertial(state.getFrame(), approxUplinkDateDS, factory, indices);
            TimeStampedFieldPVCoordinates<DerivativeStructure> stationApproxUplink = offsetToInertialApproxUplink.transformPVCoordinates(new TimeStampedFieldPVCoordinates<DerivativeStructure>(approxUplinkDateDS, zero, zero, zero));
            DerivativeStructure tauU = RangeRate.signalTimeOfFlight(stationApproxUplink, transitPV.getPosition(), ((TimeStampedFieldPVCoordinates)transitPV).getDate());
            FieldPVCoordinates stationUplink = stationApproxUplink.shiftedBy((RealFieldElement)((TimeStampedFieldPVCoordinates)transitPV).getDate().durationFrom(approxUplinkDateDS).subtract(tauU));
            EstimatedMeasurement<RangeRate> evalOneWay2 = this.oneWayTheoreticalEvaluation(iteration, evaluation, false, (TimeStampedFieldPVCoordinates<DerivativeStructure>)stationUplink, (TimeStampedFieldPVCoordinates<DerivativeStructure>)transitPV, transitState, indices);
            estimated = new EstimatedMeasurement<RangeRate>(this, iteration, evaluation, evalOneWay1.getStates(), new TimeStampedPVCoordinates[]{evalOneWay2.getParticipants()[0], evalOneWay1.getParticipants()[0], evalOneWay1.getParticipants()[1]});
            estimated.setEstimatedValue(0.5 * (evalOneWay1.getEstimatedValue()[0] + evalOneWay2.getEstimatedValue()[0]));
            double[][] sd1 = evalOneWay1.getStateDerivatives(0);
            double[][] sd2 = evalOneWay2.getStateDerivatives(0);
            double[][] sd = new double[sd1.length][sd1[0].length];
            for (int i = 0; i < sd.length; ++i) {
                for (int j = 0; j < sd[0].length; ++j) {
                    sd[i][j] = 0.5 * (sd1[i][j] + sd2[i][j]);
                }
            }
            estimated.setStateDerivatives(0, sd);
            evalOneWay1.getDerivativesDrivers().forEach(driver -> {
                double[] pd1 = evalOneWay1.getParameterDerivatives((ParameterDriver)driver);
                double[] pd2 = evalOneWay2.getParameterDerivatives((ParameterDriver)driver);
                double[] pd = new double[pd1.length];
                for (int i = 0; i < pd.length; ++i) {
                    pd[i] = 0.5 * (pd1[i] + pd2[i]);
                }
                estimated.setParameterDerivatives((ParameterDriver)driver, pd);
            });
        } else {
            estimated = evalOneWay1;
        }
        return estimated;
    }

    private EstimatedMeasurement<RangeRate> oneWayTheoreticalEvaluation(int iteration, int evaluation, boolean downlink, TimeStampedFieldPVCoordinates<DerivativeStructure> stationPV, TimeStampedFieldPVCoordinates<DerivativeStructure> transitPV, SpacecraftState transitState, Map<String, Integer> indices) throws OrekitException {
        EstimatedMeasurement<RangeRate> estimated = new EstimatedMeasurement<RangeRate>(this, iteration, evaluation, new SpacecraftState[]{transitState}, new TimeStampedPVCoordinates[]{(downlink ? transitPV : stationPV).toTimeStampedPVCoordinates(), (downlink ? stationPV : transitPV).toTimeStampedPVCoordinates()});
        FieldVector3D stationPosition = stationPV.getPosition();
        FieldVector3D relativePosition = stationPosition.subtract(transitPV.getPosition());
        FieldVector3D stationVelocity = stationPV.getVelocity();
        FieldVector3D relativeVelocity = stationVelocity.subtract(transitPV.getVelocity());
        FieldVector3D lineOfSight = relativePosition.normalize();
        DerivativeStructure rangeRate = (DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)relativeVelocity, (FieldVector3D)lineOfSight);
        estimated.setEstimatedValue(rangeRate.getValue());
        double[] derivatives = rangeRate.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            Integer index = indices.get(driver.getName());
            if (index == null) continue;
            estimated.setParameterDerivatives(driver, derivatives[index + 1]);
        }
        return estimated;
    }
}

