/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.errors;

import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.LocalizedException;
import org.orekit.errors.OrekitMessages;

public class OrekitInternalError
extends IllegalStateException
implements LocalizedException {
    private static final long serialVersionUID = 20150611L;
    private final Localizable specifier = OrekitMessages.INTERNAL_ERROR;
    private final String[] parts = new String[]{"orekit-developers@orekit.org"};

    public OrekitInternalError(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage(Locale locale) {
        return this.buildMessage(locale);
    }

    @Override
    public String getMessage() {
        return this.buildMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.buildMessage(Locale.getDefault());
    }

    @Override
    public Localizable getSpecifier() {
        return this.specifier;
    }

    @Override
    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private String buildMessage(Locale locale) {
        return new MessageFormat(this.specifier.getLocalizedString(locale), locale).format(this.parts);
    }
}

