/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.RealFieldElement;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class TabulatedProvider
implements AttitudeProvider {
    private static final long serialVersionUID = 20140723L;
    private final Frame referenceFrame;
    private final transient ImmutableTimeStampedCache<TimeStampedAngularCoordinates> table;
    private final AngularDerivativesFilter filter;

    public TabulatedProvider(Frame referenceFrame, List<TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter) {
        this.referenceFrame = referenceFrame;
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(n, table);
        this.filter = filter;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        List<TimeStampedAngularCoordinates> sample = this.table.getNeighbors(date).collect(Collectors.toList());
        TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, this.filter, sample);
        return new Attitude(this.referenceFrame, interpolated);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
        List sample = this.table.getNeighbors(date.toAbsoluteDate()).map(ac -> new TimeStampedFieldAngularCoordinates(date.getField(), (TimeStampedAngularCoordinates)ac)).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinates<T> interpolated = TimeStampedFieldAngularCoordinates.interpolate(date, this.filter, sample);
        return new FieldAttitude<T>(this.referenceFrame, interpolated);
    }

    private Object writeReplace() throws NotSerializableException {
        return new DataTransferObject(this.referenceFrame, this.table.getAll(), this.table.getNeighborsSize(), this.filter);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private final Frame referenceFrame;
        private final List<TimeStampedAngularCoordinates> list;
        private final int n;
        private final AngularDerivativesFilter filter;

        DataTransferObject(Frame referenceFrame, List<TimeStampedAngularCoordinates> list, int n, AngularDerivativesFilter filter) {
            this.referenceFrame = referenceFrame;
            this.list = list;
            this.n = n;
            this.filter = filter;
        }

        private Object readResolve() {
            return new TabulatedProvider(this.referenceFrame, this.list, this.n, this.filter);
        }
    }
}

