/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution.continuous;

import org.hipparchus.distribution.continuous.AbstractRealDistribution;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.special.Gamma;
import org.hipparchus.util.FastMath;

public class NakagamiDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20141003L;
    private final double mu;
    private final double omega;

    public NakagamiDistribution(double mu, double omega) throws MathIllegalArgumentException {
        this(mu, omega, 1.0E-9);
    }

    public NakagamiDistribution(double mu, double omega, double inverseAbsoluteAccuracy) throws MathIllegalArgumentException {
        super(inverseAbsoluteAccuracy);
        if (mu < 0.5) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, mu, 0.5);
        }
        if (omega <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_POSITIVE_SCALE, omega);
        }
        this.mu = mu;
        this.omega = omega;
    }

    public double getShape() {
        return this.mu;
    }

    public double getScale() {
        return this.omega;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 2.0 * FastMath.pow(this.mu, this.mu) / (Gamma.gamma(this.mu) * FastMath.pow(this.omega, this.mu)) * FastMath.pow(x, 2.0 * this.mu - 1.0) * FastMath.exp(-this.mu * x * x / this.omega);
    }

    @Override
    public double cumulativeProbability(double x) {
        return Gamma.regularizedGammaP(this.mu, this.mu * x * x / this.omega);
    }

    @Override
    public double getNumericalMean() {
        return Gamma.gamma(this.mu + 0.5) / Gamma.gamma(this.mu) * FastMath.sqrt(this.omega / this.mu);
    }

    @Override
    public double getNumericalVariance() {
        double v = Gamma.gamma(this.mu + 0.5) / Gamma.gamma(this.mu);
        return this.omega * (1.0 - 1.0 / this.mu * v * v);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

