/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.DiagonalMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.SimpleVectorValueChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresFactory;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LevenbergMarquardtOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorConverter;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractPropagatorConverter
implements PropagatorConverter {
    private List<SpacecraftState> sample;
    private double[] target;
    private double[] weight;
    private double rms;
    private boolean onlyPosition;
    private Propagator adapted;
    private final PropagatorBuilder builder;
    private final Frame frame;
    private final LevenbergMarquardtOptimizer optimizer;
    private LeastSquaresOptimizer.Optimum optimum;
    private final ConvergenceChecker<LeastSquaresProblem.Evaluation> checker;
    private final int maxIterations;

    protected AbstractPropagatorConverter(PropagatorBuilder builder, double threshold, int maxIterations) {
        this.builder = builder;
        this.frame = builder.getFrame();
        this.optimizer = new LevenbergMarquardtOptimizer();
        this.maxIterations = maxIterations;
        this.sample = new ArrayList<SpacecraftState>();
        SimpleVectorValueChecker svvc = new SimpleVectorValueChecker(-1.0, threshold);
        this.checker = LeastSquaresFactory.evaluationChecker((ConvergenceChecker)svvc);
    }

    @Override
    public Propagator convert(Propagator source, double timeSpan, int nbPoints, List<String> freeParameters) throws OrekitException, IllegalArgumentException {
        this.setFreeParameters(freeParameters);
        List<SpacecraftState> states = this.createSample(source, timeSpan, nbPoints);
        return this.convert(states, false, freeParameters);
    }

    @Override
    public Propagator convert(Propagator source, double timeSpan, int nbPoints, String ... freeParameters) throws OrekitException, IllegalArgumentException {
        this.setFreeParameters(Arrays.asList(freeParameters));
        List<SpacecraftState> states = this.createSample(source, timeSpan, nbPoints);
        return this.convert(states, false, freeParameters);
    }

    @Override
    public Propagator convert(List<SpacecraftState> states, boolean positionOnly, List<String> freeParameters) throws OrekitException, IllegalArgumentException {
        this.setFreeParameters(freeParameters);
        return this.adapt(states, positionOnly);
    }

    @Override
    public Propagator convert(List<SpacecraftState> states, boolean positionOnly, String ... freeParameters) throws OrekitException, IllegalArgumentException {
        this.setFreeParameters(Arrays.asList(freeParameters));
        return this.adapt(states, positionOnly);
    }

    public Propagator getAdaptedPropagator() {
        return this.adapted;
    }

    public double getRMS() {
        return this.rms;
    }

    public int getEvaluations() {
        return this.optimum.getEvaluations();
    }

    protected abstract MultivariateVectorFunction getObjectiveFunction();

    protected abstract MultivariateJacobianFunction getModel();

    protected boolean isOnlyPosition() {
        return this.onlyPosition;
    }

    protected int getTargetSize() {
        return this.target.length;
    }

    protected Frame getFrame() {
        return this.frame;
    }

    protected List<SpacecraftState> getSample() {
        return this.sample;
    }

    private List<SpacecraftState> createSample(Propagator source, double timeSpan, int nbPoints) throws OrekitException {
        ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        double stepSize = timeSpan / (double)(nbPoints - 1);
        AbsoluteDate iniDate = source.getInitialState().getDate();
        for (double dt = 0.0; dt < timeSpan; dt += stepSize) {
            states.add(source.propagate(iniDate.shiftedBy(dt)));
        }
        return states;
    }

    private void setFreeParameters(Iterable<String> freeParameters) throws OrekitException {
        for (ParameterDriver parameterDriver : this.builder.getPropagationParametersDrivers().getDrivers()) {
            parameterDriver.setSelected(false);
        }
        for (String string : freeParameters) {
            boolean found = false;
            for (ParameterDriver parameterDriver : this.builder.getPropagationParametersDrivers().getDrivers()) {
                if (!parameterDriver.getName().equals(string)) continue;
                found = true;
                parameterDriver.setSelected(true);
                break;
            }
            if (found) continue;
            StringBuilder sBuilder = new StringBuilder();
            for (ParameterDriver parameterDriver : this.builder.getPropagationParametersDrivers().getDrivers()) {
                if (sBuilder.length() > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(parameterDriver.getName());
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, string, sBuilder.toString());
        }
    }

    private Propagator adapt(List<SpacecraftState> states, boolean positionOnly) throws OrekitException {
        this.onlyPosition = positionOnly;
        double[] initial = this.builder.getSelectedNormalizedParameters();
        this.setSample(states.subList(0, this.onlyPosition ? 2 : 1));
        double[] intermediate = this.fit(initial);
        this.setSample(states);
        double[] result = this.fit(intermediate);
        this.rms = this.getRMS(result);
        this.adapted = this.buildAdaptedPropagator(result);
        return this.adapted;
    }

    private double[] fit(double[] initial) throws OrekitException, MathRuntimeException {
        LeastSquaresProblem problem = new LeastSquaresBuilder().maxIterations(this.maxIterations).maxEvaluations(Integer.MAX_VALUE).model(this.getModel()).target(this.target).weight((RealMatrix)new DiagonalMatrix(this.weight)).start(initial).checker(this.checker).build();
        this.optimum = this.optimizer.optimize(problem);
        return this.optimum.getPoint().toArray();
    }

    private double getRMS(double[] parameterSet) throws OrekitException {
        try {
            double[] residuals = this.getObjectiveFunction().value(parameterSet);
            for (int i = 0; i < residuals.length; ++i) {
                residuals[i] = this.target[i] - residuals[i];
            }
            double sum2 = 0.0;
            for (double residual : residuals) {
                sum2 += residual * residual;
            }
            return FastMath.sqrt((double)(sum2 / (double)residuals.length));
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    private Propagator buildAdaptedPropagator(double[] parameterSet) throws OrekitException {
        return this.builder.buildPropagator(parameterSet);
    }

    private void setSample(List<SpacecraftState> states) throws OrekitException {
        this.sample = states;
        if (this.onlyPosition) {
            this.target = new double[states.size() * 3];
            this.weight = new double[states.size() * 3];
        } else {
            this.target = new double[states.size() * 6];
            this.weight = new double[states.size() * 6];
        }
        int k = 0;
        for (int i = 0; i < states.size(); ++i) {
            TimeStampedPVCoordinates pv = states.get(i).getPVCoordinates(this.frame);
            this.target[k] = pv.getPosition().getX();
            this.weight[k++] = 1.0;
            this.target[k] = pv.getPosition().getY();
            this.weight[k++] = 1.0;
            this.target[k] = pv.getPosition().getZ();
            this.weight[k++] = 1.0;
            if (this.onlyPosition) continue;
            double r2 = pv.getPosition().getNormSq();
            double v = pv.getVelocity().getNorm();
            double vWeight = v * r2 / states.get(i).getMu();
            this.target[k] = pv.getVelocity().getX();
            this.weight[k++] = vWeight;
            this.target[k] = pv.getVelocity().getY();
            this.weight[k++] = vWeight;
            this.target[k] = pv.getVelocity().getZ();
            this.weight[k++] = vWeight;
        }
    }
}

