/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldQRDecomposition;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldAngularCoordinates<T extends RealFieldElement<T>> {
    private final FieldRotation<T> rotation;
    private final FieldVector3D<T> rotationRate;
    private final FieldVector3D<T> rotationAcceleration;

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        this(rotation, rotationRate, new FieldVector3D((RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero()));
    }

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public FieldAngularCoordinates(FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) throws OrekitException {
        try {
            this.rotation = new FieldRotation(u1.getPosition(), u2.getPosition(), v1.getPosition(), v2.getPosition());
            FieldVector3D ru1Dot = this.rotation.applyTo(u1.getVelocity());
            FieldVector3D ru2Dot = this.rotation.applyTo(u2.getVelocity());
            this.rotationRate = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), ru1Dot.subtract(v1.getVelocity()), v2.getPosition(), ru2Dot.subtract(v2.getVelocity()), tolerance);
            FieldVector3D ru1DotDot = this.rotation.applyTo(u1.getAcceleration());
            FieldVector3D oDotv1 = FieldVector3D.crossProduct(this.rotationRate, v1.getVelocity());
            FieldVector3D oov1 = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)this.rotationRate.crossProduct(v1.getPosition()));
            FieldVector3D c1 = new FieldVector3D(1.0, ru1DotDot, -2.0, oDotv1, -1.0, oov1, -1.0, v1.getAcceleration());
            FieldVector3D ru2DotDot = this.rotation.applyTo(u2.getAcceleration());
            FieldVector3D oDotv2 = FieldVector3D.crossProduct(this.rotationRate, v2.getVelocity());
            FieldVector3D oov2 = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)this.rotationRate.crossProduct(v2.getPosition()));
            FieldVector3D c2 = new FieldVector3D(1.0, ru2DotDot, -2.0, oDotv2, -1.0, oov2, -1.0, v2.getAcceleration());
            this.rotationAcceleration = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), c1, v2.getPosition(), c2, tolerance);
        }
        catch (MathIllegalArgumentException miae) {
            throw new OrekitException((MathRuntimeException)((Object)miae));
        }
    }

    public FieldAngularCoordinates(Field<T> field, AngularCoordinates ang) {
        this.rotation = new FieldRotation(field, ang.getRotation());
        this.rotationRate = new FieldVector3D(field, ang.getRotationRate());
        this.rotationAcceleration = new FieldVector3D(field, ang.getRotationAcceleration());
    }

    public static <T extends RealFieldElement<T>> FieldAngularCoordinates<T> getIdentity(Field<T> field) {
        return new FieldAngularCoordinates<T>(field, AngularCoordinates.IDENTITY);
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> inverseCrossProducts(FieldVector3D<T> v1, FieldVector3D<T> c1, FieldVector3D<T> v2, FieldVector3D<T> c2, double tolerance) throws MathIllegalArgumentException {
        RealFieldElement v12 = v1.getNormSq();
        RealFieldElement v1n = (RealFieldElement)v12.sqrt();
        RealFieldElement v22 = v2.getNormSq();
        RealFieldElement v2n = (RealFieldElement)v22.sqrt();
        RealFieldElement threshold = v1n.getReal() >= v2n.getReal() ? (RealFieldElement)v1n.multiply(tolerance) : (RealFieldElement)v2n.multiply(tolerance);
        FieldVector3D omega = null;
        try {
            FieldMatrix m = MatrixUtils.createFieldMatrix((Field)v12.getField(), (int)6, (int)3);
            m.setEntry(0, 1, (FieldElement)v1.getZ());
            m.setEntry(0, 2, (FieldElement)v1.getY().negate());
            m.setEntry(1, 0, (FieldElement)v1.getZ().negate());
            m.setEntry(1, 2, (FieldElement)v1.getX());
            m.setEntry(2, 0, (FieldElement)v1.getY());
            m.setEntry(2, 1, (FieldElement)v1.getX().negate());
            m.setEntry(3, 1, (FieldElement)v2.getZ());
            m.setEntry(3, 2, (FieldElement)v2.getY().negate());
            m.setEntry(4, 0, (FieldElement)v2.getZ().negate());
            m.setEntry(4, 2, (FieldElement)v2.getX());
            m.setEntry(5, 0, (FieldElement)v2.getY());
            m.setEntry(5, 1, (FieldElement)v2.getX().negate());
            RealFieldElement[] kk = (RealFieldElement[])MathArrays.buildArray((Field)v2n.getField(), (int)6);
            kk[0] = c1.getX();
            kk[1] = c1.getY();
            kk[2] = c1.getZ();
            kk[3] = c2.getX();
            kk[4] = c2.getY();
            kk[5] = c2.getZ();
            FieldVector rhs = MatrixUtils.createFieldVector((FieldElement[])kk);
            FieldDecompositionSolver solver = new FieldQRDecomposition(m).getSolver();
            FieldVector v = solver.solve(rhs);
            omega = new FieldVector3D((RealFieldElement)v.getEntry(0), (RealFieldElement)v.getEntry(1), (RealFieldElement)v.getEntry(2));
        }
        catch (MathIllegalArgumentException miae) {
            if (miae.getSpecifier() == LocalizedCoreFormats.SINGULAR_MATRIX) {
                RealFieldElement c12 = c1.getNormSq();
                RealFieldElement c1n = (RealFieldElement)c12.sqrt();
                RealFieldElement c22 = c2.getNormSq();
                RealFieldElement c2n = (RealFieldElement)c22.sqrt();
                if (c1n.getReal() <= threshold.getReal() && c2n.getReal() <= threshold.getReal()) {
                    return new FieldVector3D((RealFieldElement)v12.getField().getZero(), (RealFieldElement)v12.getField().getZero(), (RealFieldElement)v12.getField().getZero());
                }
                if (v1n.getReal() <= threshold.getReal() && c1n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c1n.getReal(), 0, true});
                }
                if (v2n.getReal() <= threshold.getReal() && c2n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c2n.getReal(), 0, true});
                }
                if (v1.crossProduct(v1).getNorm().getReal() <= threshold.getReal() && v12.getReal() > threshold.getReal()) {
                    omega = new FieldVector3D((RealFieldElement)v12.reciprocal(), v1.crossProduct(c1));
                }
            }
            throw miae;
        }
        RealFieldElement d1 = FieldVector3D.distance((FieldVector3D)omega.crossProduct(v1), c1);
        if (d1.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{0, true});
        }
        RealFieldElement d2 = FieldVector3D.distance((FieldVector3D)omega.crossProduct(v2), c2);
        if (d2.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{0, true});
        }
        return omega;
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, double dt) {
        return FieldAngularCoordinates.estimateRate(start, end, (RealFieldElement)((RealFieldElement)start.getQ0().getField().getZero()).add(dt));
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, T dt) {
        FieldRotation evolution = start.compose(end.revert(), RotationConvention.VECTOR_OPERATOR);
        return new FieldVector3D((RealFieldElement)evolution.getAngle().divide(dt), evolution.getAxis(RotationConvention.VECTOR_OPERATOR));
    }

    public FieldAngularCoordinates<T> revert() {
        return new FieldAngularCoordinates<T>(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate.negate()), this.rotation.applyInverseTo(this.rotationAcceleration.negate()));
    }

    public FieldAngularCoordinates<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.rotation.getQ0().getField().getZero()).add(dt));
    }

    public FieldAngularCoordinates<T> shiftedBy(T dt) {
        RealFieldElement rate = this.rotationRate.getNorm();
        RealFieldElement zero = (RealFieldElement)rate.getField().getZero();
        RealFieldElement one = (RealFieldElement)rate.getField().getOne();
        FieldRotation rateContribution = rate.getReal() == 0.0 ? new FieldRotation(one, zero, zero, zero, false) : new FieldRotation(this.rotationRate, (RealFieldElement)rate.multiply(dt), RotationConvention.FRAME_TRANSFORM);
        FieldAngularCoordinates<T> linearPart = new FieldAngularCoordinates<T>(rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        RealFieldElement acc = this.rotationAcceleration.getNorm();
        if (acc.getReal() == 0.0) {
            return linearPart;
        }
        FieldAngularCoordinates<T> quadraticContribution = new FieldAngularCoordinates<T>(new FieldRotation(this.rotationAcceleration, (RealFieldElement)acc.multiply(((RealFieldElement)dt.multiply(0.5)).multiply(dt)), RotationConvention.FRAME_TRANSFORM), new FieldVector3D(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public FieldRotation<T> getRotation() {
        return this.rotation;
    }

    public FieldVector3D<T> getRotationRate() {
        return this.rotationRate;
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public FieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.rotation.applyTo(offset.rotationRate);
        FieldVector3D rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new FieldAngularCoordinates<T>(this.rotation.compose(offset.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate.add(rOmega), new FieldVector3D(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)rOmega)));
    }

    public FieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset(offset.revert());
    }

    public AngularCoordinates toAngularCoordinates() {
        return new AngularCoordinates(this.rotation.toRotation(), this.rotationRate.toVector3D(), this.rotationAcceleration.toVector3D());
    }

    public FieldPVCoordinates<T> applyTo(PVCoordinates pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedPVCoordinates pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public FieldPVCoordinates<T> applyTo(FieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public T[][] getModifiedRodrigues(double sign) {
        RealFieldElement q0 = (RealFieldElement)this.getRotation().getQ0().multiply(sign);
        RealFieldElement q1 = (RealFieldElement)this.getRotation().getQ1().multiply(sign);
        RealFieldElement q2 = (RealFieldElement)this.getRotation().getQ2().multiply(sign);
        RealFieldElement q3 = (RealFieldElement)this.getRotation().getQ3().multiply(sign);
        RealFieldElement oX = this.getRotationRate().getX();
        RealFieldElement oY = this.getRotationRate().getY();
        RealFieldElement oZ = this.getRotationRate().getZ();
        RealFieldElement oXDot = this.getRotationAcceleration().getX();
        RealFieldElement oYDot = this.getRotationAcceleration().getY();
        RealFieldElement oZDot = this.getRotationAcceleration().getZ();
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), (Object)oX, q2.negate(), (Object)oY, q3.negate(), (Object)oZ)).multiply(0.5);
        RealFieldElement q1Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination((Object)q0, (Object)oX, q3.negate(), (Object)oY, (Object)q2, (Object)oZ)).multiply(0.5);
        RealFieldElement q2Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination((Object)q3, (Object)oX, (Object)q0, (Object)oY, q1.negate(), (Object)oZ)).multiply(0.5);
        RealFieldElement q3Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), (Object)oX, (Object)q1, (Object)oY, (Object)q0, (Object)oZ)).multiply(0.5);
        RealFieldElement q0DotDot = (RealFieldElement)this.linearCombination(q1, oXDot, q2, oYDot, q3, oZDot, q1Dot, oX, q2Dot, oY, q3Dot, oZ).multiply(-0.5);
        RealFieldElement q1DotDot = (RealFieldElement)this.linearCombination(q0, oXDot, q2, oZDot, (RealFieldElement)q3.negate(), oYDot, q0Dot, oX, q2Dot, oZ, (RealFieldElement)q3Dot.negate(), oY).multiply(0.5);
        RealFieldElement q2DotDot = (RealFieldElement)this.linearCombination(q0, oYDot, q3, oXDot, (RealFieldElement)q1.negate(), oZDot, q0Dot, oY, q3Dot, oX, (RealFieldElement)q1Dot.negate(), oZ).multiply(0.5);
        RealFieldElement q3DotDot = (RealFieldElement)this.linearCombination(q0, oZDot, q1, oYDot, (RealFieldElement)q2.negate(), oXDot, q0Dot, oZ, q1Dot, oY, (RealFieldElement)q2Dot.negate(), oX).multiply(0.5);
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)q0.add(1.0)).reciprocal();
        RealFieldElement mTwoInvQ0Dot = (RealFieldElement)((RealFieldElement)inv.multiply((Object)q0Dot)).multiply(-2);
        RealFieldElement r1 = (RealFieldElement)inv.multiply((Object)q1);
        RealFieldElement r2 = (RealFieldElement)inv.multiply((Object)q2);
        RealFieldElement r3 = (RealFieldElement)inv.multiply((Object)q3);
        RealFieldElement mInvR1 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r1)).negate();
        RealFieldElement mInvR2 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r2)).negate();
        RealFieldElement mInvR3 = (RealFieldElement)((RealFieldElement)inv.multiply((Object)r3)).negate();
        RealFieldElement r1Dot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q1Dot, (Object)mInvR1, (Object)q0Dot);
        RealFieldElement r2Dot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q2Dot, (Object)mInvR2, (Object)q0Dot);
        RealFieldElement r3Dot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q3Dot, (Object)mInvR3, (Object)q0Dot);
        RealFieldElement r1DotDot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q1DotDot, (Object)mTwoInvQ0Dot, (Object)r1Dot, (Object)mInvR1, (Object)q0DotDot);
        RealFieldElement r2DotDot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q2DotDot, (Object)mTwoInvQ0Dot, (Object)r2Dot, (Object)mInvR2, (Object)q0DotDot);
        RealFieldElement r3DotDot = (RealFieldElement)q0.linearCombination((Object)inv, (Object)q3DotDot, (Object)mTwoInvQ0Dot, (Object)r3Dot, (Object)mInvR3, (Object)q0DotDot);
        RealFieldElement[][] rodrigues = (RealFieldElement[][])MathArrays.buildArray((Field)q0.getField(), (int)3, (int)3);
        rodrigues[0][0] = r1;
        rodrigues[0][1] = r2;
        rodrigues[0][2] = r3;
        rodrigues[1][0] = r1Dot;
        rodrigues[1][1] = r2Dot;
        rodrigues[1][2] = r3Dot;
        rodrigues[2][0] = r1DotDot;
        rodrigues[2][1] = r2DotDot;
        rodrigues[2][2] = r3DotDot;
        return rodrigues;
    }

    private T linearCombination(T a1, T b1, T a2, T b2, T a3, T b3, T a4, T b4, T a5, T b5, T a6, T b6) {
        Object[] a = (RealFieldElement[])MathArrays.buildArray((Field)a1.getField(), (int)6);
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        a[3] = a4;
        a[4] = a5;
        a[5] = a6;
        Object[] b = (RealFieldElement[])MathArrays.buildArray((Field)b1.getField(), (int)6);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        b[3] = b4;
        b[4] = b5;
        b[5] = b6;
        return (T)((RealFieldElement)a1.linearCombination(a, b));
    }

    public static <T extends RealFieldElement<T>> FieldAngularCoordinates<T> createFromModifiedRodrigues(T[][] r) {
        RealFieldElement rSquared = (RealFieldElement)((RealFieldElement)((RealFieldElement)r[0][0].multiply(r[0][0])).add(r[0][1].multiply(r[0][1]))).add(r[0][2].multiply(r[0][2]));
        RealFieldElement oPQ0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)rSquared.add(1.0)).reciprocal()).multiply(2);
        RealFieldElement q0 = (RealFieldElement)oPQ0.subtract(1.0);
        RealFieldElement q1 = (RealFieldElement)oPQ0.multiply(r[0][0]);
        RealFieldElement q2 = (RealFieldElement)oPQ0.multiply(r[0][1]);
        RealFieldElement q3 = (RealFieldElement)oPQ0.multiply(r[0][2]);
        RealFieldElement oPQ02 = (RealFieldElement)oPQ0.multiply((Object)oPQ0);
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)oPQ02.multiply(q0.linearCombination(r[0][0], r[1][0], r[0][1], r[1][1], r[0][2], r[1][2]))).negate();
        RealFieldElement q1Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][0])).add(r[0][0].multiply((Object)q0Dot));
        RealFieldElement q2Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][1])).add(r[0][1].multiply((Object)q0Dot));
        RealFieldElement q3Dot = (RealFieldElement)((RealFieldElement)oPQ0.multiply(r[1][2])).add(r[0][2].multiply((Object)q0Dot));
        RealFieldElement oX = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), (Object)q0Dot, (Object)q0, (Object)q1Dot, (Object)q3, (Object)q2Dot, q2.negate(), (Object)q3Dot)).multiply(2);
        RealFieldElement oY = (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), (Object)q0Dot, q3.negate(), (Object)q1Dot, (Object)q0, (Object)q2Dot, (Object)q1, (Object)q3Dot)).multiply(2);
        RealFieldElement oZ = (RealFieldElement)((RealFieldElement)q0.linearCombination(q3.negate(), (Object)q0Dot, (Object)q2, (Object)q1Dot, q1.negate(), (Object)q2Dot, (Object)q0, (Object)q3Dot)).multiply(2);
        RealFieldElement q0DotDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)q0.subtract(1.0)).negate()).divide((Object)oPQ0)).multiply((Object)q0Dot)).multiply((Object)q0Dot)).subtract(oPQ02.multiply(q0.linearCombination(r[0][0], r[2][0], r[0][1], r[2][1], r[0][2], r[2][2])))).subtract(((RealFieldElement)((RealFieldElement)q1Dot.multiply((Object)q1Dot)).add(q2Dot.multiply((Object)q2Dot))).add(q3Dot.multiply((Object)q3Dot)));
        RealFieldElement q1DotDot = (RealFieldElement)q0.linearCombination((Object)oPQ0, r[2][0], r[1][0].add(r[1][0]), (Object)q0Dot, r[0][0], (Object)q0DotDot);
        RealFieldElement q2DotDot = (RealFieldElement)q0.linearCombination((Object)oPQ0, r[2][1], r[1][1].add(r[1][1]), (Object)q0Dot, r[0][1], (Object)q0DotDot);
        RealFieldElement q3DotDot = (RealFieldElement)q0.linearCombination((Object)oPQ0, r[2][2], r[1][2].add(r[1][2]), (Object)q0Dot, r[0][2], (Object)q0DotDot);
        RealFieldElement oXDot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), (Object)q0DotDot, (Object)q0, (Object)q1DotDot, (Object)q3, (Object)q2DotDot, q2.negate(), (Object)q3DotDot)).multiply(2);
        RealFieldElement oYDot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), (Object)q0DotDot, q3.negate(), (Object)q1DotDot, (Object)q0, (Object)q2DotDot, (Object)q1, (Object)q3DotDot)).multiply(2);
        RealFieldElement oZDot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q3.negate(), (Object)q0DotDot, (Object)q2, (Object)q1DotDot, q1.negate(), (Object)q2DotDot, (Object)q0, (Object)q3DotDot)).multiply(2);
        return new FieldAngularCoordinates<T>(new FieldRotation(q0, q1, q2, q3, false), new FieldVector3D(oX, oY, oZ), new FieldVector3D(oXDot, oYDot, oZDot));
    }
}

