/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FixedNumberInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.InterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.MaxGapInterpolationGrid;
import org.orekit.time.AbsoluteDate;

public class DSSTPropagator
extends AbstractIntegratedPropagator {
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS_PER_STEP = 3;
    private boolean initialIsOsculating;
    private final transient List<DSSTForceModel> forceModels = new ArrayList<DSSTForceModel>();
    private MeanPlusShortPeriodicMapper mapper;
    private InterpolationGrid interpolationgrid;

    public DSSTPropagator(ODEIntegrator integrator, boolean meanOnly) {
        super(integrator, meanOnly);
        this.initMapper();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(DEFAULT_LAW);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    public DSSTPropagator(ODEIntegrator integrator) {
        super(integrator, true);
        this.initMapper();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(DEFAULT_LAW);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    public void setInitialState(SpacecraftState initialState) throws OrekitException {
        this.setInitialState(initialState, true);
    }

    public void setInitialState(SpacecraftState initialState, boolean isOsculating) throws OrekitException {
        this.initialIsOsculating = isOsculating;
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws OrekitException {
        super.setStartDate(state.getDate());
        super.resetInitialState(state);
    }

    public void setSelectedCoefficients(Set<String> selectedCoefficients) {
        this.mapper.setSelectedCoefficients((Set<String>)(selectedCoefficients == null ? null : new HashSet<String>(selectedCoefficients)));
    }

    public Set<String> getSelectedCoefficients() {
        Set<String> set = this.mapper.getSelectedCoefficients();
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    public boolean initialIsOsculating() {
        return this.initialIsOsculating;
    }

    public void setInterpolationGridToFixedNumberOfPoints(int interpolationPoints) {
        this.interpolationgrid = new FixedNumberInterpolationGrid(interpolationPoints);
    }

    public void setInterpolationGridToMaxTimeGap(double maxGap) {
        this.interpolationgrid = new MaxGapInterpolationGrid(maxGap);
    }

    public void addForceModel(DSSTForceModel force) {
        this.forceModels.add(force);
        force.registerAttitudeProvider(this.getAttitudeProvider());
    }

    public void removeForceModels() {
        this.forceModels.clear();
    }

    public static SpacecraftState computeOsculatingState(SpacecraftState mean, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forces) throws OrekitException {
        AuxiliaryElements aux = new AuxiliaryElements(mean.getOrbit(), 1);
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel force : forces) {
            force.registerAttitudeProvider(attitudeProvider);
            shortPeriodTerms.addAll(force.initialize(aux, false));
            force.updateShortPeriodTerms(mean);
        }
        EquinoctialOrbit osculatingOrbit = DSSTPropagator.computeOsculatingOrbit(mean, shortPeriodTerms);
        return new SpacecraftState(osculatingOrbit, mean.getAttitude(), mean.getMass(), mean.getAdditionalStates());
    }

    public static SpacecraftState computeMeanState(SpacecraftState osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModels) throws OrekitException {
        Orbit meanOrbit = DSSTPropagator.computeMeanOrbit(osculating, attitudeProvider, forceModels);
        return new SpacecraftState(meanOrbit, osculating.getAttitude(), osculating.getMass(), osculating.getAdditionalStates());
    }

    public void setSatelliteRevolution(int satelliteRevolution) {
        this.mapper.setSatelliteRevolution(satelliteRevolution);
    }

    public int getSatelliteRevolution() {
        return this.mapper.getSatelliteRevolution();
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        for (DSSTForceModel force : this.forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) throws OrekitException {
        AuxiliaryElements aux = new AuxiliaryElements(initialState.getOrbit(), 1);
        boolean meanOnly = this.isMeanOrbit();
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel force : this.forceModels) {
            shortPeriodTerms.addAll(force.initialize(aux, meanOnly));
        }
        this.mapper.setShortPeriodTerms(shortPeriodTerms);
        if (!meanOnly) {
            ShortPeriodicsHandler spHandler = new ShortPeriodicsHandler(this.forceModels);
            ArrayList<ShortPeriodicsHandler> stepHandlers = new ArrayList<ShortPeriodicsHandler>();
            stepHandlers.add(spHandler);
            ODEIntegrator integrator = this.getIntegrator();
            Collection existing = integrator.getStepHandlers();
            stepHandlers.addAll(existing);
            integrator.clearStepHandlers();
            for (ODEStepHandler oDEStepHandler : stepHandlers) {
                integrator.addStepHandler(oDEStepHandler);
            }
        }
    }

    @Override
    protected void afterIntegration() throws OrekitException {
        if (!this.isMeanOrbit()) {
            ArrayList<ODEStepHandler> preserved = new ArrayList<ODEStepHandler>();
            ODEIntegrator integrator = this.getIntegrator();
            for (ODEStepHandler sp : integrator.getStepHandlers()) {
                if (sp instanceof ShortPeriodicsHandler) continue;
                preserved.add(sp);
            }
            integrator.clearStepHandlers();
            for (ODEStepHandler sp : preserved) {
                integrator.addStepHandler(sp);
            }
        }
    }

    private static Orbit computeMeanOrbit(SpacecraftState osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModels) throws OrekitException {
        EquinoctialOrbit meanOrbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(osculating.getOrbit());
        double epsilon = 1.0E-13;
        double thresholdA = 1.0E-13 * (1.0 + FastMath.abs((double)meanOrbit.getA()));
        double thresholdE = 1.0E-13 * (1.0 + meanOrbit.getE());
        double thresholdI = 1.0E-13 * (1.0 + meanOrbit.getI());
        double thresholdL = 3.141592653589793E-13;
        for (DSSTForceModel force : forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
        int i = 0;
        while (i++ < 200) {
            SpacecraftState meanState = new SpacecraftState((Orbit)meanOrbit, osculating.getAttitude(), osculating.getMass());
            AuxiliaryElements aux = new AuxiliaryElements(meanOrbit, 1);
            ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
            for (DSSTForceModel force : forceModels) {
                shortPeriodTerms.addAll(force.initialize(aux, false));
                force.updateShortPeriodTerms(meanState);
            }
            EquinoctialOrbit rebuilt = DSSTPropagator.computeOsculatingOrbit(meanState, shortPeriodTerms);
            double deltaA = osculating.getA() - rebuilt.getA();
            double deltaEx = osculating.getEquinoctialEx() - rebuilt.getEquinoctialEx();
            double deltaEy = osculating.getEquinoctialEy() - rebuilt.getEquinoctialEy();
            double deltaHx = osculating.getHx() - rebuilt.getHx();
            double deltaHy = osculating.getHy() - rebuilt.getHy();
            double deltaLv = MathUtils.normalizeAngle((double)(osculating.getLv() - rebuilt.getLv()), (double)0.0);
            if (FastMath.abs((double)deltaA) < thresholdA && FastMath.abs((double)deltaEx) < thresholdE && FastMath.abs((double)deltaEy) < thresholdE && FastMath.abs((double)deltaHx) < thresholdI && FastMath.abs((double)deltaHy) < thresholdI && FastMath.abs((double)deltaLv) < 3.141592653589793E-13) {
                return meanOrbit;
            }
            meanOrbit = new EquinoctialOrbit(meanOrbit.getA() + deltaA, meanOrbit.getEquinoctialEx() + deltaEx, meanOrbit.getEquinoctialEy() + deltaEy, meanOrbit.getHx() + deltaHx, meanOrbit.getHy() + deltaHy, meanOrbit.getLv() + deltaLv, PositionAngle.TRUE, meanOrbit.getFrame(), meanOrbit.getDate(), meanOrbit.getMu());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS, i);
    }

    private static EquinoctialOrbit computeOsculatingOrbit(SpacecraftState meanState, List<ShortPeriodTerms> shortPeriodTerms) throws OrekitException {
        double[] mean = new double[6];
        double[] meanDot = new double[6];
        OrbitType.EQUINOCTIAL.mapOrbitToArray(meanState.getOrbit(), PositionAngle.MEAN, mean, meanDot);
        double[] y = (double[])mean.clone();
        for (ShortPeriodTerms spt : shortPeriodTerms) {
            double[] shortPeriodic = spt.value(meanState.getOrbit());
            for (int i = 0; i < shortPeriodic.length; ++i) {
                int n = i;
                y[n] = y[n] + shortPeriodic[i];
            }
        }
        return (EquinoctialOrbit)OrbitType.EQUINOCTIAL.mapArrayToOrbit(y, meanDot, PositionAngle.MEAN, meanState.getDate(), meanState.getMu(), meanState.getFrame());
    }

    @Override
    protected SpacecraftState getInitialIntegrationState() throws OrekitException {
        if (this.initialIsOsculating) {
            return DSSTPropagator.computeMeanState(this.getInitialState(), this.getAttitudeProvider(), this.forceModels);
        }
        return this.getInitialState();
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType ignoredOrbitType, PositionAngle ignoredPositionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        MeanPlusShortPeriodicMapper newMapper = new MeanPlusShortPeriodicMapper(referenceDate, mu, attitudeProvider, frame);
        if (this.mapper != null) {
            newMapper.setSatelliteRevolution(this.mapper.getSatelliteRevolution());
            newMapper.setSelectedCoefficients(this.mapper.getSelectedCoefficients());
            newMapper.setShortPeriodTerms(this.mapper.getShortPeriodTerms());
        }
        this.mapper = newMapper;
        return this.mapper;
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(ODEIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, Orbit orbit) throws OrekitException {
        return NumericalPropagator.tolerances(dP, orbit, OrbitType.EQUINOCTIAL);
    }

    private class ShortPeriodicsHandler
    implements ODEStepHandler {
        private final List<DSSTForceModel> forceModels;

        ShortPeriodicsHandler(List<DSSTForceModel> forceModels) {
            this.forceModels = forceModels;
        }

        public void handleStep(ODEStateInterpolator interpolator, boolean isLast) throws OrekitExceptionWrapper {
            try {
                double[] interpolationPoints = DSSTPropagator.this.interpolationgrid.getGridPoints(interpolator.getPreviousState().getTime(), interpolator.getCurrentState().getTime());
                SpacecraftState[] meanStates = new SpacecraftState[interpolationPoints.length];
                for (int i = 0; i < interpolationPoints.length; ++i) {
                    double time = interpolationPoints[i];
                    ODEStateAndDerivative sd = interpolator.getInterpolatedState(time);
                    meanStates[i] = DSSTPropagator.this.mapper.mapArrayToState(time, sd.getPrimaryState(), sd.getPrimaryDerivative(), true);
                }
                for (DSSTForceModel forceModel : this.forceModels) {
                    forceModel.updateShortPeriodTerms(meanStates);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations {
        private final double[] yDot = new double[7];

        Main(ODEIntegrator integrator) {
            for (DSSTForceModel forceModel : DSSTPropagator.this.forceModels) {
                EventDetector[] modelDetectors = forceModel.getEventsDetectors();
                if (modelDetectors == null) continue;
                for (EventDetector detector : modelDetectors) {
                    DSSTPropagator.this.setUpEventDetector(integrator, detector);
                }
            }
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) throws OrekitException {
            AuxiliaryElements aux = new AuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel force : DSSTPropagator.this.forceModels) {
                force.initializeStep(aux);
            }
            Arrays.fill(this.yDot, 0.0);
            for (DSSTForceModel forceModel : DSSTPropagator.this.forceModels) {
                double[] daidt = forceModel.getMeanElementRate(state);
                for (int i = 0; i < daidt.length; ++i) {
                    int n = i;
                    this.yDot[n] = this.yDot[n] + daidt[i];
                }
            }
            EquinoctialOrbit orbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(state.getOrbit());
            orbit.addKeplerContribution(PositionAngle.MEAN, DSSTPropagator.this.getMu(), this.yDot);
            return (double[])this.yDot.clone();
        }
    }

    private static class MeanPlusShortPeriodicMapper
    extends StateMapper
    implements Serializable {
        private static final long serialVersionUID = 20151104L;
        private Set<String> selectedCoefficients = null;
        private int satelliteRevolution = 2;
        private List<ShortPeriodTerms> shortPeriodTerms = Collections.emptyList();

        MeanPlusShortPeriodicMapper(AbsoluteDate referenceDate, double mu, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, OrbitType.EQUINOCTIAL, PositionAngle.MEAN, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(AbsoluteDate date, double[] y, double[] yDot, boolean meanOnly) throws OrekitException {
            HashMap<String, double[]> coefficients;
            double[] elements = (double[])y.clone();
            if (meanOnly) {
                coefficients = null;
            } else {
                Orbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, yDot, PositionAngle.MEAN, date, this.getMu(), this.getFrame());
                coefficients = this.selectedCoefficients == null ? null : new HashMap<String, double[]>();
                for (ShortPeriodTerms spt : this.shortPeriodTerms) {
                    double[] shortPeriodic = spt.value(meanOrbit);
                    for (int i = 0; i < shortPeriodic.length; ++i) {
                        int n = i;
                        elements[n] = elements[n] + shortPeriodic[i];
                    }
                    if (this.selectedCoefficients == null) continue;
                    coefficients.putAll(spt.getCoefficients(date, this.selectedCoefficients));
                }
            }
            double mass = elements[6];
            if (mass <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            Orbit orbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, yDot, PositionAngle.MEAN, date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            if (coefficients == null) {
                return new SpacecraftState(orbit, attitude, mass);
            }
            return new SpacecraftState(orbit, attitude, mass, coefficients);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y, double[] yDot) throws OrekitException {
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngle.MEAN, y, yDot);
            y[6] = state.getMass();
        }

        public void setSatelliteRevolution(int satelliteRevolution) {
            this.satelliteRevolution = satelliteRevolution;
        }

        public int getSatelliteRevolution() {
            return this.satelliteRevolution;
        }

        public void setSelectedCoefficients(Set<String> selectedCoefficients) {
            this.selectedCoefficients = selectedCoefficients;
        }

        public Set<String> getSelectedCoefficients() {
            return this.selectedCoefficients;
        }

        public void setShortPeriodTerms(List<ShortPeriodTerms> shortPeriodTerms) {
            this.shortPeriodTerms = shortPeriodTerms;
        }

        public List<ShortPeriodTerms> getShortPeriodTerms() {
            return this.shortPeriodTerms;
        }

        private Object writeReplace() throws NotSerializableException {
            return new DataTransferObject(this.getReferenceDate(), this.getMu(), this.getAttitudeProvider(), this.getFrame(), this.satelliteRevolution, this.selectedCoefficients, this.shortPeriodTerms);
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20151106L;
            private final AbsoluteDate referenceDate;
            private final double mu;
            private final AttitudeProvider attitudeProvider;
            private final Frame frame;
            private final Set<String> selectedCoefficients;
            private final int satelliteRevolution;
            private final List<ShortPeriodTerms> shortPeriodTerms;

            DataTransferObject(AbsoluteDate referenceDate, double mu, AttitudeProvider attitudeProvider, Frame frame, int satelliteRevolution, Set<String> selectedCoefficients, List<ShortPeriodTerms> shortPeriodTerms) {
                this.referenceDate = referenceDate;
                this.mu = mu;
                this.attitudeProvider = attitudeProvider;
                this.frame = frame;
                this.satelliteRevolution = satelliteRevolution;
                this.selectedCoefficients = selectedCoefficients;
                this.shortPeriodTerms = shortPeriodTerms;
            }

            private Object readResolve() {
                MeanPlusShortPeriodicMapper mapper = new MeanPlusShortPeriodicMapper(this.referenceDate, this.mu, this.attitudeProvider, this.frame);
                mapper.setSatelliteRevolution(this.satelliteRevolution);
                mapper.setSelectedCoefficients(this.selectedCoefficients);
                mapper.setShortPeriodTerms(this.shortPeriodTerms);
                return mapper;
            }
        }
    }
}

