/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.ParameterObserver;

public abstract class AbstractPropagatorBuilder
implements PropagatorBuilder {
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final AbsoluteDate initialOrbitDate;
    private final Frame frame;
    private double mu;
    private final ParameterDriversList orbitalDrivers;
    private ParameterDriversList propagationDrivers;
    private final OrbitType orbitType;
    private final PositionAngle positionAngle;

    protected AbstractPropagatorBuilder(Orbit templateOrbit, PositionAngle positionAngle, double positionScale, boolean addDriverForCentralAttraction) throws OrekitException {
        this.initialOrbitDate = templateOrbit.getDate();
        this.frame = templateOrbit.getFrame();
        this.mu = templateOrbit.getMu();
        this.propagationDrivers = new ParameterDriversList();
        this.orbitType = templateOrbit.getType();
        this.positionAngle = positionAngle;
        this.orbitalDrivers = this.orbitType.getDrivers(positionScale, templateOrbit, positionAngle);
        for (ParameterDriversList.DelegatingDriver driver : this.orbitalDrivers.getDrivers()) {
            driver.setSelected(true);
        }
        if (addDriverForCentralAttraction) {
            ParameterDriver muDriver = new ParameterDriver("central attraction coefficient", this.mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
            muDriver.addObserver(new ParameterObserver(){

                @Override
                public void valueChanged(double previousValue, ParameterDriver driver) {
                    AbstractPropagatorBuilder.this.mu = driver.getValue();
                }
            });
            this.propagationDrivers.add(muDriver);
        }
    }

    @Override
    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    @Override
    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    @Override
    public AbsoluteDate getInitialOrbitDate() {
        return this.initialOrbitDate;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public ParameterDriversList getOrbitalParametersDrivers() {
        return this.orbitalDrivers;
    }

    @Override
    public ParameterDriversList getPropagationParametersDrivers() {
        return this.propagationDrivers;
    }

    private int getNbSelected() {
        int count = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++count;
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double[] getSelectedNormalizedParameters() {
        double[] selected = new double[this.getNbSelected()];
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            selected[index++] = parameterDriver.getNormalizedValue();
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            selected[index++] = parameterDriver.getNormalizedValue();
        }
        return selected;
    }

    protected Orbit createInitialOrbit() {
        double[] unNormalized = new double[this.orbitalDrivers.getNbParams()];
        for (int i = 0; i < unNormalized.length; ++i) {
            unNormalized[i] = this.orbitalDrivers.getDrivers().get(i).getValue();
        }
        return this.getOrbitType().mapArrayToOrbit(unNormalized, null, this.positionAngle, this.initialOrbitDate, this.mu, this.frame);
    }

    protected void setParameters(double[] normalizedParameters) throws OrekitException, OrekitIllegalArgumentException {
        if (normalizedParameters.length != this.getNbSelected()) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, normalizedParameters.length, this.getNbSelected());
        }
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            parameterDriver.setNormalizedValue(normalizedParameters[index++]);
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            parameterDriver.setNormalizedValue(normalizedParameters[index++]);
        }
    }

    protected void addSupportedParameter(ParameterDriver driver) throws OrekitException {
        this.propagationDrivers.add(driver);
        this.propagationDrivers.sort();
    }
}

