/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.EventState;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractAnalyticalPropagator
extends AbstractPropagator {
    private PVCoordinatesProvider pvProvider;
    private AbsoluteDate lastPropagationStart;
    private AbsoluteDate lastPropagationEnd;
    private boolean statesInitialized;
    private boolean isLastStep;
    private final Collection<EventState<?>> eventsStates;

    protected AbstractAnalyticalPropagator(AttitudeProvider attitudeProvider) {
        this.setAttitudeProvider(attitudeProvider);
        this.pvProvider = new LocalPVProvider();
        this.lastPropagationStart = AbsoluteDate.PAST_INFINITY;
        this.lastPropagationEnd = AbsoluteDate.FUTURE_INFINITY;
        this.statesInitialized = false;
        this.eventsStates = new ArrayList();
    }

    @Override
    public BoundedPropagator getGeneratedEphemeris() {
        return new BoundedPropagatorView(this.lastPropagationStart, this.lastPropagationEnd);
    }

    @Override
    public <T extends EventDetector> void addEventDetector(T detector) {
        this.eventsStates.add(new EventState<T>(detector));
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        ArrayList list = new ArrayList();
        for (EventState<?> state : this.eventsStates) {
            list.add(state.getEventDetector());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void clearEventsDetectors() {
        this.eventsStates.clear();
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate start, AbsoluteDate target) throws OrekitException {
        try {
            this.lastPropagationStart = start;
            double dt = target.durationFrom(start);
            double epsilon = FastMath.ulp((double)dt);
            SpacecraftState state = this.updateAdditionalStates(this.basicPropagate(start));
            double stepSize = this.getMode() == 1 ? (Double.isNaN(this.getFixedStepSize()) ? FastMath.copySign((double)(state.getKeplerianPeriod() / 100.0), (double)dt) : FastMath.copySign((double)this.getFixedStepSize(), (double)dt)) : dt;
            for (EventState<?> es : this.eventsStates) {
                es.init(state, target);
            }
            if (this.getStepHandler() != null) {
                this.getStepHandler().init(state, target);
            }
            this.statesInitialized = false;
            this.isLastStep = false;
            do {
                SpacecraftState previous = state;
                AbsoluteDate t = previous.getDate().shiftedBy(stepSize);
                if (dt == 0.0 || dt > 0.0 ^ t.compareTo(target) <= 0 || FastMath.abs((double)target.durationFrom(t)) <= epsilon) {
                    t = target;
                }
                SpacecraftState current = this.updateAdditionalStates(this.basicPropagate(t));
                BasicStepInterpolator interpolator = new BasicStepInterpolator(dt >= 0.0, previous, current);
                state = this.acceptStep(interpolator, target, epsilon);
            } while (!this.isLastStep);
            this.lastPropagationEnd = state.getDate();
            this.setStartDate(state.getDate());
            return state;
        }
        catch (MathRuntimeException mrte) {
            throw OrekitException.unwrap(mrte);
        }
    }

    protected SpacecraftState acceptStep(OrekitStepInterpolator interpolator, AbsoluteDate target, double epsilon) throws OrekitException, MathRuntimeException {
        SpacecraftState previous = interpolator.getPreviousState();
        SpacecraftState current = interpolator.getCurrentState();
        if (!this.statesInitialized) {
            if (!this.eventsStates.isEmpty()) {
                for (EventState<?> state : this.eventsStates) {
                    state.reinitializeBegin(interpolator);
                }
            }
            this.statesInitialized = true;
        }
        final int orderingSign = interpolator.isForward() ? 1 : -1;
        PriorityQueue occurringEvents = new PriorityQueue(new Comparator<EventState<?>>(){

            @Override
            public int compare(EventState<?> es0, EventState<?> es1) {
                return orderingSign * es0.getEventDate().compareTo(es1.getEventDate());
            }
        });
        for (EventState<?> state : this.eventsStates) {
            if (!state.evaluateStep(interpolator)) continue;
            occurringEvents.add(state);
        }
        OrekitStepInterpolator restricted = interpolator;
        block2: while (true) {
            if (!occurringEvents.isEmpty()) {
                SpacecraftState resetState;
                EventState currentEvent = (EventState)occurringEvents.poll();
                SpacecraftState eventState = restricted.getInterpolatedState(currentEvent.getEventDate());
                for (EventState<?> state : this.eventsStates) {
                    if (state == currentEvent || !state.tryAdvance(eventState, interpolator)) continue;
                    occurringEvents.remove(state);
                    occurringEvents.add(state);
                    occurringEvents.add(currentEvent);
                    continue block2;
                }
                EventState.EventOccurrence occurrence = currentEvent.doEvent(eventState);
                EventHandler.Action action = occurrence.getAction();
                boolean bl = this.isLastStep = action == EventHandler.Action.STOP;
                if (this.isLastStep) {
                    eventState = interpolator.getInterpolatedState(occurrence.getStopDate());
                    restricted = restricted.restrictStep(previous, eventState);
                }
                if (this.getStepHandler() != null) {
                    this.getStepHandler().handleStep(restricted, this.isLastStep);
                }
                if (this.isLastStep) {
                    return eventState;
                }
                if ((action == EventHandler.Action.RESET_DERIVATIVES || action == EventHandler.Action.RESET_STATE) && (resetState = occurrence.getNewState()) != null) {
                    this.resetIntermediateState(resetState, interpolator.isForward());
                    return resetState;
                }
                previous = eventState;
                if (!currentEvent.evaluateStep(restricted = new BasicStepInterpolator(restricted.isForward(), eventState, current))) continue;
                occurringEvents.add(currentEvent);
                continue;
            }
            for (EventState<?> state : this.eventsStates) {
                if (!state.tryAdvance(current, interpolator)) continue;
                occurringEvents.add(state);
            }
            if (occurringEvents.isEmpty()) break;
        }
        this.isLastStep = target.equals(current.getDate());
        if (this.getStepHandler() != null) {
            this.getStepHandler().handleStep(interpolator, this.isLastStep);
        }
        return current;
    }

    protected abstract double getMass(AbsoluteDate var1) throws OrekitException;

    public PVCoordinatesProvider getPvProvider() {
        return this.pvProvider;
    }

    protected abstract void resetIntermediateState(SpacecraftState var1, boolean var2) throws OrekitException;

    protected abstract Orbit propagateOrbit(AbsoluteDate var1) throws OrekitException;

    protected SpacecraftState basicPropagate(AbsoluteDate date) throws OrekitException {
        try {
            Orbit orbit = this.propagateOrbit(date);
            Attitude attitude = this.getAttitudeProvider().getAttitude(this.pvProvider, date, orbit.getFrame());
            return new SpacecraftState(orbit, attitude, this.getMass(date));
        }
        catch (OrekitException oe) {
            throw new OrekitException(oe);
        }
    }

    private class BasicStepInterpolator
    implements OrekitStepInterpolator {
        private final SpacecraftState previousState;
        private final SpacecraftState currentState;
        private final boolean forward;

        BasicStepInterpolator(boolean isForward, SpacecraftState previousState, SpacecraftState currentState) {
            this.forward = isForward;
            this.previousState = previousState;
            this.currentState = currentState;
        }

        @Override
        public SpacecraftState getPreviousState() {
            return this.previousState;
        }

        @Override
        public boolean isPreviousStateInterpolated() {
            return false;
        }

        @Override
        public SpacecraftState getCurrentState() {
            return this.currentState;
        }

        @Override
        public boolean isCurrentStateInterpolated() {
            return false;
        }

        @Override
        public SpacecraftState getInterpolatedState(AbsoluteDate date) throws OrekitException {
            SpacecraftState basicState = AbstractAnalyticalPropagator.this.basicPropagate(date);
            return AbstractAnalyticalPropagator.this.updateAdditionalStates(basicState);
        }

        @Override
        public boolean isForward() {
            return this.forward;
        }

        @Override
        public BasicStepInterpolator restrictStep(SpacecraftState newPreviousState, SpacecraftState newCurrentState) {
            return new BasicStepInterpolator(this.forward, newPreviousState, newCurrentState);
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20151117L;
        private final AbsoluteDate minDate;
        private final AbsoluteDate maxDate;
        private final AbstractAnalyticalPropagator propagator;

        DataTransferObject(AbsoluteDate minDate, AbsoluteDate maxDate, AbstractAnalyticalPropagator propagator) {
            this.minDate = minDate;
            this.maxDate = maxDate;
            this.propagator = propagator;
        }

        private Object readResolve() {
            this.propagator.lastPropagationStart = this.minDate;
            this.propagator.lastPropagationEnd = this.maxDate;
            return this.propagator.getGeneratedEphemeris();
        }
    }

    private class BoundedPropagatorView
    extends AbstractAnalyticalPropagator
    implements BoundedPropagator,
    Serializable {
        private static final long serialVersionUID = 20151117L;
        private final AbsoluteDate minDate;
        private final AbsoluteDate maxDate;

        BoundedPropagatorView(AbsoluteDate startDate, AbsoluteDate endDate) {
            super(AbstractAnalyticalPropagator.this.getAttitudeProvider());
            if (startDate.compareTo(endDate) <= 0) {
                this.minDate = startDate;
                this.maxDate = endDate;
            } else {
                this.minDate = endDate;
                this.maxDate = startDate;
            }
            try {
                for (AdditionalStateProvider provider : AbstractAnalyticalPropagator.this.getAdditionalStateProviders()) {
                    this.addAdditionalStateProvider(provider);
                }
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(null);
            }
        }

        @Override
        public AbsoluteDate getMinDate() {
            return this.minDate;
        }

        @Override
        public AbsoluteDate getMaxDate() {
            return this.maxDate;
        }

        @Override
        protected Orbit propagateOrbit(AbsoluteDate target) throws OrekitException {
            return AbstractAnalyticalPropagator.this.propagateOrbit(target);
        }

        @Override
        public double getMass(AbsoluteDate date) throws OrekitException {
            return AbstractAnalyticalPropagator.this.getMass(date);
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
            return this.propagate(date).getPVCoordinates(frame);
        }

        @Override
        public void resetInitialState(SpacecraftState state) throws OrekitException {
            AbstractAnalyticalPropagator.this.resetInitialState(state);
        }

        @Override
        protected void resetIntermediateState(SpacecraftState state, boolean forward) throws OrekitException {
            AbstractAnalyticalPropagator.this.resetIntermediateState(state, forward);
        }

        @Override
        public SpacecraftState getInitialState() throws OrekitException {
            return AbstractAnalyticalPropagator.this.getInitialState();
        }

        @Override
        public Frame getFrame() {
            return AbstractAnalyticalPropagator.this.getFrame();
        }

        private Object writeReplace() throws NotSerializableException {
            return new DataTransferObject(this.minDate, this.maxDate, AbstractAnalyticalPropagator.this);
        }
    }

    private class LocalPVProvider
    implements PVCoordinatesProvider {
        private LocalPVProvider() {
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
            return AbstractAnalyticalPropagator.this.propagateOrbit(date).getPVCoordinates(frame);
        }
    }
}

