/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import org.hipparchus.exception.Localizable;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.HelmertTransformation;
import org.orekit.frames.LOFType;
import org.orekit.utils.IERSConventions;

public enum CCSDSFrame {
    EME2000(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            return FramesFactory.getEME2000();
        }
    }
    ,
    GCRF(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            return FramesFactory.getGCRF();
        }
    }
    ,
    GRC(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return FramesFactory.getITRFEquinox(conventions, simpleEOP);
        }
    }
    ,
    ICRF(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            return FramesFactory.getICRF();
        }
    }
    ,
    ITRF2008(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return FramesFactory.getITRF(conventions, simpleEOP);
        }
    }
    ,
    ITRF2005(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            FactoryManagedFrame itrf2008 = FramesFactory.getITRF(conventions, simpleEOP);
            HelmertTransformation.Predefined predefinedHT = HelmertTransformation.Predefined.ITRF_2008_TO_ITRF_2005;
            return predefinedHT.createTransformedITRF(itrf2008, this.toString());
        }
    }
    ,
    ITRF2000(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            FactoryManagedFrame itrf2008 = FramesFactory.getITRF(conventions, simpleEOP);
            HelmertTransformation.Predefined predefinedHT = HelmertTransformation.Predefined.ITRF_2008_TO_ITRF_2000;
            return predefinedHT.createTransformedITRF(itrf2008, this.toString());
        }
    }
    ,
    ITRF93(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            FactoryManagedFrame itrf2008 = FramesFactory.getITRF(conventions, simpleEOP);
            HelmertTransformation.Predefined predefinedHT = HelmertTransformation.Predefined.ITRF_2008_TO_ITRF_93;
            return predefinedHT.createTransformedITRF(itrf2008, this.toString());
        }
    }
    ,
    ITRF97(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            FactoryManagedFrame itrf2008 = FramesFactory.getITRF(conventions, simpleEOP);
            HelmertTransformation.Predefined predefinedHT = HelmertTransformation.Predefined.ITRF_2008_TO_ITRF_97;
            return predefinedHT.createTransformedITRF(itrf2008, this.toString());
        }
    }
    ,
    MCI(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            return CelestialBodyFactory.getMars().getInertiallyOrientedFrame();
        }
    }
    ,
    TDR(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return FramesFactory.getGTOD(conventions, simpleEOP);
        }
    }
    ,
    TEME(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            return FramesFactory.getTEME();
        }
    }
    ,
    TOD(null){

        @Override
        public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
            if (conventions == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
            }
            return FramesFactory.getTOD(conventions, simpleEOP);
        }
    }
    ,
    RTN(LOFType.QSW),
    RSW(LOFType.QSW),
    TNW(LOFType.TNW);

    private final LOFType lofType;

    private CCSDSFrame(LOFType lofType) {
        this.lofType = lofType;
    }

    public boolean isLof() {
        return this.lofType != null;
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    public Frame getFrame(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.toString());
    }
}

