/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesRange
extends AbstractMeasurement<InterSatellitesRange> {
    private final boolean twoway;

    public InterSatellitesRange(int satellite1Index, int satellite2Index, boolean twoWay, AbsoluteDate date, double range, double sigma, double baseWeight) throws OrekitException {
        super(date, range, sigma, baseWeight, Arrays.asList(satellite1Index, satellite2Index), new ParameterDriver[0]);
        this.twoway = twoWay;
    }

    public boolean isTwoWay() {
        return this.twoway;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) throws OrekitException {
        DerivativeStructure range;
        EstimatedMeasurement<InterSatellitesRange> estimated;
        int nbParams = 12;
        DSFactory factory = new DSFactory(12, 1);
        Field field = factory.getDerivativeField();
        SpacecraftState state1 = states[this.getPropagatorsIndices().get(0)];
        TimeStampedFieldPVCoordinates<DerivativeStructure> pva1 = InterSatellitesRange.getCoordinates(state1, 0, factory);
        SpacecraftState state2 = states[this.getPropagatorsIndices().get(1)];
        TimeStampedFieldPVCoordinates<DerivativeStructure> pva2 = InterSatellitesRange.getCoordinates(state2, 6, factory);
        FieldAbsoluteDate<DerivativeStructure> arrivalDate = new FieldAbsoluteDate<DerivativeStructure>(field, this.getDate());
        FieldPVCoordinates s1Downlink = pva1.shiftedBy((RealFieldElement)arrivalDate.durationFrom(pva1.getDate()));
        DerivativeStructure tauD = InterSatellitesRange.signalTimeOfFlight(pva2, s1Downlink.getPosition(), arrivalDate);
        double delta = this.getDate().durationFrom(state2.getDate());
        DerivativeStructure deltaMTauD = tauD.negate().add(delta);
        if (this.twoway) {
            FieldPVCoordinates transitStateDS = pva2.shiftedBy((RealFieldElement)deltaMTauD);
            DerivativeStructure tauU = InterSatellitesRange.signalTimeOfFlight(pva1, transitStateDS.getPosition(), ((TimeStampedFieldPVCoordinates)transitStateDS).getDate());
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{state1.shiftedBy(deltaMTauD.getValue()), state2.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{state1.shiftedBy(delta - tauD.getValue() - tauU.getValue()).getPVCoordinates(), state2.shiftedBy(delta - tauD.getValue()).getPVCoordinates(), state1.shiftedBy(delta).getPVCoordinates()});
            range = tauD.add(tauU).multiply(1.49896229E8);
        } else {
            estimated = new EstimatedMeasurement<InterSatellitesRange>(this, iteration, evaluation, new SpacecraftState[]{state1.shiftedBy(deltaMTauD.getValue()), state2.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{state2.shiftedBy(delta - tauD.getValue()).getPVCoordinates(), state1.shiftedBy(delta).getPVCoordinates()});
            range = tauD.multiply(2.99792458E8);
        }
        estimated.setEstimatedValue(range.getValue());
        double[] derivatives = range.getAllDerivatives();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 1, 7)});
        estimated.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 7, 13)});
        return estimated;
    }
}

