/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractFieldODEStateInterpolator;
import org.hipparchus.util.MathArrays;

abstract class RungeKuttaFieldStateInterpolator<T extends RealFieldElement<T>>
extends AbstractFieldODEStateInterpolator<T> {
    private final Field<T> field;
    private final T[][] yDotK;

    protected RungeKuttaFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(forward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        this.field = field;
        this.yDotK = (RealFieldElement[][])MathArrays.buildArray(field, (int)yDotK.length, (int)-1);
        for (int i = 0; i < yDotK.length; ++i) {
            this.yDotK[i] = (RealFieldElement[])yDotK[i].clone();
        }
    }

    @Override
    protected RungeKuttaFieldStateInterpolator<T> create(boolean newForward, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return this.create((Field)this.field, newForward, (RealFieldElement[][])this.yDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    protected abstract RungeKuttaFieldStateInterpolator<T> create(Field<T> var1, boolean var2, T[][] var3, FieldODEStateAndDerivative<T> var4, FieldODEStateAndDerivative<T> var5, FieldODEStateAndDerivative<T> var6, FieldODEStateAndDerivative<T> var7, FieldEquationsMapper<T> var8);

    @SafeVarargs
    protected final T[] previousStateLinearCombination(T ... coefficients) {
        return this.combine(this.getPreviousState().getCompleteState(), (RealFieldElement[])coefficients);
    }

    protected T[] currentStateLinearCombination(T ... coefficients) {
        return this.combine(this.getCurrentState().getCompleteState(), (RealFieldElement[])coefficients);
    }

    protected T[] derivativeLinearCombination(T ... coefficients) {
        return this.combine((RealFieldElement[])MathArrays.buildArray(this.field, (int)this.yDotK[0].length), (RealFieldElement[])coefficients);
    }

    private T[] combine(T[] a, T ... coefficients) {
        for (int i = 0; i < a.length; ++i) {
            for (int k = 0; k < coefficients.length; ++k) {
                a[i] = (RealFieldElement)a[i].add(coefficients[k].multiply(this.yDotK[k][i]));
            }
        }
        return a;
    }
}

