/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondaryODE;

public class ExpandableODE {
    private final OrdinaryDifferentialEquation primary;
    private List<SecondaryODE> components;
    private EquationsMapper mapper;

    public ExpandableODE(OrdinaryDifferentialEquation primary) {
        this.primary = primary;
        this.components = new ArrayList<SecondaryODE>();
        this.mapper = new EquationsMapper(null, primary.getDimension());
    }

    public OrdinaryDifferentialEquation getPrimary() {
        return this.primary;
    }

    public EquationsMapper getMapper() {
        return this.mapper;
    }

    public int addSecondaryEquations(SecondaryODE secondary) {
        this.components.add(secondary);
        this.mapper = new EquationsMapper(this.mapper, secondary.getDimension());
        return this.components.size();
    }

    public void init(ODEState s0, double finalTime) {
        double t0 = s0.getTime();
        int index = 0;
        double[] primary0 = s0.getPrimaryState();
        this.primary.init(t0, primary0, finalTime);
        while (++index < this.mapper.getNumberOfEquations()) {
            double[] secondary0 = s0.getSecondaryState(index);
            this.components.get(index - 1).init(t0, primary0, secondary0, finalTime);
        }
    }

    public double[] computeDerivatives(double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException {
        double[] yDot = new double[this.mapper.getTotalDimension()];
        int index = 0;
        double[] primaryState = this.mapper.extractEquationData(index, y);
        double[] primaryStateDot = this.primary.computeDerivatives(t, primaryState);
        this.mapper.insertEquationData(index, primaryStateDot, yDot);
        while (++index < this.mapper.getNumberOfEquations()) {
            double[] componentState = this.mapper.extractEquationData(index, y);
            double[] componentStateDot = this.components.get(index - 1).computeDerivatives(t, primaryState, primaryStateDot, componentState);
            this.mapper.insertEquationData(index, componentStateDot, yDot);
        }
        return yDot;
    }
}

