/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.errors.OrekitInternalError;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class EventState<T extends EventDetector>
implements Serializable {
    private static final long serialVersionUID = 4489391420715269318L;
    private T detector;
    private AbsoluteDate lastT;
    private double lastG;
    private AbsoluteDate t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private AbsoluteDate pendingEventTime;
    private AbsoluteDate stopTime;
    private AbsoluteDate afterEvent;
    private double afterG;
    private AbsoluteDate earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;

    public EventState(T detector) {
        this.detector = detector;
        this.lastT = AbsoluteDate.PAST_INFINITY;
        this.lastG = Double.NaN;
        this.t0 = null;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.stopTime = null;
        this.increasing = true;
        this.earliestTimeConsidered = null;
        this.afterEvent = null;
        this.afterG = Double.NaN;
    }

    public T getEventDetector() {
        return this.detector;
    }

    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.detector.init(s0, t);
        this.lastT = AbsoluteDate.PAST_INFINITY;
        this.lastG = Double.NaN;
    }

    private double g(SpacecraftState s) throws OrekitException {
        if (!s.getDate().equals(this.lastT)) {
            this.lastT = s.getDate();
            this.lastG = this.detector.g(s);
        }
        return this.lastG;
    }

    public void reinitializeBegin(OrekitStepInterpolator interpolator) throws OrekitException {
        this.forward = interpolator.isForward();
        SpacecraftState s0 = interpolator.getPreviousState();
        this.t0 = s0.getDate();
        this.g0 = this.g(s0);
        while (this.g0 == 0.0) {
            double dt = (this.forward ? 0.5 : -0.5) * this.detector.getThreshold();
            AbsoluteDate startDate = this.t0.shiftedBy(dt);
            if (this.t0.equals(startDate)) {
                startDate = this.nextAfter(startDate);
            }
            this.t0 = startDate;
            this.g0 = this.g(interpolator.getInterpolatedState(this.t0));
        }
        this.increasing = this.g0Positive = this.g0 > 0.0;
    }

    public boolean evaluateStep(OrekitStepInterpolator interpolator) throws OrekitException, MathRuntimeException {
        this.forward = interpolator.isForward();
        SpacecraftState s1 = interpolator.getCurrentState();
        AbsoluteDate t1 = s1.getDate();
        double dt = t1.durationFrom(this.t0);
        if (FastMath.abs((double)dt) < this.detector.getThreshold()) {
            return false;
        }
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt) / this.detector.getMaxCheckInterval()))));
        double h = dt / (double)n;
        AbsoluteDate ta = this.t0;
        double ga = this.g0;
        for (int i = 0; i < n; ++i) {
            AbsoluteDate tb = i == n - 1 ? t1 : this.t0.shiftedBy((double)(i + 1) * h);
            double gb = this.g(interpolator.getInterpolatedState(tb));
            if (gb == 0.0 || this.g0Positive ^ gb > 0.0) {
                if (!this.findRoot(interpolator, ta, ga, tb, gb)) continue;
                return true;
            }
            ta = tb;
            ga = gb;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    private boolean findRoot(OrekitStepInterpolator interpolator, AbsoluteDate ta, double ga, AbsoluteDate tb, double gb) throws OrekitException {
        double newGa;
        this.check(ga == 0.0 || gb == 0.0 || ga > 0.0 && gb < 0.0 || ga < 0.0 && gb > 0.0);
        double convergence = this.detector.getThreshold();
        int maxIterationCount = this.detector.getMaxIterationCount();
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(0.0, convergence, 0.0, 5);
        AbsoluteDate beforeRootT = null;
        double beforeRootG = Double.NaN;
        AbsoluteDate afterRootT = ta;
        double afterRootG = 0.0;
        if (ta.equals(tb)) {
            beforeRootT = ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy(beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
        } else if (ga != 0.0 && gb == 0.0) {
            beforeRootT = tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy(beforeRootT, convergence);
            afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
        } else if (ga != 0.0 && ga > 0.0 != (newGa = this.g(interpolator.getInterpolatedState(ta))) > 0.0) {
            beforeRootT = ta;
            beforeRootG = newGa;
            afterRootT = this.minTime(this.shiftedBy(beforeRootT, convergence), tb);
            afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
        }
        AbsoluteDate loopT = ta;
        double loopG = ga;
        while ((afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            if (loopG == 0.0) {
                beforeRootT = loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, convergence), tb);
                afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
            } else {
                try {
                    BracketedUnivariateSolver.Interval interval;
                    AbsoluteDate fT0 = loopT;
                    UnivariateFunction f = dt -> {
                        try {
                            return this.g(interpolator.getInterpolatedState(fT0.shiftedBy(dt)));
                        }
                        catch (OrekitException oe) {
                            throw new OrekitExceptionWrapper(oe);
                        }
                    };
                    double tbDouble = tb.durationFrom(fT0);
                    if (this.forward) {
                        interval = solver.solveInterval(maxIterationCount, f, 0.0, tbDouble);
                        beforeRootT = fT0.shiftedBy(interval.getLeftAbscissa());
                        beforeRootG = interval.getLeftValue();
                        afterRootT = fT0.shiftedBy(interval.getRightAbscissa());
                        afterRootG = interval.getRightValue();
                    } else {
                        interval = solver.solveInterval(maxIterationCount, f, tbDouble, 0.0);
                        beforeRootT = fT0.shiftedBy(interval.getRightAbscissa());
                        beforeRootG = interval.getRightValue();
                        afterRootT = fT0.shiftedBy(interval.getLeftAbscissa());
                        afterRootG = interval.getLeftValue();
                    }
                }
                catch (OrekitExceptionWrapper oew) {
                    throw oew.getException();
                }
            }
            if (beforeRootT.equals(afterRootT)) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = this.g(interpolator.getInterpolatedState(afterRootT));
            }
            this.check(this.forward && afterRootT.compareTo(beforeRootT) > 0 || !this.forward && afterRootT.compareTo(beforeRootT) < 0);
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(beforeRootT != null && !Double.isNaN(beforeRootG));
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG > 0.0 == this.increasing);
        this.check(this.increasing == gb >= ga);
        return true;
    }

    private AbsoluteDate nextAfter(AbsoluteDate t) {
        return t.shiftedBy(this.forward ? Precision.EPSILON : -Precision.EPSILON);
    }

    public AbsoluteDate getEventDate() {
        return this.pendingEventTime;
    }

    public boolean tryAdvance(SpacecraftState state, OrekitStepInterpolator interpolator) throws OrekitException {
        boolean positive;
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, state.getDate()));
        AbsoluteDate t = state.getDate();
        if (this.strictlyAfter(t, this.earliestTimeConsidered)) {
            return false;
        }
        double g = this.g(state);
        boolean bl = positive = g > 0.0;
        if (g == 0.0 && t.equals(this.pendingEventTime) || positive == this.g0Positive) {
            this.t0 = t;
            this.g0 = g;
            return false;
        }
        return this.findRoot(interpolator, this.t0, this.g0, t, g);
    }

    public EventOccurrence doEvent(SpacecraftState state) throws OrekitException {
        this.check(this.pendingEvent);
        this.check(state.getDate().equals(this.pendingEventTime));
        EventHandler.Action action = this.detector.eventOccurred(state, this.increasing == this.forward);
        SpacecraftState newState = action == EventHandler.Action.RESET_STATE ? this.detector.resetState(state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0 == 0.0 || this.g0Positive == this.g0 > 0.0);
        return new EventOccurrence(action, newState, this.stopTime);
    }

    private AbsoluteDate shiftedBy(AbsoluteDate t, double delta) {
        if (this.forward) {
            AbsoluteDate ret = t.shiftedBy(delta);
            if (ret.durationFrom(t) > delta) {
                return ret.shiftedBy(-Precision.EPSILON);
            }
            return ret;
        }
        AbsoluteDate ret = t.shiftedBy(-delta);
        if (t.durationFrom(ret) > delta) {
            return ret.shiftedBy(Precision.EPSILON);
        }
        return ret;
    }

    private AbsoluteDate minTime(AbsoluteDate a, AbsoluteDate b) {
        return this.forward ^ a.compareTo(b) > 0 ? a : b;
    }

    private boolean strictlyAfter(AbsoluteDate t1, AbsoluteDate t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        return this.forward ? t1.compareTo(t2) < 0 : t2.compareTo(t1) < 0;
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw new OrekitInternalError(null);
        }
    }

    public static class EventOccurrence {
        private final EventHandler.Action action;
        private final SpacecraftState newState;
        private final AbsoluteDate stopDate;

        EventOccurrence(EventHandler.Action action, SpacecraftState newState, AbsoluteDate stopDate) {
            this.action = action;
            this.newState = newState;
            this.stopDate = stopDate;
        }

        public EventHandler.Action getAction() {
            return this.action;
        }

        public SpacecraftState getNewState() {
            return this.newState;
        }

        public AbsoluteDate getStopDate() {
            return this.stopDate;
        }
    }
}

