/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldDateDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class ConstantThrustManeuver
extends AbstractForceModel {
    public static final String THRUST = "thrust";
    public static final String FLOW_RATE = "flow rate";
    private static final double THRUST_SCALE = FastMath.scalb((double)1.0, (int)-5);
    private static final double FLOW_RATE_SCALE = FastMath.scalb((double)1.0, (int)-12);
    private final ParameterDriver thrustDriver;
    private final ParameterDriver flowRateDriver;
    private boolean firing;
    private final AbsoluteDate startDate;
    private final AbsoluteDate endDate;
    private final Vector3D direction;

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction) {
        this(date, duration, thrust, isp, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction, String driversNamePrefix) {
        if (duration >= 0.0) {
            this.startDate = date;
            this.endDate = date.shiftedBy(duration);
        } else {
            this.endDate = date;
            this.startDate = this.endDate.shiftedBy(duration);
        }
        double flowRate = -thrust / (9.80665 * isp);
        this.direction = direction.normalize();
        this.firing = false;
        ParameterDriver tpd = null;
        ParameterDriver fpd = null;
        try {
            tpd = new ParameterDriver(driversNamePrefix + THRUST, thrust, THRUST_SCALE, 0.0, Double.POSITIVE_INFINITY);
            fpd = new ParameterDriver(driversNamePrefix + FLOW_RATE, flowRate, FLOW_RATE_SCALE, Double.NEGATIVE_INFINITY, 0.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.thrustDriver = tpd;
        this.flowRateDriver = fpd;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        AbsoluteDate sDate = s0.getDate();
        boolean isForward = sDate.compareTo(t) < 0;
        boolean isBetween = this.startDate.compareTo(sDate) < 0 && this.endDate.compareTo(sDate) > 0;
        boolean isOnStart = this.startDate.compareTo(sDate) == 0;
        boolean isOnEnd = this.endDate.compareTo(sDate) == 0;
        this.firing = isBetween || isForward && isOnStart || !isForward && isOnEnd;
    }

    public double getThrust() {
        return this.thrustDriver.getValue();
    }

    public double getISP() {
        double thrust = this.getThrust();
        double flowRate = this.getFlowRate();
        return -thrust / (9.80665 * flowRate);
    }

    public double getFlowRate() {
        return this.flowRateDriver.getValue();
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        if (this.firing) {
            double[] parameters = this.getParameters();
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(parameters[1]);
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void addContribution(FieldSpacecraftState<T> s, FieldTimeDerivativesEquations<T> adder) throws OrekitException {
        if (this.firing) {
            RealFieldElement[] parameters = this.getParameters(s.getDate().getField());
            adder.addNonKeplerianAcceleration(this.acceleration(s, parameters));
            adder.addMassDerivative(parameters[1]);
        }
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        if (this.firing) {
            double thrust = parameters[0];
            return new Vector3D(thrust / state.getMass(), state.getAttitude().getRotation().applyInverseTo(this.direction));
        }
        return Vector3D.ZERO;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        if (this.firing) {
            T thrust = parameters[0];
            return new FieldVector3D((RealFieldElement)((RealFieldElement)s.getMass().reciprocal()).multiply(thrust), s.getAttitude().getRotation().applyInverseTo(this.direction));
        }
        return FieldVector3D.getZero((Field)s.getMass().getField());
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        DateDetector startDetector = new DateDetector(this.startDate).withHandler((state, d, increasing) -> {
            this.firing = d.isForward();
            return EventHandler.Action.RESET_DERIVATIVES;
        });
        DateDetector endDetector = new DateDetector(this.endDate).withHandler((state, d, increasing) -> {
            this.firing = !d.isForward();
            return EventHandler.Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.thrustDriver, this.flowRateDriver};
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        FieldDateDetector startDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.startDate)).withHandler((state, d, increasing) -> {
            this.firing = d.isForward();
            return FieldEventHandler.Action.RESET_DERIVATIVES;
        });
        FieldDateDetector endDetector = new FieldDateDetector(new FieldAbsoluteDate<T>(field, this.endDate)).withHandler((state, d, increasing) -> {
            this.firing = !d.isForward();
            return FieldEventHandler.Action.RESET_DERIVATIVES;
        });
        return Stream.of(startDetector, endDetector);
    }
}

