/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.PVCoordinates;

public class FieldPVCoordinates<T extends RealFieldElement<T>>
implements TimeShiftable<FieldPVCoordinates<T>> {
    private final FieldVector3D<T> position;
    private final FieldVector3D<T> velocity;
    private final FieldVector3D<T> acceleration;

    public FieldPVCoordinates(FieldVector3D<T> position, FieldVector3D<T> velocity) {
        this.position = position;
        this.velocity = velocity;
        RealFieldElement zero = (RealFieldElement)position.getX().getField().getZero();
        this.acceleration = new FieldVector3D(zero, zero, zero);
    }

    public FieldPVCoordinates(FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        this.position = position;
        this.velocity = velocity;
        this.acceleration = acceleration;
    }

    public FieldPVCoordinates(Field<T> field, PVCoordinates pv) {
        this.position = new FieldVector3D(field, pv.getPosition());
        this.velocity = new FieldVector3D(field, pv.getVelocity());
        this.acceleration = new FieldVector3D(field, pv.getAcceleration());
    }

    public FieldPVCoordinates(double a, FieldPVCoordinates<T> pv) {
        this.position = new FieldVector3D(a, pv.position);
        this.velocity = new FieldVector3D(a, pv.velocity);
        this.acceleration = new FieldVector3D(a, pv.acceleration);
    }

    public FieldPVCoordinates(T a, FieldPVCoordinates<T> pv) {
        this.position = new FieldVector3D(a, pv.position);
        this.velocity = new FieldVector3D(a, pv.velocity);
        this.acceleration = new FieldVector3D(a, pv.acceleration);
    }

    public FieldPVCoordinates(T a, PVCoordinates pv) {
        this.position = new FieldVector3D(a, pv.getPosition());
        this.velocity = new FieldVector3D(a, pv.getVelocity());
        this.acceleration = new FieldVector3D(a, pv.getAcceleration());
    }

    public FieldPVCoordinates(FieldPVCoordinates<T> start, FieldPVCoordinates<T> end) {
        this.position = end.position.subtract(start.position);
        this.velocity = end.velocity.subtract(start.velocity);
        this.acceleration = end.acceleration.subtract(start.acceleration);
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration());
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration());
    }

    public FieldPVCoordinates(double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3, double a4, FieldPVCoordinates<T> pv4) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position, a4, pv4.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity, a4, pv4.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration, a4, pv4.acceleration);
    }

    public FieldPVCoordinates(T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3, T a4, FieldPVCoordinates<T> pv4) {
        this.position = new FieldVector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position, a4, pv4.position);
        this.velocity = new FieldVector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity, a4, pv4.velocity);
        this.acceleration = new FieldVector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration, a4, pv4.acceleration);
    }

    public FieldPVCoordinates(T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3, T a4, PVCoordinates pv4) {
        this.position = new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition());
        this.velocity = new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity());
        this.acceleration = new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration());
    }

    public static <T extends RealFieldElement<T>> FieldPVCoordinates<T> getZero(Field<T> field) {
        return new FieldPVCoordinates<Field<T>>(field, PVCoordinates.ZERO);
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateVelocity(FieldVector3D<T> start, FieldVector3D<T> end, double dt) {
        double scale = 1.0 / dt;
        return new FieldVector3D(scale, end, -scale, start);
    }

    @Override
    public FieldPVCoordinates<T> shiftedBy(double dt) {
        return new FieldPVCoordinates<T>(new FieldVector3D(1.0, this.position, dt, this.velocity, 0.5 * dt * dt, this.acceleration), new FieldVector3D(1.0, this.velocity, dt, this.acceleration), this.acceleration);
    }

    public FieldPVCoordinates<T> shiftedBy(T dt) {
        RealFieldElement one = (RealFieldElement)dt.getField().getOne();
        return new FieldPVCoordinates<T>(new FieldVector3D(one, this.position, dt, this.velocity, (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), this.acceleration), new FieldVector3D(one, this.velocity, dt, this.acceleration), this.acceleration);
    }

    public FieldVector3D<T> getPosition() {
        return this.position;
    }

    public FieldVector3D<T> getVelocity() {
        return this.velocity;
    }

    public FieldVector3D<T> getAcceleration() {
        return this.acceleration;
    }

    public FieldVector3D<T> getMomentum() {
        return FieldVector3D.crossProduct(this.position, this.velocity);
    }

    public FieldVector3D<T> getAngularVelocity() {
        return this.getMomentum().scalarMultiply((RealFieldElement)this.getPosition().getNormSq().reciprocal());
    }

    public FieldPVCoordinates<T> negate() {
        return new FieldPVCoordinates<T>(this.position.negate(), this.velocity.negate(), this.acceleration.negate());
    }

    public FieldPVCoordinates<T> normalize() {
        RealFieldElement inv = (RealFieldElement)this.position.getNorm().reciprocal();
        FieldVector3D u = new FieldVector3D(inv, this.position);
        FieldVector3D v = new FieldVector3D(inv, this.velocity);
        FieldVector3D w = new FieldVector3D(inv, this.acceleration);
        RealFieldElement uv = FieldVector3D.dotProduct((FieldVector3D)u, (FieldVector3D)v);
        RealFieldElement v2 = FieldVector3D.dotProduct((FieldVector3D)v, (FieldVector3D)v);
        RealFieldElement uw = FieldVector3D.dotProduct((FieldVector3D)u, (FieldVector3D)w);
        FieldVector3D uDot = new FieldVector3D((RealFieldElement)inv.getField().getOne(), v, (RealFieldElement)uv.multiply(-1), u);
        FieldVector3D uDotDot = new FieldVector3D((RealFieldElement)inv.getField().getOne(), w, (RealFieldElement)uv.multiply(-2), v, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)uv.multiply((Object)uv)).multiply(3)).subtract((Object)v2)).subtract((Object)uw), u);
        return new FieldPVCoordinates<T>(u, uDot, uDotDot);
    }

    public FieldPVCoordinates<T> crossProduct(FieldPVCoordinates<T> pv2) {
        FieldVector3D<T> p1 = this.position;
        FieldVector3D<T> v1 = this.velocity;
        FieldVector3D<T> a1 = this.acceleration;
        FieldVector3D<T> p2 = pv2.position;
        FieldVector3D<T> v2 = pv2.velocity;
        FieldVector3D<T> a2 = pv2.acceleration;
        return new FieldPVCoordinates<T>(FieldVector3D.crossProduct(p1, p2), new FieldVector3D(1.0, FieldVector3D.crossProduct(p1, v2), 1.0, FieldVector3D.crossProduct(v1, p2)), new FieldVector3D(1.0, FieldVector3D.crossProduct(p1, a2), 2.0, FieldVector3D.crossProduct(v1, v2), 1.0, FieldVector3D.crossProduct(a1, p2)));
    }

    public PVCoordinates toPVCoordinates() {
        return new PVCoordinates(this.position.toVector3D(), this.velocity.toVector3D(), this.acceleration.toVector3D());
    }

    public String toString() {
        String comma = ", ";
        return new StringBuffer().append('{').append("P(").append(this.position.getX().getReal()).append(", ").append(this.position.getY().getReal()).append(", ").append(this.position.getZ().getReal()).append("), V(").append(this.velocity.getX().getReal()).append(", ").append(this.velocity.getY().getReal()).append(", ").append(this.velocity.getZ().getReal()).append("), A(").append(this.acceleration.getX().getReal()).append(", ").append(this.acceleration.getY().getReal()).append(", ").append(this.acceleration.getZ().getReal()).append(")}").toString();
    }
}

