/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.util.FastMath;
import org.orekit.models.earth.TroposphericModel;

public class MariniMurrayModel
implements TroposphericModel {
    private static final long serialVersionUID = 8442906721207317886L;
    private double T0;
    private double P0;
    private double e0;
    private double latitude;
    private double lambda;

    public MariniMurrayModel(double t0, double p0, double rh, double latitude, double lambda) {
        this.T0 = t0;
        this.P0 = p0;
        this.e0 = this.getWaterVapor(rh);
        this.latitude = latitude;
        this.lambda = lambda * 0.001;
    }

    public static MariniMurrayModel getStandardModel(double latitude, double frequency) {
        return new MariniMurrayModel(293.15, 1013.25, 0.5, latitude, frequency);
    }

    @Override
    public double pathDelay(double elevation, double height) {
        double A = 0.002357 * this.P0 + 1.41E-4 * this.e0;
        double K = 1.163 - 0.00968 * FastMath.cos((double)(2.0 * this.latitude)) - 0.00104 * this.T0 + 1.435E-5 * this.P0;
        double B = 1.0840000000000001E-8 * this.P0 * this.T0 * K + 4.734E-8 * this.P0 * (this.P0 / this.T0) * (2.0 * K) / (3.0 * K - 1.0);
        double flambda = this.getLaserFrequencyParameter();
        double fsite = this.getSiteFunctionValue(height / 1000.0);
        double sinE = FastMath.sin((double)elevation);
        double dR = flambda / fsite * (A + B) / (sinE + B / ((A + B) * (sinE + 0.01)));
        return dR;
    }

    private double getLaserFrequencyParameter() {
        return 0.965 + 0.0164 * FastMath.pow((double)this.lambda, (int)-2) + 2.28E-4 * FastMath.pow((double)this.lambda, (int)-4);
    }

    private double getSiteFunctionValue(double height) {
        return 1.0 - 0.0026 * FastMath.cos((double)(2.0 * this.latitude)) - 3.1E-4 * height;
    }

    private double getWaterVapor(double rh) {
        double es = 0.01 * FastMath.exp((double)(1.2378847000000001E-5 * this.T0 * this.T0 - 0.019121316 * this.T0 + 33.93711047 - 6343.164500000001 / this.T0));
        double fw = 1.00062 + 3.14E-6 * this.P0 + 5.599999999999999E-7 * FastMath.pow((double)(this.T0 - 273.15), (int)2);
        double e = rh / 100.0 * fw * es;
        return e;
    }
}

