/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class SolarRadiationPressure
extends AbstractForceModel {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private final double kRef;
    private final PVCoordinatesProvider sun;
    private final double equatorialRadius;
    private final RadiationSensitive spacecraft;

    public SolarRadiationPressure(PVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft);
    }

    public SolarRadiationPressure(double dRef, double pRef, PVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft) {
        this.kRef = pRef * dRef * dRef;
        this.sun = sun;
        this.equatorialRadius = equatorialRadius;
        this.spacecraft = spacecraft;
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) throws OrekitException {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        Vector3D sunSatVector = position.subtract((Vector)this.sun.getPVCoordinates(date, frame).getPosition());
        double r2 = sunSatVector.getNormSq();
        double ratio = this.getLightingRatio(position, frame, date);
        double rawP = ratio * this.kRef / r2;
        Vector3D flux = new Vector3D(rawP / FastMath.sqrt((double)r2), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), flux, parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) throws OrekitException {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D position = s.getPVCoordinates().getPosition();
        FieldVector3D sunSatVector = position.subtract(this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition());
        RealFieldElement r2 = sunSatVector.getNormSq();
        Object ratio = this.getLightingRatio(position, frame, date);
        RealFieldElement rawP = (RealFieldElement)((RealFieldElement)ratio.divide((Object)r2)).multiply(this.kRef);
        FieldVector3D flux = new FieldVector3D((RealFieldElement)rawP.divide(r2.sqrt()), sunSatVector);
        return this.spacecraft.radiationPressureAcceleration(date, frame, position, (FieldRotation)s.getAttitude().getRotation(), (RealFieldElement)s.getMass(), flux, (RealFieldElement[])parameters);
    }

    public double getLightingRatio(Vector3D position, Frame frame, AbsoluteDate date) throws OrekitException {
        Vector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        if (sunPosition.getNorm() < 1.391E9) {
            return 1.0;
        }
        double[] angle = this.getEclipseAngles(sunPosition, position);
        double sunSatCentralBodyAngle = angle[0];
        double alphaCentral = angle[1];
        double alphaSun = angle[2];
        double result = 1.0;
        if (sunSatCentralBodyAngle - alphaCentral + alphaSun <= 1.0E-10) {
            result = 0.0;
        } else if (sunSatCentralBodyAngle - alphaCentral - alphaSun < -1.0E-10) {
            double sEA2 = sunSatCentralBodyAngle * sunSatCentralBodyAngle;
            double oo2sEA = 1.0 / (2.0 * sunSatCentralBodyAngle);
            double aS2 = alphaSun * alphaSun;
            double aE2 = alphaCentral * alphaCentral;
            double aE2maS2 = aE2 - aS2;
            double alpha1 = (sEA2 - aE2maS2) * oo2sEA;
            double alpha2 = (sEA2 + aE2maS2) * oo2sEA;
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            double a1oaS = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha1 / alphaSun)));
            double aS2ma12 = FastMath.max((double)almost0, (double)(aS2 - alpha1 * alpha1));
            double a2oaE = FastMath.min((double)almost1, (double)FastMath.max((double)(-almost1), (double)(alpha2 / alphaCentral)));
            double aE2ma22 = FastMath.max((double)almost0, (double)(aE2 - alpha2 * alpha2));
            double P1 = aS2 * FastMath.acos((double)a1oaS) - alpha1 * FastMath.sqrt((double)aS2ma12);
            double P2 = aE2 * FastMath.acos((double)a2oaE) - alpha2 * FastMath.sqrt((double)aE2ma22);
            result = 1.0 - (P1 + P2) / (Math.PI * aS2);
        }
        return result;
    }

    public <T extends RealFieldElement<T>> T getLightingRatio(FieldVector3D<T> position, Frame frame, FieldAbsoluteDate<T> date) throws OrekitException {
        RealFieldElement one = (RealFieldElement)date.getField().getOne();
        Vector3D sunPosition = this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition();
        if (sunPosition.getNorm() < 1.391E9) {
            return (T)one;
        }
        RealFieldElement[] angle = this.getEclipseAngles(sunPosition, position);
        RealFieldElement sunsatCentralBodyAngle = angle[0];
        RealFieldElement alphaCentral = angle[1];
        RealFieldElement alphaSun = angle[2];
        RealFieldElement result = one;
        if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() + alphaSun.getReal() <= 1.0E-10) {
            result = (RealFieldElement)date.getField().getZero();
        } else if (sunsatCentralBodyAngle.getReal() - alphaCentral.getReal() - alphaSun.getReal() < -1.0E-10) {
            RealFieldElement sEA2 = (RealFieldElement)sunsatCentralBodyAngle.multiply((Object)sunsatCentralBodyAngle);
            RealFieldElement oo2sEA = (RealFieldElement)((RealFieldElement)sunsatCentralBodyAngle.multiply(2)).reciprocal();
            RealFieldElement aS2 = (RealFieldElement)alphaSun.multiply((Object)alphaSun);
            RealFieldElement aE2 = (RealFieldElement)alphaCentral.multiply((Object)alphaCentral);
            RealFieldElement aE2maS2 = (RealFieldElement)aE2.subtract((Object)aS2);
            RealFieldElement alpha1 = (RealFieldElement)((RealFieldElement)sEA2.subtract((Object)aE2maS2)).multiply((Object)oo2sEA);
            RealFieldElement alpha2 = (RealFieldElement)((RealFieldElement)sEA2.add((Object)aE2maS2)).multiply((Object)oo2sEA);
            double almost0 = Precision.SAFE_MIN;
            double almost1 = FastMath.nextDown((double)1.0);
            RealFieldElement a1oaS = this.min(almost1, this.max(-almost1, (RealFieldElement)alpha1.divide((Object)alphaSun)));
            RealFieldElement aS2ma12 = this.max(almost0, (RealFieldElement)aS2.subtract(alpha1.multiply((Object)alpha1)));
            RealFieldElement a2oaE = this.min(almost1, this.max(-almost1, (RealFieldElement)alpha2.divide((Object)alphaCentral)));
            RealFieldElement aE2ma22 = this.max(almost0, (RealFieldElement)aE2.subtract(alpha2.multiply((Object)alpha2)));
            RealFieldElement P1 = (RealFieldElement)((RealFieldElement)aS2.multiply(a1oaS.acos())).subtract(alpha1.multiply(aS2ma12.sqrt()));
            RealFieldElement P2 = (RealFieldElement)((RealFieldElement)aE2.multiply(a2oaE.acos())).subtract(alpha2.multiply(aE2ma22.sqrt()));
            result = (RealFieldElement)one.subtract(((RealFieldElement)P1.add((Object)P2)).divide(aS2.multiply(Math.PI)));
        }
        return (T)result;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.of(new UmbraDetector(), new PenumbraDetector());
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    private double[] getEclipseAngles(Vector3D sunPosition, Vector3D position) throws OrekitException {
        double[] angle = new double[3];
        Vector3D satSunVector = sunPosition.subtract((Vector)position);
        angle[0] = Vector3D.angle((Vector3D)satSunVector, (Vector3D)position.negate());
        double r = position.getNorm();
        if (r <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = FastMath.asin((double)(this.equatorialRadius / r));
        angle[2] = FastMath.asin((double)(6.955E8 / satSunVector.getNorm()));
        return angle;
    }

    private <T extends RealFieldElement<T>> T[] getEclipseAngles(Vector3D sunPosition, FieldVector3D<T> position) throws OrekitException {
        RealFieldElement[] angle = (RealFieldElement[])MathArrays.buildArray((Field)position.getX().getField(), (int)3);
        FieldVector3D mP = position.negate();
        FieldVector3D satSunVector = mP.add(sunPosition);
        angle[0] = FieldVector3D.angle((FieldVector3D)satSunVector, (FieldVector3D)mP);
        RealFieldElement r = position.getNorm();
        if (r.getReal() <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)r.reciprocal()).multiply(this.equatorialRadius)).asin();
        angle[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)satSunVector.getNorm().reciprocal()).multiply(6.955E8)).asin();
        return angle;
    }

    private <T extends RealFieldElement<T>> T min(double d, T f) {
        return (T)(f.getReal() > d ? (RealFieldElement)((RealFieldElement)f.getField().getZero()).add(d) : f);
    }

    private <T extends RealFieldElement<T>> T max(double d, T f) {
        return (T)(f.getReal() <= d ? (RealFieldElement)((RealFieldElement)f.getField().getZero()).add(d) : f);
    }

    private class PenumbraDetector
    extends AbstractDetector<PenumbraDetector> {
        private static final long serialVersionUID = 20141228L;

        PenumbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<PenumbraDetector>(){

                @Override
                public EventHandler.Action eventOccurred(SpacecraftState s, PenumbraDetector detector, boolean increasing) {
                    return EventHandler.Action.RESET_DERIVATIVES;
                }
            });
        }

        private PenumbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super PenumbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected PenumbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super PenumbraDetector> newHandler) {
            return new PenumbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) throws OrekitException {
            double[] angle = SolarRadiationPressure.this.getEclipseAngles(SolarRadiationPressure.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] - angle[2] + 1.0E-10;
        }
    }

    private class UmbraDetector
    extends AbstractDetector<UmbraDetector> {
        private static final long serialVersionUID = 20141228L;

        UmbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<UmbraDetector>(){

                @Override
                public EventHandler.Action eventOccurred(SpacecraftState s, UmbraDetector detector, boolean increasing) {
                    return EventHandler.Action.RESET_DERIVATIVES;
                }
            });
        }

        private UmbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super UmbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected UmbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super UmbraDetector> newHandler) {
            return new UmbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) throws OrekitException {
            double[] angle = SolarRadiationPressure.this.getEclipseAngles(SolarRadiationPressure.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] + angle[2] - 1.0E-10;
        }
    }
}

