/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.util.ArrayList;
import java.util.Collection;
import org.hipparchus.distribution.continuous.FDistribution;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.StreamingStatistics;
import org.hipparchus.util.MathUtils;

public class OneWayAnova {
    public double anovaFValue(Collection<double[]> categoryData) throws MathIllegalArgumentException, NullArgumentException {
        AnovaStats a = this.anovaStats(categoryData);
        return a.F;
    }

    public double anovaPValue(Collection<double[]> categoryData) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        AnovaStats a = this.anovaStats(categoryData);
        FDistribution fdist = new FDistribution((double)a.dfbg, (double)a.dfwg);
        return 1.0 - fdist.cumulativeProbability(a.F);
    }

    public double anovaPValue(Collection<StreamingStatistics> categoryData, boolean allowOneElementData) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        AnovaStats a = this.anovaStats(categoryData, allowOneElementData);
        FDistribution fdist = new FDistribution((double)a.dfbg, (double)a.dfwg);
        return 1.0 - fdist.cumulativeProbability(a.F);
    }

    private AnovaStats anovaStats(Collection<double[]> categoryData) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(categoryData);
        ArrayList<StreamingStatistics> categoryDataSummaryStatistics = new ArrayList<StreamingStatistics>(categoryData.size());
        for (double[] data : categoryData) {
            StreamingStatistics dataSummaryStatistics = new StreamingStatistics();
            categoryDataSummaryStatistics.add(dataSummaryStatistics);
            for (double val : data) {
                dataSummaryStatistics.addValue(val);
            }
        }
        return this.anovaStats(categoryDataSummaryStatistics, false);
    }

    public boolean anovaTest(Collection<double[]> categoryData, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, new Object[]{alpha, 0, 0.5});
        }
        return this.anovaPValue(categoryData) < alpha;
    }

    private AnovaStats anovaStats(Collection<StreamingStatistics> categoryData, boolean allowOneElementData) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(categoryData);
        if (!allowOneElementData) {
            if (categoryData.size() < 2) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.TWO_OR_MORE_CATEGORIES_REQUIRED, new Object[]{categoryData.size(), 2});
            }
            for (StreamingStatistics array : categoryData) {
                if (array.getN() > 1L) continue;
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED, new Object[]{(int)array.getN(), 2});
            }
        }
        int dfwg = 0;
        double sswg = 0.0;
        double totsum = 0.0;
        double totsumsq = 0.0;
        int totnum = 0;
        for (StreamingStatistics data : categoryData) {
            double sum = data.getSum();
            double sumsq = data.getSumOfSquares();
            int num = (int)data.getN();
            totnum += num;
            totsum += sum;
            totsumsq += sumsq;
            dfwg += num - 1;
            double ss = sumsq - sum * sum / (double)num;
            sswg += ss;
        }
        double sst = totsumsq - totsum * totsum / (double)totnum;
        double ssbg = sst - sswg;
        int dfbg = categoryData.size() - 1;
        double msbg = ssbg / (double)dfbg;
        double mswg = sswg / (double)dfwg;
        double F = msbg / mswg;
        return new AnovaStats(dfbg, dfwg, F);
    }

    private static class AnovaStats {
        private final int dfbg;
        private final int dfwg;
        private final double F;

        private AnovaStats(int dfbg, int dfwg, double F) {
            this.dfbg = dfbg;
            this.dfwg = dfwg;
            this.F = F;
        }
    }
}

