/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.FieldAbsoluteDate;

public class FieldEventsLogger<T extends RealFieldElement<T>> {
    private final List<FieldLoggedEvent<T>> log = new ArrayList<FieldLoggedEvent<T>>();

    public <D extends FieldEventDetector<T>> FieldEventDetector<T> monitorDetector(D monitoredDetector) {
        return new FieldLoggingWrapper(this, monitoredDetector);
    }

    public void clearLoggedEvents() {
        this.log.clear();
    }

    public List<FieldLoggedEvent<T>> getLoggedEvents() {
        return new ArrayList<FieldLoggedEvent<T>>(this.log);
    }

    private class FieldLocalHandler<D extends FieldEventDetector<T>>
    implements FieldEventHandler<FieldLoggingWrapper<D>, T> {
        private FieldLocalHandler() {
        }

        @Override
        public FieldEventHandler.Action eventOccurred(FieldSpacecraftState<T> s, FieldLoggingWrapper<D> wrapper, boolean increasing) throws OrekitException {
            wrapper.logEvent(s, increasing);
            return ((FieldLoggingWrapper)wrapper).detector.eventOccurred(s, increasing);
        }

        @Override
        public FieldSpacecraftState<T> resetState(FieldLoggingWrapper<D> wrapper, FieldSpacecraftState<T> oldState) throws OrekitException {
            return ((FieldLoggingWrapper)wrapper).detector.resetState(oldState);
        }
    }

    private static class FieldLoggingWrapper<D extends FieldEventDetector<T>>
    extends FieldAbstractDetector<FieldLoggingWrapper<D>, T> {
        private final D detector;
        final /* synthetic */ FieldEventsLogger this$0;

        FieldLoggingWrapper(D detector) {
            this(var1_1, (RealFieldElement)detector.getMaxCheckInterval(), (RealFieldElement)detector.getThreshold(), detector.getMaxIterationCount(), var1_1.new FieldLocalHandler(), (FieldEventDetector)detector);
        }

        private FieldLoggingWrapper(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldLoggingWrapper<D>, T> handler, D detector) {
            this.this$0 = var1_1;
            super(maxCheck, threshold, maxIter, handler);
            this.detector = detector;
        }

        @Override
        protected FieldLoggingWrapper<D> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldLoggingWrapper<D>, T> newHandler) {
            return new FieldLoggingWrapper(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler, this.detector);
        }

        public void logEvent(FieldSpacecraftState<T> state, boolean increasing) {
            this.this$0.log.add(new FieldLoggedEvent((FieldEventDetector)this.detector, state, increasing));
        }

        @Override
        public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
            this.detector.init(s0, t);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) throws OrekitException {
            return this.detector.g(s);
        }
    }

    public static class FieldLoggedEvent<T extends RealFieldElement<T>> {
        private final FieldEventDetector<T> detector;
        private final FieldSpacecraftState<T> state;
        private final boolean increasing;

        private FieldLoggedEvent(FieldEventDetector<T> detectorN, FieldSpacecraftState<T> stateN, boolean increasingN) {
            this.detector = detectorN;
            this.state = stateN;
            this.increasing = increasingN;
        }

        public FieldEventDetector<T> getEventDetector() {
            return this.detector;
        }

        public FieldSpacecraftState<T> getState() {
            return this.state;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }
    }
}

